/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.ContentFilterCustomizer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.model.NewWorkingSetPanel;
import oracle.jdevimpl.navigator.LibraryFolder;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.navigator.WorkingSetsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WorkingSetSupport
extends NavigatorInit
implements Controller {
    private static IdeAction _addToWorkingSetAction;
    private static IdeAction _newFromSelectionAction;
    private static IdeAction _hideSelectionAction;
    private static IdeAction _unhideAction;
    private static IdeAction _unhideAllAction;
    private static IdeAction _manageWorkingSetsAction;
    private static WorkspaceCML _workspaceCML;
    private static final WorkingSetNonAction WORKING_SET_NON_ACTION;
    private static MenuToolButton _workingSetMenu;
    private static final String ACTION_WORK_SET_PREFIX = "working-set-";

    private static MenuToolButton getWorkingSetMenu() {
        if (_workingSetMenu == null) {
            _workingSetMenu = new MenuToolButton((ToggleAction)WORKING_SET_NON_ACTION);
        }
        return _workingSetMenu;
    }

    static void init(ProjectNavigatorManager nav) {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(WorkingSetSupport.class.getClassLoader(), "oracle/jdevimpl/navigator/accelerators.xml");
        nav.addNavigatorInit(new NavigatorInitFactory(WorkingSetSupport.class));
        if (_workspaceCML == null) {
            _workspaceCML = new WorkspaceCML();
            nav.addContextMenuListener((ContextMenuListener)_workspaceCML, Workspace.class);
        }
    }

    WorkingSetSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
        Workspace workspace;
        WorkingSetSupport.getWorkingSetMenu().addPopupMenuListener((PopupMenuListener)new 1());
        this.createAddToWorkingSetAction();
        if (_manageWorkingSetsAction == null) {
            IdeAction action = this.createManageWorkingSetsAction();
            JMenu viewMenu = IdeMenus.findOrCreateJMenu((String)"ViewOptions");
            JMenuItem manageWorkingSets = IdeMenus.createMenuItem((IdeAction)action, (float)MenuConstants.increment((float)MenuConstants.WEIGHT_TOOLS_DEFAULT_PROJECT_PROPERTIES));
            Ide.getMenubar().add((Component)manageWorkingSets, viewMenu, MenuConstants.SECTION_VIEW_OPTIONS_MANAGE_WORKING_SETS);
        }
        if ((workspace = context.getWorkspace()) != null) {
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            String curWorkingSetName = workingSets.getCurrentWorkingSetName();
            WorkingSetSupport.updateWorkingSetsTooltip(curWorkingSetName);
        }
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean("enable-working-sets", true);
    }

    public void initToolbar(Toolbar toolbar) {
        WorkingSetSupport.getWorkingSetMenu().setAction((Action)((Object)WORKING_SET_NON_ACTION));
        toolbar.add((Component)WorkingSetSupport.getWorkingSetMenu(), 2);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Workspace workspace = context.getWorkspace();
        String workingSetName = (String)action.getValue("Name");
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
        workingSets.setCurrentWorkingSetName(workingSetName);
        UpdateMessage.fireStructureChanged((Subject)workspace);
        this.maybeNotifyActiveProjectChanged(context, workingSets.getWorkingSet(workingSetName));
        new SaveThread(workspace).start();
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        action.setEnabled(context.getWorkspace() != null);
        return true;
    }

    private void repopulateWorkingSetMenu(JPopupMenu popup) {
        WorkingSetSupport.getWorkingSetMenu().removeAllPopupItems();
        NavigatorWindow navWin = this.getNavigatorWindow();
        Context context = navWin.getContext();
        if (context != null) {
            Workspace workspace = context.getWorkspace();
            if (workspace != null) {
                WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
                String curWorkingSetName = workingSets.getCurrentWorkingSetName();
                WorkingSetSupport.updateWorkingSetsTooltip(curWorkingSetName);
                List workingSetNames = workingSets.getWorkingSetNames();
                Iterator iter = workingSetNames.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    String workSetName = iter.next().toString();
                    IdeAction action = this.createWorkSetToggleAction(i++, workSetName);
                    if (workSetName.equals(curWorkingSetName)) {
                        action.putValue("State", (Object)Boolean.TRUE);
                    }
                    WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
                }
                if (i > 0) {
                    popup.addSeparator();
                }
            }
            IdeAction action = this.createHideSelectionAction();
            action.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
            IdeAction action2 = this.createUnhideAction();
            action2.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action2);
            IdeAction action3 = this.createUnhideAllAction();
            action3.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action3);
            popup.addSeparator();
            IdeAction action4 = this.createNewFromSelectionAction();
            action4.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action4);
            IdeAction action5 = this.createManageWorkingSetsAction();
            action5.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action5);
        }
    }

    private void maybeNotifyActiveProjectChanged(Context context, WorkingSet workingSet) {
        Project currentProject = context.getProject();
        if (currentProject == null || !workingSet.isExcluded(currentProject)) {
            return;
        }
        boolean foundProjectNode = false;
        TNode activeProjectNode = null;
        NavigatorWindow navWin = this.getNavigatorWindow();
        TreeExplorer explorer = navWin.getTreeExplorer();
        Enumeration tNodes = explorer.getRoot().getChildTNodes();
        while (tNodes.hasMoreElements()) {
            Project p;
            TNode next = (TNode)tNodes.nextElement();
            if (!foundProjectNode && next.getData() == currentProject) {
                foundProjectNode = true;
                if (activeProjectNode == null) continue;
                break;
            }
            if (!(next.getData() instanceof Project) || !workingSet.isIncluded(p = (Project)next.getData())) continue;
            activeProjectNode = next;
            if (foundProjectNode) break;
        }
        if (activeProjectNode != null) {
            explorer.setSelected(activeProjectNode);
        }
    }

    private IdeAction createNewFromSelectionAction() {
        if (_newFromSelectionAction == null) {
            _newFromSelectionAction = this.createAction("working-set-new-from-selection", Res.getString(34), Res.getInteger(5), null);
            2 newFromSelectionController = new 2();
            _newFromSelectionAction.addController((Controller)newFromSelectionController);
        }
        return _newFromSelectionAction;
    }

    private IdeAction createUnhideAction() {
        if (_unhideAction == null) {
            _unhideAction = this.createAction("working-set-unhide-children", Res.getString(21), Res.getInteger(19), null);
            3 unhideController = new 3();
            _unhideAction.addController((Controller)unhideController);
        }
        return _unhideAction;
    }

    private IdeAction createUnhideAllAction() {
        if (_unhideAllAction == null) {
            _unhideAllAction = this.createAction("working-set-unhide-all-children", Res.getString(35), Res.getInteger(24), null);
            4 unhideAllController = new 4();
            _unhideAllAction.addController((Controller)unhideAllController);
        }
        return _unhideAllAction;
    }

    private IdeAction createHideSelectionAction() {
        if (_hideSelectionAction == null) {
            _hideSelectionAction = this.createAction("working-set-hide-selection", Res.getString(23), Res.getInteger(7), null);
            5 hideSelectionController = new 5();
            _hideSelectionAction.addController((Controller)hideSelectionController);
        }
        return _hideSelectionAction;
    }

    private IdeAction createAddToWorkingSetAction() {
        if (_addToWorkingSetAction == null) {
            int commandID = Ide.findOrCreateCmdID((String)"working-set-add-to-working-set");
            String text = Res.getString(3);
            String label = StringUtils.stripMnemonic((String)text);
            String category = MenuManager.getJMenu((String)"Tools").getText();
            char mnemonicKeyCode = Res.getMnemonic(36);
            _addToWorkingSetAction = IdeAction.get((int)commandID, null, (String)label, (String)category, (Integer)new Integer(mnemonicKeyCode), (ResourceBundle)Res.getInstance(), null, null, (boolean)false);
            _addToWorkingSetAction.addController((Controller)new AddToWorkingSetController(null));
        }
        return _addToWorkingSetAction;
    }

    private IdeAction createManageWorkingSetsAction() {
        if (_manageWorkingSetsAction == null) {
            _manageWorkingSetsAction = this.createAction("working-set-manage-working-sets", Res.getString(15), Res.getInteger(14), null);
            6 manageWorkingSetsController = new 6();
            _manageWorkingSetsAction.addController((Controller)manageWorkingSetsController);
        }
        return _manageWorkingSetsAction;
    }

    private static void saveWorkingSetChanges(Workspace workspace, Runnable runnable) {
        workspace.applyBatchChanges(runnable);
        try {
            workspace.saveUserProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private WorkingSet getEditableWorkingSet(Workspace workspace) {
        WorkingSet activeWorkingSet;
        if (workspace != null && !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals((activeWorkingSet = WorkingSetSupport.getActiveWorkingSet(workspace)).getName())) {
            return activeWorkingSet;
        }
        return null;
    }

    private static WorkingSet getActiveWorkingSet(Workspace workspace) {
        return WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet();
    }

    private boolean canHide(Context context) {
        return this.canHandleSelection(context, true);
    }

    private boolean canNewFromSelection(Context context) {
        return this.canHandleSelection(context, false);
    }

    private boolean canHandleSelection(Context context, boolean activeWorkingSetMustBeEditable) {
        if (context.getSelection().length == 0) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return false;
        }
        if (activeWorkingSetMustBeEditable && this.getEditableWorkingSet(workspace) == null) {
            return false;
        }
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            URLPath srcPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            int i = 0;
            while (i < nodes.length) {
                TNode node = nodes[i];
                TreeNode[] pathToNode = node.getPath();
                int x = pathToNode.length - 1;
                while (x > 0) {
                    TNode ancestor = (TNode)pathToNode[x];
                    Element dataElement = ancestor.getData();
                    if (dataElement instanceof LibraryFolder) break;
                    if (dataElement instanceof Project && context.getSelection().length == 1) {
                        return true;
                    }
                    if (dataElement instanceof Locatable) {
                        URL url = ((Locatable)dataElement).getURL();
                        String pattern = srcPath.toShortestRelativePath(url);
                        if (pattern != null) {
                            return true;
                        }
                    } else if (dataElement instanceof RelativeDirectoryContextFolder) {
                        RelativeDirectoryContextFolder df = (RelativeDirectoryContextFolder)dataElement;
                        String relPath = df.getRelativePath();
                        if (relPath == null || relPath.length() <= 0) break;
                        URL url = srcPath.toQualifiedURL(relPath);
                        if (url != null) {
                            return true;
                        }
                    }
                    --x;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canUnhide(Context context) {
        if (context.getSelection().length == 0) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return false;
        }
        WorkingSet appWorkingSet = this.getEditableWorkingSet(workspace);
        if (appWorkingSet == null) {
            return false;
        }
        PatternFilters patternFilters = appWorkingSet.getPatternFilters(project);
        if (patternFilters == null) {
            return false;
        }
        if (!patternFilters.containsFilters()) {
            return false;
        }
        PatternFilter[] filters = patternFilters.getFilters();
        URLPath srcPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                URL url;
                RelativeDirectoryContextFolder df;
                String relPath;
                TNode node = nodes[i];
                Element dataElement = node.getData();
                if (dataElement instanceof Project && context.getSelection().length == 1) {
                    boolean noInclude = true;
                    int y = 0;
                    while (y < filters.length) {
                        if (filters[y].isExclude()) {
                            return true;
                        }
                        if (noInclude && "**".equals(filters[y].getPattern())) {
                            noInclude = false;
                        }
                        ++y;
                    }
                    if (noInclude) {
                        return true;
                    }
                }
                if (dataElement instanceof RelativeDirectoryContextFolder && (relPath = (df = (RelativeDirectoryContextFolder)dataElement).getRelativePath()) != null && !"".equals(relPath) && (url = srcPath.toQualifiedURL(relPath)) != null) {
                    if (!patternFilters.isIncluded(relPath)) {
                        return true;
                    }
                    int j = 0;
                    while (j < filters.length) {
                        String pttrn = filters[j].getPattern();
                        if (filters[j].isExclude() && (pttrn.indexOf("**") >= 0 || pttrn.startsWith(relPath))) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private CompoundPattern[] getPatternsForSelection(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            Project project = context.getProject();
            ArrayList<CompoundPattern> patterns = new ArrayList<CompoundPattern>();
            TNode[] tNodeArray = nodes;
            int n = 0;
            while (n < tNodeArray.length) {
                TNode node = tNodeArray[n];
                Element dataElement = node.getData();
                if (dataElement instanceof Locatable) {
                    URL url = ((Locatable)dataElement).getURL();
                    TNode parentTNode = node.getAncestorTNode(RelativeDirectoryContextFolder.class, true);
                    if (parentTNode != null) {
                        RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)parentTNode.getData();
                        String relPath = folder.getRelativePath();
                        if (relPath.length() > 0) {
                            String pattern = relPath + "/" + node.toString();
                            patterns.add(new CompoundPattern(pattern));
                        } else {
                            URLPath roots = folder.getRootDirectories();
                            String pattern = roots.toShortestRelativePath(url);
                            if (pattern != null) {
                                patterns.add(new CompoundPattern(pattern));
                            }
                        }
                    } else {
                        NavigatorWindow navWin = this.getNavigatorWindow();
                        if (navWin != null) {
                            URLPath pathsToSearch = this.getRelevantSourceRoots(project, url);
                            URL[] uRLArray = pathsToSearch.getEntries();
                            int n2 = 0;
                            while (n2 < uRLArray.length) {
                                URL nextURL = uRLArray[n2];
                                String pattern = new URLPath(nextURL).toRelativePath(url);
                                if (pattern != null) {
                                    patterns.add(new CompoundPattern(pattern));
                                }
                                ++n2;
                            }
                        }
                    }
                } else if (dataElement instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder df = (RelativeDirectoryContextFolder)dataElement;
                    String relPath = df.getRelativePath();
                    CompoundPattern compoundPattern = new CompoundPattern(relPath);
                    patterns.add(compoundPattern);
                    URLPath allRootDirs = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
                    List<String> subs = this.getImpliedSubPatterns(node, relPath, allRootDirs);
                    if (subs.size() > 0) {
                        compoundPattern.addAdditionalFilter(subs);
                    }
                }
                ++n;
            }
            return patterns.toArray(new CompoundPattern[patterns.size()]);
        }
        return new CompoundPattern[0];
    }

    private URLPath getRelevantSourceRoots(Project project, URL url) {
        URLPath paths = new URLPath();
        ProjectContent content = ProjectContent.getInstance((PropertyStorage)project);
        ListStructure contentSetNames = content.getContentSetList();
        Iterator iterator = contentSetNames.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next().toString();
            ContentSet cs = content.getContentSet(id);
            if (cs == null || !cs.canHaveMember(url)) continue;
            URL[] uRLArray = cs.getAllRootDirs().getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                URL path = uRLArray[n];
                String relPath = new URLPath(path).toRelativePath(url);
                if (relPath != null && relPath.length() > 0) {
                    paths.add(path);
                }
                ++n;
            }
        }
        return paths;
    }

    private CompoundPattern[] getUnhidePatternsSelection(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            Project project = context.getProject();
            URLPath projectSrcPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            ArrayList<CompoundPattern> patterns = new ArrayList<CompoundPattern>();
            TNode[] tNodeArray = nodes;
            int n = 0;
            while (n < tNodeArray.length) {
                RelativeDirectoryContextFolder df;
                String relPath;
                URL url;
                TNode node = tNodeArray[n];
                Element dataElement = node.getData();
                if (dataElement instanceof Project && context.getSelection().length == 1) {
                    patterns.add(new CompoundPattern("**"));
                    break;
                }
                if (dataElement instanceof RelativeDirectoryContextFolder && (url = projectSrcPath.toQualifiedURL(relPath = (df = (RelativeDirectoryContextFolder)dataElement).getRelativePath())) != null) {
                    CompoundPattern compoundPattern = new CompoundPattern(relPath);
                    patterns.add(compoundPattern);
                    List<String> contained = this.getImpliedSubPatterns(node, relPath, projectSrcPath);
                    if (contained.size() > 0) {
                        compoundPattern.addAdditionalFilter(contained);
                    }
                }
                ++n;
            }
            return patterns.toArray(new CompoundPattern[patterns.size()]);
        }
        return new CompoundPattern[0];
    }

    private List<String> getImpliedSubPatterns(TNode tNode, String rootPath, URLPath projectSrcPath) {
        ArrayList<String> implied = new ArrayList<String>();
        boolean shouldBreak = false;
        TNode parent = (TNode)tNode.getParent();
        Enumeration children = parent.getChildTNodes();
        while (children.hasMoreElements()) {
            RelativeDirectoryContextFolder subFolder;
            String subPath;
            URL subURL;
            TNode subnode = (TNode)children.nextElement();
            Element subDataElement = subnode.getData();
            if (subDataElement instanceof Locatable) {
                subDataElement = ((TNode)subnode.getParent()).getData();
            }
            if (!(subDataElement instanceof RelativeDirectoryContextFolder) || (subURL = projectSrcPath.toQualifiedURL(subPath = (subFolder = (RelativeDirectoryContextFolder)subDataElement).getRelativePath())) == null) continue;
            if (subPath.startsWith(rootPath) && !subPath.equals(rootPath)) {
                implied.add(subPath);
                shouldBreak = true;
                continue;
            }
            if (shouldBreak) break;
        }
        return implied;
    }

    private void simplifyFilters(PatternFilters filters) {
        PatternFilter[] allFilters = filters.getFilters();
        if (allFilters.length > 0 && allFilters[0].getPattern().equals("**")) {
            filters.setFilters(new PatternFilter[]{allFilters[0]});
        } else {
            int marker = allFilters.length;
            int i = 0;
            while (i < allFilters.length) {
                if ("**".equals(allFilters[i].getPattern())) {
                    marker = i + 1;
                    break;
                }
                ++i;
            }
            if (marker < allFilters.length) {
                PatternFilter[] simplified = new PatternFilter[marker];
                System.arraycopy(allFilters, 0, simplified, 0, marker);
                filters.setFilters(simplified);
            }
        }
    }

    private static String[] getInitialSelectionPath(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null && nodes.length > 0) {
            RelativeDirectoryContextFolder df;
            String relPath;
            TNode node = nodes[0];
            String fileName = null;
            Element dataElement = node.getData();
            if (dataElement instanceof Locatable) {
                URL url = ((Locatable)dataElement).getURL();
                fileName = "/" + URLFileSystem.getFileName((URL)url);
                TNode parentNode = (TNode)node.getParent();
                if (parentNode != null) {
                    dataElement = parentNode.getData();
                }
            }
            if (dataElement instanceof RelativeDirectoryContextFolder && (relPath = (df = (RelativeDirectoryContextFolder)dataElement).getRelativePath()) != null && relPath.length() > 0) {
                if (fileName != null) {
                    relPath = relPath + fileName;
                }
                return relPath.split("/");
            }
        } else {
            Node node = context.getNode();
            if (node != null) {
                URL url = node.getURL();
                String relPath = ProjectContent.getInstance((PropertyStorage)context.getProject()).getAllContents().getAllRootDirs().toShortestRelativePath(url);
                if (relPath != null && !"".equals(relPath)) {
                    return relPath.split("/");
                }
            }
        }
        return new String[0];
    }

    private Runnable doUnhide(Context context, PatternFilters filters, CompoundPattern[] compoundPatterns, boolean unhideAll) {
        return new 7(this, compoundPatterns, filters, context, unhideAll);
    }

    private Runnable doAddFilters(PatternFilters filters, CompoundPattern[] compoundPatterns, boolean unhide) {
        return new 8(this, compoundPatterns, unhide, filters);
    }

    private IdeAction createWorkSetToggleAction(int suffix, String workSetName) {
        IdeAction action = this.createAction(ACTION_WORK_SET_PREFIX + suffix, workSetName, null, null);
        action.addController((Controller)this);
        action.putValue("Name", (Object)workSetName);
        action.putValue("Check", (Object)Boolean.TRUE);
        action.putValue("State", (Object)Boolean.FALSE);
        return action;
    }

    private IdeAction createAction(String cmd, String name, Integer mnemonic, Icon icon) {
        int cmdID = Ide.findOrCreateCmdID((String)cmd);
        String viewCategory = MenuManager.getJMenu((String)"View").getText();
        return IdeAction.get((int)cmdID, (String)cmd, (String)name, (String)viewCategory, (Integer)mnemonic, (Icon)icon, null, (boolean)true);
    }

    private int calculateDepth(String relPath) {
        int count = 1;
        char[] characters = relPath.toCharArray();
        int i = 0;
        while (i < characters.length) {
            if (characters[i] == '/') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static void showManageWorkingSetsDialog(Context context) {
        String title;
        Workspace workspace = context.getWorkspace();
        Workspace workspaceCopy = (Workspace)workspace.copyTo(null);
        WorkingSetsPanel panel = new WorkingSetsPanel();
        Namespace data = new Namespace();
        data.put("Application", (Object)workspaceCopy);
        Project selectedProject = context.getProject();
        if (selectedProject != null) {
            data.put("Project", (Object)selectedProject);
        }
        data.put("initial-selection", (Object)WorkingSetSupport.getInitialSelectionPath(context));
        ArrayList<Project> projects = new ArrayList<Project>();
        data.put("projects", projects);
        Iterator iter = workspace.getChildren();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof Project)) continue;
            Project project = (Project)next;
            projects.add(project);
        }
        IdeMainWindow parent = Ide.getMainWindow();
        TDialogLauncher dialogLauncher = new TDialogLauncher((Component)parent, title = Res.getString(10), (Traversable)panel, data);
        if (dialogLauncher.showDialog()) {
            workspace.applyBatchChanges((Runnable)new 9(workspaceCopy, workspace));
            UpdateMessage.fireStructureChanged((Subject)workspace);
            new SaveThread(workspace).start();
        }
    }

    private static void updateWorkingSetsTooltip(String currentWorkingSetName) {
        String mask = WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(currentWorkingSetName) ? "%s %s" : "%s (%s)";
        WORKING_SET_NON_ACTION.setName(String.format(mask, Res.getString(1), currentWorkingSetName));
    }

    static {
        WORKING_SET_NON_ACTION = new WorkingSetNonAction();
        _workingSetMenu = null;
    }

    static void maS$showManageWorkingSetsDialog(Context context) {
        WorkingSetSupport.showManageWorkingSetsDialog(context);
    }

    static URLPath mav$getRelevantSourceRoots(WorkingSetSupport workingSetSupport, Project project, URL uRL) {
        return workingSetSupport.getRelevantSourceRoots(project, uRL);
    }

    static WorkingSet mav$getEditableWorkingSet(WorkingSetSupport workingSetSupport, Workspace workspace) {
        return workingSetSupport.getEditableWorkingSet(workspace);
    }

    static void maS$saveWorkingSetChanges(Workspace workspace, Runnable runnable) {
        WorkingSetSupport.saveWorkingSetChanges(workspace, runnable);
    }

    static NavigatorWindow mav$getNavigatorWindow(WorkingSetSupport workingSetSupport) {
        return workingSetSupport.getNavigatorWindow();
    }

    static void mav$simplifyFilters(WorkingSetSupport workingSetSupport, PatternFilters patternFilters) {
        workingSetSupport.simplifyFilters(patternFilters);
    }

    static int mav$calculateDepth(WorkingSetSupport workingSetSupport, String string) {
        return workingSetSupport.calculateDepth(string);
    }

    static WorkingSet maS$getActiveWorkingSet(Workspace workspace) {
        return WorkingSetSupport.getActiveWorkingSet(workspace);
    }

    static void mav$maybeNotifyActiveProjectChanged(WorkingSetSupport workingSetSupport, Context context, WorkingSet workingSet) {
        workingSetSupport.maybeNotifyActiveProjectChanged(context, workingSet);
    }

    static boolean mav$canHide(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.canHide(context);
    }

    static CompoundPattern[] mav$getPatternsForSelection(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.getPatternsForSelection(context);
    }

    static Runnable mav$doAddFilters(WorkingSetSupport workingSetSupport, PatternFilters patternFilters, CompoundPattern[] compoundPatternArray, boolean bl) {
        return workingSetSupport.doAddFilters(patternFilters, compoundPatternArray, bl);
    }

    static boolean mav$canUnhide(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.canUnhide(context);
    }

    static CompoundPattern[] mav$getUnhidePatternsSelection(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.getUnhidePatternsSelection(context);
    }

    static Runnable mav$doUnhide(WorkingSetSupport workingSetSupport, Context context, PatternFilters patternFilters, CompoundPattern[] compoundPatternArray, boolean bl) {
        return workingSetSupport.doUnhide(context, patternFilters, compoundPatternArray, bl);
    }

    static boolean mav$canNewFromSelection(WorkingSetSupport workingSetSupport, Context context) {
        return workingSetSupport.canNewFromSelection(context);
    }

    static void mav$repopulateWorkingSetMenu(WorkingSetSupport workingSetSupport, JPopupMenu jPopupMenu) {
        workingSetSupport.repopulateWorkingSetMenu(jPopupMenu);
    }

    final class 1
    implements PopupMenuListener {
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            WorkingSetSupport.mav$repopulateWorkingSetMenu(WorkingSetSupport.this, (JPopupMenu)e.getSource());
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 2
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            NewWorkingSetPanel dlg = new NewWorkingSetPanel();
            dlg.setHelpID("f1_idednewworkingset_html");
            Workspace workspace = context.getWorkspace();
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            String defaultName = this.defaultName(context.getSelection(), workingSets.getWorkingSetNames());
            Namespace data = new Namespace();
            data.put("name", (Object)defaultName);
            TDialogLauncher launcher = dlg.getTDialogLauncher((Component)Ide.getMainWindow(), data);
            boolean okay = launcher.showDialog();
            if (okay) {
                Project[] selectedProjects;
                boolean selectionContainsProjects;
                String wsName = (String)data.find("name");
                WorkingSet currentWorkingSet = WorkingSetSupport.maS$getActiveWorkingSet(workspace);
                WorkingSet newWorkingSet = workingSets.getWorkingSet(wsName);
                currentWorkingSet.copyTo((Object)newWorkingSet);
                Element[] selection = context.getSelection();
                boolean bl = selectionContainsProjects = selection != null && selection.length > 0 && selection[0] instanceof Project;
                if (selectionContainsProjects) {
                    ArrayList<Project> list = new ArrayList<Project>(selection.length);
                    Element[] elementArray = selection;
                    int n = 0;
                    while (n < elementArray.length) {
                        Element element = elementArray[n];
                        if (element instanceof Project) {
                            list.add((Project)element);
                        }
                        ++n;
                    }
                    selectedProjects = list.toArray(new Project[list.size()]);
                } else {
                    selectedProjects = new Project[]{context.getProject()};
                }
                WorkingSetSupport.maS$saveWorkingSetChanges(workspace, new 1(this, selectionContainsProjects, context, newWorkingSet, workspace, selectedProjects, workingSets, wsName));
                UpdateMessage.fireStructureChanged((Subject)workspace);
                new SaveThread(workspace).start();
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enable = WorkingSetSupport.mav$canNewFromSelection(WorkingSetSupport.this, context);
            action.setEnabled(enable);
            return true;
        }

        private String defaultName(Element[] selection, List<String> workingSetNames) {
            String defaultName;
            if (selection != null && selection.length > 3) {
                defaultName = Res.getString(9);
            } else {
                defaultName = Arrays.toString(selection);
                defaultName = defaultName.substring(1, defaultName.length() - 1);
            }
            int i = 1;
            String original = defaultName;
            while (workingSetNames.contains(defaultName)) {
                defaultName = original + i++;
            }
            return defaultName;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$selectionContainsProjects;
            private final /* synthetic */ Context v$context;
            private final /* synthetic */ WorkingSet v$newWorkingSet;
            private final /* synthetic */ Workspace v$workspace;
            private final /* synthetic */ Project[] v$selectedProjects;
            private final /* synthetic */ WorkingSets v$workingSets;
            private final /* synthetic */ String v$wsName;
            final /* synthetic */ 2 this$0;

            public void run() {
                if (!this.v$selectionContainsProjects) {
                    CompoundPattern[] compoundPatterns = WorkingSetSupport.mav$getPatternsForSelection(this.this$0.WorkingSetSupport.this, this.v$context);
                    PatternFilters filters = this.v$newWorkingSet.getOrCreatePatternFilters(this.v$context.getProject());
                    filters.setFilters(new PatternFilter[0]);
                    WorkingSetSupport.mav$doAddFilters(this.this$0.WorkingSetSupport.this, filters, compoundPatterns, true).run();
                }
                Iterator children = this.v$workspace.getChildren();
                while (children.hasNext()) {
                    Object next = children.next();
                    if (!(next instanceof Project)) continue;
                    Project project = (Project)next;
                    boolean match = this.v$newWorkingSet.isExcluded(project);
                    int i = 0;
                    while (i < this.v$selectedProjects.length && !match) {
                        match = project == this.v$selectedProjects[i];
                        ++i;
                    }
                    if (match) continue;
                    this.v$newWorkingSet.excludeProject(project);
                }
                this.v$workingSets.setCurrentWorkingSetName(this.v$wsName);
            }

            public 1(2 var1_1, boolean bl, Context context, WorkingSet workingSet, Workspace workspace, Project[] projectArray, WorkingSets workingSets, String string) {
                this.v$wsName = string;
                this.v$workingSets = workingSets;
                this.v$selectedProjects = projectArray;
                this.v$workspace = workspace;
                this.v$newWorkingSet = workingSet;
                this.v$context = context;
                this.v$selectionContainsProjects = bl;
                this.this$0 = var1_1;
            }
        }
    }

    final class 3
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            Workspace workspace = context.getWorkspace();
            WorkingSet activeWorkingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, workspace);
            PatternFilters filters = activeWorkingSet.getOrCreatePatternFilters(context.getProject());
            CompoundPattern[] compoundPatterns = WorkingSetSupport.mav$getUnhidePatternsSelection(WorkingSetSupport.this, context);
            WorkingSetSupport.maS$saveWorkingSetChanges(workspace, WorkingSetSupport.mav$doUnhide(WorkingSetSupport.this, context, filters, compoundPatterns, false));
            UpdateMessage.fireStructureChanged((Subject)workspace);
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enable = WorkingSetSupport.mav$canUnhide(WorkingSetSupport.this, context);
            action.setEnabled(enable);
            return true;
        }
    }

    final class 4
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            Workspace workspace = context.getWorkspace();
            WorkingSet activeWorkingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, workspace);
            PatternFilters filters = activeWorkingSet.getOrCreatePatternFilters(context.getProject());
            CompoundPattern[] compoundPatterns = WorkingSetSupport.mav$getUnhidePatternsSelection(WorkingSetSupport.this, context);
            WorkingSetSupport.maS$saveWorkingSetChanges(workspace, WorkingSetSupport.mav$doUnhide(WorkingSetSupport.this, context, filters, compoundPatterns, true));
            UpdateMessage.fireStructureChanged((Subject)workspace);
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enable = WorkingSetSupport.mav$canUnhide(WorkingSetSupport.this, context);
            action.setEnabled(enable);
            return true;
        }
    }

    final class 5
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            Element[] selection = context.getSelection();
            if (selection != null && selection.length > 0 && selection[0] instanceof Project) {
                Workspace workspace = context.getWorkspace();
                WorkingSet activeWorkingSet = WorkingSetSupport.maS$getActiveWorkingSet(workspace);
                boolean[] modified = new boolean[]{false};
                WorkingSetSupport.maS$saveWorkingSetChanges(workspace, new 1(this, selection, modified, activeWorkingSet));
                if (modified[0]) {
                    UpdateMessage.fireStructureChanged((Subject)workspace);
                    WorkingSetSupport.mav$maybeNotifyActiveProjectChanged(WorkingSetSupport.this, context, activeWorkingSet);
                }
            } else {
                Workspace workspace = context.getWorkspace();
                WorkingSet activeWorkingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, workspace);
                PatternFilters filters = activeWorkingSet.getOrCreatePatternFilters(context.getProject());
                CompoundPattern[] compoundPatterns = WorkingSetSupport.mav$getPatternsForSelection(WorkingSetSupport.this, context);
                WorkingSetSupport.maS$saveWorkingSetChanges(workspace, WorkingSetSupport.mav$doAddFilters(WorkingSetSupport.this, filters, compoundPatterns, false));
                UpdateMessage.fireStructureChanged((Subject)workspace);
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enable = WorkingSetSupport.mav$canHide(WorkingSetSupport.this, context);
            action.setEnabled(enable);
            return true;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Element[] v$selection;
            private final /* synthetic */ boolean[] v$modified;
            private final /* synthetic */ WorkingSet v$activeWorkingSet;
            final /* synthetic */ 5 this$0;

            public void run() {
                Element[] elementArray = this.v$selection;
                int n = 0;
                while (n < elementArray.length) {
                    Element elem = elementArray[n];
                    if (elem instanceof Project) {
                        Project project = (Project)elem;
                        this.v$modified[0] = this.v$activeWorkingSet.excludeProject(project) || this.v$modified[0];
                    }
                    ++n;
                }
            }

            public 1(5 var1_1, Element[] elementArray, boolean[] blArray, WorkingSet workingSet) {
                this.v$activeWorkingSet = workingSet;
                this.v$modified = blArray;
                this.v$selection = elementArray;
                this.this$0 = var1_1;
            }
        }
    }

    final class 6
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            WorkingSetSupport.maS$showManageWorkingSetsDialog(context);
            WorkingSetSupport.mav$maybeNotifyActiveProjectChanged(WorkingSetSupport.this, context, WorkingSetSupport.maS$getActiveWorkingSet(context.getWorkspace()));
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            action.setEnabled(context.getWorkspace() != null);
            return true;
        }
    }

    final class 7
    implements Runnable {
        private final /* synthetic */ CompoundPattern[] v$compoundPatterns;
        private final /* synthetic */ PatternFilters v$filters;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ boolean v$unhideAll;
        final /* synthetic */ WorkingSetSupport this$0;

        public void run() {
            if (this.v$compoundPatterns.length == 1 && this.v$compoundPatterns[0]._primaryFilter.equals("**")) {
                this.v$filters.setFilters(new PatternFilter[0]);
                this.v$filters.addInclude("**");
                return;
            }
            WorkingSetSupport.mav$simplifyFilters(this.this$0, this.v$filters);
            int packageDepth = this.getFlatLevel(this.v$context);
            ArrayList<PatternFilter> filterList = new ArrayList<PatternFilter>(Arrays.asList(this.v$filters.getFilters()));
            int originalSize = filterList.size();
            Iterator filterIterator = filterList.iterator();
            while (filterIterator.hasNext()) {
                PatternFilter pf = (PatternFilter)filterIterator.next();
                if (pf.isInclude()) continue;
                String existingPattern = pf.getPattern();
                CompoundPattern[] compoundPatternArray = this.v$compoundPatterns;
                int n = 0;
                while (n < compoundPatternArray.length) {
                    CompoundPattern nextPattern = compoundPatternArray[n];
                    String toUnhide = nextPattern._primaryFilter;
                    if (!existingPattern.equals(toUnhide) && existingPattern.startsWith(toUnhide)) {
                        int pos;
                        if (this.v$unhideAll || packageDepth == 1) {
                            filterIterator.remove();
                        } else if (WorkingSetSupport.mav$calculateDepth(this.this$0, existingPattern) > packageDepth && ((pos = existingPattern.indexOf("/**/")) == -1 || pos == toUnhide.length())) {
                            filterIterator.remove();
                        }
                    }
                    ++n;
                }
            }
            if (filterList.size() < originalSize) {
                PatternFilter[] newFilters = filterList.toArray(new PatternFilter[filterList.size()]);
                this.v$filters.setFilters(newFilters);
            }
            int i = 0;
            while (i < this.v$compoundPatterns.length) {
                String includePattern = this.v$compoundPatterns[i]._primaryFilter;
                if (WorkingSetSupport.mav$calculateDepth(this.this$0, includePattern) < packageDepth) {
                    includePattern = includePattern + "/*";
                }
                this.v$filters.addInclude(includePattern, true);
                ++i;
            }
        }

        private int getFlatLevel(Context ctxt) {
            View view = ctxt.getView();
            if (view instanceof ContentFilterCustomizer) {
                ContentFilterCustomizer navPrefs = (ContentFilterCustomizer)view;
                Context tempContext = new Context();
                navPrefs.copyPreferencesTo(tempContext);
                return tempContext.getInt("flat-level");
            }
            String viewType = view != null ? view.getClass().getName() : "null";
            Assert.println((String)("WARNING: was expecting the current View to implement ContentFilterCustomizer, but instead a view of type " + viewType + " was found"));
            return Integer.MAX_VALUE;
        }

        public 7(WorkingSetSupport workingSetSupport, CompoundPattern[] compoundPatternArray, PatternFilters patternFilters, Context context, boolean bl) {
            this.v$unhideAll = bl;
            this.v$context = context;
            this.v$filters = patternFilters;
            this.v$compoundPatterns = compoundPatternArray;
            this.this$0 = workingSetSupport;
        }
    }

    final class 8
    implements Runnable {
        private final /* synthetic */ CompoundPattern[] v$compoundPatterns;
        private final /* synthetic */ boolean v$unhide;
        private final /* synthetic */ PatternFilters v$filters;
        final /* synthetic */ WorkingSetSupport this$0;

        public void run() {
            int i = 0;
            while (i < this.v$compoundPatterns.length) {
                String pattern = this.v$compoundPatterns[i]._primaryFilter;
                if (this.v$unhide) {
                    this.v$filters.addInclude(pattern, true);
                } else {
                    this.v$filters.addExclude(pattern, true);
                }
                if (this.v$compoundPatterns[i].hasAdditionalFilters()) {
                    List<String> x = this.v$compoundPatterns[i]._secondaryFilters;
                    for (String ptrn : x) {
                        if (this.v$unhide) {
                            this.v$filters.addExclude(ptrn, true);
                            continue;
                        }
                        this.v$filters.addInclude(ptrn, true);
                    }
                }
                ++i;
            }
            WorkingSetSupport.mav$simplifyFilters(this.this$0, this.v$filters);
        }

        public 8(WorkingSetSupport workingSetSupport, CompoundPattern[] compoundPatternArray, boolean bl, PatternFilters patternFilters) {
            this.v$filters = patternFilters;
            this.v$unhide = bl;
            this.v$compoundPatterns = compoundPatternArray;
            this.this$0 = workingSetSupport;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundPattern {
        String _primaryFilter;
        List<String> _secondaryFilters;

        CompoundPattern(String pattern) {
            this._primaryFilter = pattern;
        }

        public void addAdditionalFilter(List<String> additionalPatterns) {
            if (this._secondaryFilters == null) {
                this._secondaryFilters = new ArrayList<String>();
            }
            this._secondaryFilters.addAll(additionalPatterns);
        }

        public boolean hasAdditionalFilters() {
            return this._secondaryFilters != null && this._secondaryFilters.size() > 0;
        }
    }

    private static class WorkingSetNonAction
    extends ToggleAction {
        WorkingSetNonAction() {
            super(Res.getString(1), OracleIcons.getIcon((String)"small/filter_14.png"));
            this.putValue("tinyButton", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class WorkspaceCML
    implements ContextMenuListener,
    Controller {
        private static final String FILTER_APPLICATION_CMD = "oracle.jdevimpl.navigator.WorkingSetSupport.FILTER_APPLICATION";
        private final int _filterApplicationID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.navigator.WorkingSetSupport.FILTER_APPLICATION");
        private final IdeAction _filterApplicationAction = IdeAction.get((int)this._filterApplicationID, (String)"oracle.jdevimpl.navigator.WorkingSetSupport.FILTER_APPLICATION", (String)Res.getString(16));
        private JMenuItem _filterApplicationMenuItem;

        WorkspaceCML() {
            this._filterApplicationAction.addController((Controller)this);
        }

        public void menuWillShow(ContextMenu contextMenu) {
            this.maybeInitMenuItems((MenuManager)contextMenu);
            contextMenu.add((Component)this._filterApplicationMenuItem, MenuConstants.SECTION_SEARCH_CTXT_MENU);
        }

        private void maybeInitMenuItems(MenuManager menuManager) {
            if (this._filterApplicationMenuItem == null) {
                this._filterApplicationMenuItem = menuManager.createMenuItem((ToggleAction)this._filterApplicationAction, MenuConstants.increment((float)MenuConstants.WEIGHT_SEARCH_SHOW_APP_OVERVIEW));
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int id;
            Workspace workspace = context.getWorkspace();
            if (workspace != null && (id = action.getCommandId()) == this._filterApplicationID) {
                WorkingSetSupport.maS$showManageWorkingSetsDialog(context);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            Workspace workspace = context.getWorkspace();
            action.setEnabled(workspace != null);
            return true;
        }
    }

    static final class 9
    implements Runnable {
        private final /* synthetic */ Workspace v$workspaceCopy;
        private final /* synthetic */ Workspace v$workspace;

        public void run() {
            this.v$workspaceCopy.copyTo((Object)this.v$workspace);
        }

        public 9(Workspace workspace, Workspace workspace2) {
            this.v$workspace = workspace2;
            this.v$workspaceCopy = workspace;
        }
    }

    private static class SaveThread
    extends Thread {
        private final Workspace _workspace;

        SaveThread(Workspace workspace) {
            this._workspace = workspace;
        }

        public void run() {
            try {
                this._workspace.saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddToWorkingSetController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            WorkingSet activeWorkingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, workspace);
            Object element = context.getElement() instanceof Locatable ? context.getElement() : context.getNode();
            if (workspace == null || activeWorkingSet == null || !(element instanceof Locatable)) {
                return true;
            }
            if (project != null && project.containsChild(element)) {
                this.addFileToWorkingSet((Element)element, project, workspace, activeWorkingSet);
            } else {
                IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), Res.getString(3), (Object)Res.getString(17), project != null ? project.getShortLabel() : "");
                monitor.setMillisToPopup(0);
                monitor.setCancellable(true);
                monitor.setCloseOnFinish(true);
                ProgressPanel progressPanel = monitor.getPanel();
                TreeExplorer explorer = WorkingSetSupport.mav$getNavigatorWindow(WorkingSetSupport.this) != null ? WorkingSetSupport.mav$getNavigatorWindow(WorkingSetSupport.this).getTreeExplorer() : null;
                ExecutorService service = Executors.newSingleThreadExecutor();
                service.submit(new 1FindOwningProject(this, monitor, workspace, project, progressPanel, (Element)element, activeWorkingSet, explorer));
            }
            return true;
        }

        private void addFileToWorkingSet(Element element, Project owningProject, Workspace workspace, WorkingSet activeWorkingSet) {
            WorkingSetSupport.maS$saveWorkingSetChanges(workspace, new 1(this, activeWorkingSet, owningProject, element));
            Ide.getStatusBar().setText(Res.format(6, element.getShortLabel(), activeWorkingSet.getName()));
            UpdateMessage.fireStructureChanged((Subject)workspace);
            NavigatorWindow navigator = WorkingSetSupport.mav$getNavigatorWindow(WorkingSetSupport.this);
            if (navigator.isVisible()) {
                TreeExplorer explorer = navigator.getTreeExplorer();
                TNode tnode = explorer.findTNode(element, null);
                explorer.setSelected(tnode);
            }
        }

        public boolean update(IdeAction action, Context context) {
            action.setEnabled(false);
            Element element = context.getElement();
            if (!(element instanceof Locatable)) {
                element = context.getNode();
            }
            if (element == null || !(element instanceof Locatable)) {
                return true;
            }
            Workspace activeWorkspace = context.getWorkspace();
            WorkingSet activeWorkingSet = WorkingSetSupport.mav$getEditableWorkingSet(WorkingSetSupport.this, activeWorkspace);
            if (activeWorkspace == null || activeWorkingSet == null) {
                return true;
            }
            Project activeProject = context.getProject();
            if (activeProject == null) {
                action.setEnabled(true);
            } else if (activeProject != null && !activeProject.containsChild(element)) {
                action.setEnabled(activeProject.canAdd(element));
            } else if (activeWorkingSet.isExcluded(activeProject)) {
                action.setEnabled(true);
            } else {
                PatternFilters filters = activeWorkingSet.getPatternFilters(activeProject);
                if (filters == null || !filters.containsFilters()) {
                    action.setEnabled(true);
                } else if (filters != null) {
                    URL url = ((Locatable)element).getURL();
                    URLPath srcPath = WorkingSetSupport.mav$getRelevantSourceRoots(WorkingSetSupport.this, activeProject, url);
                    URL[] uRLArray = srcPath.getEntries();
                    int n = 0;
                    while (n < uRLArray.length) {
                        URL nextURL = uRLArray[n];
                        String relPath = new URLPath(nextURL).toRelativePath(url);
                        if (relPath != null && relPath.length() > 0 && !filters.isIncluded(relPath)) {
                            action.setEnabled(true);
                            break;
                        }
                        ++n;
                    }
                }
            }
            return true;
        }

        private List<String> getPatternFilters(URL url, Project project, WorkingSet activeWorkingSet) {
            PatternFilters filters = activeWorkingSet.getPatternFilters(project);
            if (filters != null) {
                URLPath srcPath = WorkingSetSupport.mav$getRelevantSourceRoots(WorkingSetSupport.this, project, url);
                ArrayList<String> paths = new ArrayList<String>(srcPath.getEntries().length);
                URL[] uRLArray = srcPath.getEntries();
                int n = 0;
                while (n < uRLArray.length) {
                    URL nextURL = uRLArray[n];
                    String relPath = new URLPath(nextURL).toRelativePath(url);
                    if (relPath != null && relPath.length() > 0 && !filters.isIncluded(relPath)) {
                        paths.add(relPath);
                    }
                    ++n;
                }
                return paths;
            }
            return Collections.emptyList();
        }

        private AddToWorkingSetController() {
        }

        AddToWorkingSetController(1 var2_2) {
            this();
        }

        static void mav$addFileToWorkingSet(AddToWorkingSetController addToWorkingSetController, Element element, Project project, Workspace workspace, WorkingSet workingSet) {
            addToWorkingSetController.addFileToWorkingSet(element, project, workspace, workingSet);
        }

        static List mav$getPatternFilters(AddToWorkingSetController addToWorkingSetController, URL uRL, Project project, WorkingSet workingSet) {
            return addToWorkingSetController.getPatternFilters(uRL, project, workingSet);
        }

        class 1FindOwningProject
        implements Runnable {
            final Project[] result;
            private final /* synthetic */ IndeterminateProgressMonitor v$monitor;
            private final /* synthetic */ Workspace v$workspace;
            private final /* synthetic */ Project v$project;
            private final /* synthetic */ ProgressPanel v$progressPanel;
            private final /* synthetic */ Element v$element;
            private final /* synthetic */ WorkingSet v$activeWorkingSet;
            private final /* synthetic */ TreeExplorer v$explorer;
            final /* synthetic */ AddToWorkingSetController this$0;

            private void $init$() {
                this.result = new Project[1];
            }

            public void run() {
                block14: {
                    this.v$monitor.start();
                    try {
                        try {
                            ArrayList<Project> remaining = new ArrayList<Project>();
                            Iterator children = this.v$workspace.getChildren();
                            while (children.hasNext()) {
                                if (this.v$monitor.isCanceled()) break;
                                Object child = children.next();
                                if (child == this.v$project || !(child instanceof Project)) continue;
                                Project nextProject = (Project)child;
                                if (nextProject.isOpen()) {
                                    if (this.v$progressPanel != null) {
                                        this.v$progressPanel.setNote(nextProject.getShortLabel());
                                    }
                                    if (!nextProject.containsChild(this.v$element)) continue;
                                    this.result[0] = nextProject;
                                    break;
                                }
                                remaining.add(nextProject);
                            }
                            for (Project proj : remaining) {
                                if (this.v$progressPanel != null) {
                                    this.v$progressPanel.setNote(proj.getShortLabel());
                                }
                                if (proj.containsChild(this.v$element)) {
                                    this.result[0] = proj;
                                    break;
                                }
                                if (this.v$monitor.isCanceled()) break;
                            }
                            if (this.result != null && this.result[0] != null) {
                                AddToWorkingSetController.mav$addFileToWorkingSet(this.this$0, this.v$element, this.result[0], this.v$workspace, this.v$activeWorkingSet);
                                if (this.v$explorer != null) {
                                    SwingUtilities.invokeLater(new 1SelectInNavigator());
                                }
                                break block14;
                            }
                            String message = Res.format(4, this.v$element.getShortLabel());
                            if (!this.v$monitor.isCanceled()) {
                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)Res.getString(3), (String)"f1_idedaddtoworkingset_html");
                            }
                            Ide.getStatusBar().setText(message);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        EventQueue.invokeLater(new 1());
                    }
                }
            }

            1FindOwningProject(AddToWorkingSetController addToWorkingSetController, IndeterminateProgressMonitor indeterminateProgressMonitor, Workspace workspace, Project project, ProgressPanel progressPanel, Element element, WorkingSet workingSet, TreeExplorer treeExplorer) {
                this.v$explorer = treeExplorer;
                this.v$activeWorkingSet = workingSet;
                this.v$element = element;
                this.v$progressPanel = progressPanel;
                this.v$project = project;
                this.v$workspace = workspace;
                this.v$monitor = indeterminateProgressMonitor;
                this.this$0 = addToWorkingSetController;
                this.$init$();
            }

            static TreeExplorer ra$v$explorer(1FindOwningProject findOwningProject) {
                return findOwningProject.v$explorer;
            }

            static Element ra$v$element(1FindOwningProject findOwningProject) {
                return findOwningProject.v$element;
            }

            static IndeterminateProgressMonitor ra$v$monitor(1FindOwningProject findOwningProject) {
                return findOwningProject.v$monitor;
            }

            class 1SelectInNavigator
            implements Runnable {
                public void run() {
                    try {
                        TNode tnode;
                        TNode projectNode = 1FindOwningProject.ra$v$explorer(1FindOwningProject.this).searchTNodeBreadthFirst((Element)1FindOwningProject.this.result[0], null);
                        if (projectNode != null && (tnode = 1FindOwningProject.ra$v$explorer(1FindOwningProject.this).findTNode(1FindOwningProject.ra$v$element(1FindOwningProject.this), projectNode)) != null) {
                            1FindOwningProject.ra$v$explorer(1FindOwningProject.this).setSelected(tnode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                1SelectInNavigator() {
                }
            }

            final class 1
            implements Runnable {
                public void run() {
                    1FindOwningProject.ra$v$monitor(1FindOwningProject.this).close();
                }
            }
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WorkingSet v$activeWorkingSet;
            private final /* synthetic */ Project v$owningProject;
            private final /* synthetic */ Element v$element;
            final /* synthetic */ AddToWorkingSetController this$0;

            public void run() {
                PatternFilters patternFilters;
                boolean added = this.v$activeWorkingSet.includeProject(this.v$owningProject);
                if (added) {
                    patternFilters = this.v$activeWorkingSet.getOrCreatePatternFilters(this.v$owningProject);
                    patternFilters.setFilters(new PatternFilter[0]);
                } else {
                    patternFilters = this.v$activeWorkingSet.getPatternFilters(this.v$owningProject);
                }
                if (patternFilters != null) {
                    URL url = ((Locatable)this.v$element).getURL();
                    for (String relPath : AddToWorkingSetController.mav$getPatternFilters(this.this$0, url, this.v$owningProject, this.v$activeWorkingSet)) {
                        patternFilters.addInclude(relPath);
                    }
                }
            }

            public 1(AddToWorkingSetController addToWorkingSetController, WorkingSet workingSet, Project project, Element element) {
                this.v$element = element;
                this.v$owningProject = project;
                this.v$activeWorkingSet = workingSet;
                this.this$0 = addToWorkingSetController;
            }
        }
    }

    private static class OwningProjectFinder
    implements Runnable {
        final Project[] _result;
        final Project _project;
        final Workspace _workspace;
        final Element _element;
        final ProgressPanel _progressPanel;
        boolean _canceled;

        public OwningProjectFinder(Element element, Project project, Workspace workspace, Project[] result, ProgressPanel progressPanel) {
            this._element = element;
            this._project = project;
            this._workspace = workspace;
            this._result = result;
            this._progressPanel = progressPanel;
        }

        void cancel() {
            this._canceled = true;
        }

        public void run() {
            ArrayList<Project> remaining = new ArrayList<Project>();
            Iterator children = this._workspace.getChildren();
            while (children.hasNext()) {
                if (this._canceled) {
                    return;
                }
                Object child = children.next();
                if (child == this._project || !(child instanceof Project)) continue;
                Project project = (Project)child;
                if (project.isOpen()) {
                    this.showFeedback(project);
                    if (!project.containsChild(this._element)) continue;
                    this._result[0] = project;
                    return;
                }
                remaining.add(project);
            }
            for (Project project : remaining) {
                if (this._canceled) {
                    return;
                }
                this.showFeedback(project);
                if (!project.containsChild(this._element)) continue;
                this._result[0] = project;
                return;
            }
        }

        private void showFeedback(Project project) {
            if (this._progressPanel != null) {
                this._progressPanel.setNote(project.getShortLabel());
            }
        }
    }
}

