/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.jdevimpl.navigator.FileNameComparator;

final class WorkspacesWrapper
extends Workspaces {
    private static final FileNameComparator _comparator = new FileNameComparator();
    private final String _label;
    private final Icon _icon;
    private static Workspaces _delegate;

    WorkspacesWrapper(String label, Icon icon) {
        this._label = label;
        this._icon = icon;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getShortLabel() {
        return this._label;
    }

    public boolean canAdd(Element element) {
        return WorkspacesWrapper.getDelegate().canAdd(element);
    }

    public Object copyTo(Object object) {
        return WorkspacesWrapper.getDelegate().copyTo(object);
    }

    public Workspace currentActiveWorkspace() {
        return WorkspacesWrapper.getDelegate().currentActiveWorkspace();
    }

    public Map getActiveProjectMap() {
        return WorkspacesWrapper.getDelegate().getActiveProjectMap();
    }

    public URL getActiveWorkspaceURL() {
        return WorkspacesWrapper.getDelegate().getActiveWorkspaceURL();
    }

    public URL getWorkDirectory() {
        return WorkspacesWrapper.getDelegate().getWorkDirectory();
    }

    public boolean isDirty() {
        return WorkspacesWrapper.getDelegate().isDirty();
    }

    public void markDirty(boolean dirty) {
        WorkspacesWrapper.getDelegate().markDirty(dirty);
    }

    public boolean remove(Element doc) {
        return WorkspacesWrapper.getDelegate().remove(doc);
    }

    public void setActiveProjectMap(Map map) {
        WorkspacesWrapper.getDelegate().setActiveProjectMap(map);
    }

    public void setActiveWorkspace(Workspace workspace) {
        WorkspacesWrapper.getDelegate().setActiveWorkspace(workspace);
    }

    public void setActiveWorkspaceURL(URL workspaceURL) {
        WorkspacesWrapper.getDelegate().setActiveWorkspaceURL(workspaceURL);
    }

    public void setListOfChildren(List list) {
        WorkspacesWrapper.getDelegate().setListOfChildren(list);
    }

    public void setOwner(Dirtyable owner) {
        WorkspacesWrapper.getDelegate().setOwner(owner);
    }

    public void setWorkDirectory(URL workDirectory) {
        WorkspacesWrapper.getDelegate().setWorkDirectory(workDirectory);
    }

    public void attach(Observer observer) {
        WorkspacesWrapper.getDelegate().attach(observer);
    }

    public void detach(Observer observer) {
        WorkspacesWrapper.getDelegate().detach(observer);
    }

    public void notifyObservers(Object observed, UpdateMessage change) {
        WorkspacesWrapper.getDelegate().notifyObservers(observed, change);
    }

    public boolean add(Element element) {
        return WorkspacesWrapper.getDelegate().add(element);
    }

    public List getListOfChildren() {
        return WorkspacesWrapper.getDelegate().getListOfChildren();
    }

    public void removeAll() {
        WorkspacesWrapper.getDelegate().removeAll();
    }

    public boolean canRemove(Element element) {
        return WorkspacesWrapper.getDelegate().canRemove(element);
    }

    public boolean containsChild(Element child) {
        return WorkspacesWrapper.getDelegate().containsChild(child);
    }

    public Iterator getChildren() {
        ArrayList children = new ArrayList();
        Iterator iter = WorkspacesWrapper.getDelegate().getChildren();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        Collections.sort(children, _comparator);
        return children.iterator();
    }

    public boolean mayHaveChildren() {
        return WorkspacesWrapper.getDelegate().mayHaveChildren();
    }

    public int size() {
        return WorkspacesWrapper.getDelegate().size();
    }

    public Attributes getAttributes() {
        return WorkspacesWrapper.getDelegate().getAttributes();
    }

    public Object getData() {
        return WorkspacesWrapper.getDelegate().getData();
    }

    public String getLongLabel() {
        return WorkspacesWrapper.getDelegate().getLongLabel();
    }

    public String getToolTipText() {
        return WorkspacesWrapper.getDelegate().getToolTipText();
    }

    public String toString() {
        return WorkspacesWrapper.getDelegate().toString();
    }

    public boolean equals(Object obj) {
        return WorkspacesWrapper.getDelegate().equals(obj);
    }

    public int hashCode() {
        return WorkspacesWrapper.getDelegate().hashCode();
    }

    private static Workspaces getDelegate() {
        if (_delegate == null) {
            _delegate = Ide.getWorkspaces();
        }
        return _delegate;
    }
}

