/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.help.HelpSystem;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ide.resource.IdeIcons;
import oracle.jdevimpl.palette.CodeSnippetPanel;

public class CodeSnippetWizard
implements VetoableChangeListener,
Invokable {
    private JEWTDialog _dlg;
    private CodeSnippetPanel _panel;
    private CodeEditor _editor;
    private Context _context;
    private PaletteManager pm;
    private Palette _palette;
    private boolean _pageSet;

    private void $init$() {
        this._panel = null;
        this._editor = null;
        this._context = null;
        this.pm = PaletteManager.getPaletteManager();
        this._palette = this.pm.getPalette();
        this._pageSet = false;
    }

    public boolean invoke(Context context, String[] stringArray) {
        this._panel = new CodeSnippetPanel();
        this._pageSet = true;
        this._context = context;
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), "Add Code Snippet", 7);
        this._dlg.setContent((Component)this._panel);
        this._dlg.setPreferredSize(new Dimension(500, 300));
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._dlg.getContent(), "f1_idedaddsnippet_html");
        boolean result = this._dlg.runDialog();
        this._dlg.removeVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.dispose();
        return result;
    }

    public boolean invoke(Context context, CodeEditor editor) {
        this._panel = new CodeSnippetPanel();
        this._editor = editor;
        this._context = context;
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), "Add Code Snippet", 7);
        String snippet = editor.getSelectedText();
        if (snippet.trim().length() > 0) {
            this._panel.setSnippet(snippet);
        }
        this._dlg.setContent((Component)this._panel);
        this._dlg.setPreferredSize(new Dimension(500, 300));
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._dlg.getContent(), "f1_idedaddsnippet_html");
        boolean result = this._dlg.runDialog();
        this._dlg.removeVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.dispose();
        return result;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !this.addSnippet()) {
            throw new PropertyVetoException("no", evt);
        }
    }

    private boolean addSnippet() {
        boolean canContinue = true;
        String message = "";
        if (this._panel.getName().trim().length() == 0) {
            message = "You must choose a name for your Code Snippet";
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        } else if (this._panel.getSnippet().trim().length() == 0) {
            message = "There is no snippet to add. Please create a snippet to add.";
            canContinue = false;
            this._panel.getSnippetFld().requestFocus();
        } else if (this._palette.getPaletteItem(this._panel.getName(), "Code Snippets") != null) {
            message = "Name already exists. Select another name.";
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        }
        if (!canContinue) {
            JOptionPane.showMessageDialog((Component)this._dlg, message, "Jdeveloper Message", 0);
            return false;
        }
        if (!this._pageSet) {
            PalettePage editPage = this._palette.getPalettePage("Code Snippets");
            editPage.getPaletteItems();
            this._palette.setEditPage(editPage);
        }
        PalettePage palettePage = this._palette.getEditPage();
        palettePage.addPaletteItem(IdeIcons.getString((int)28), "Code Snippet", true, this._panel.getName(), this._panel.getName(), "jsp", "oracle.jdeveloper.palette.wizard.CodeSnippetEditor", "");
        PaletteItem pi = palettePage.getPaletteItem(this._panel.getName());
        pi.setItemCodeSnippet(this._panel.getSnippet());
        return true;
    }

    public CodeSnippetWizard() {
        this.$init$();
    }
}

