/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.util.BitSet;
import java.util.HashMap;
import oracle.jdevimpl.profiler.support.Capabilities;

public class CapabilitiesImpl
implements Capabilities {
    private BitSet capabilities = new BitSet();
    private static final String[] capabilityStrings = new String[]{"RTH", "PTI", "RUT", "RST", "RCT", "RET", "RWT", "REM", "RCS", "REX", "SHP", "PME", "RAL", "RAS", "RIO", "RMU", "RIU", "REU", "PEV"};
    private static HashMap<String, Integer> stringToBit = new HashMap();

    static {
        int i = 0;
        while (i < capabilityStrings.length) {
            stringToBit.put(capabilityStrings[i], i);
            ++i;
        }
    }

    public CapabilitiesImpl() {
    }

    public CapabilitiesImpl(CapabilitiesImpl other) {
        this();
        this.capabilities.or(other.capabilities);
    }

    private void set(String capabilityName) {
        Integer bit = stringToBit.get(capabilityName.toUpperCase());
        if (bit == null) {
            throw new IllegalArgumentException("Internal error: invalid capability '" + capabilityName + "'");
        }
        this.capabilities.set(bit);
    }

    public CapabilitiesImpl(String stringRep, String prefix, String suffix) {
        this();
        int len = stringRep.length();
        int suffixLen = suffix.length();
        int last = stringRep.length() - suffixLen;
        int first = prefix.length();
        if (len < first + suffixLen || !stringRep.startsWith(prefix) || !stringRep.endsWith(suffix)) {
            throw new IllegalArgumentException("Internal error: invalid capabilities " + stringRep);
        }
        StringBuffer buf = new StringBuffer();
        int i = first;
        while (i < last) {
            char c = stringRep.charAt(i);
            if (c == ';') {
                this.set(buf.toString());
                buf.setLength(0);
            } else {
                buf.append(c);
            }
            ++i;
        }
        if (buf.length() > 0) {
            this.set(buf.toString());
        }
    }

    public boolean canProfileTime() {
        return this.capabilities.get(0);
    }

    public void setProfileTime(boolean enable) {
        this.capabilities.set(0, enable);
    }

    public boolean canReportUserTime() {
        return this.capabilities.get(1);
    }

    public void setReportUserTime(boolean enable) {
        this.capabilities.set(1, enable);
    }

    public boolean canReportSystemTime() {
        return this.capabilities.get(2);
    }

    public void setReportSystemTime(boolean enable) {
        this.capabilities.set(2, enable);
    }

    public boolean canReportCombinedTime() {
        return this.capabilities.get(3);
    }

    public void setReportCombinedTime(boolean enable) {
        this.capabilities.set(3, enable);
    }

    public boolean canReportElapsedTime() {
        return this.capabilities.get(4);
    }

    public void setReportElapsedTime(boolean enable) {
        this.capabilities.set(4, enable);
    }

    public boolean canReportWaitTime() {
        return this.capabilities.get(5);
    }

    public void setReportWaitTime(boolean enable) {
        this.capabilities.set(5, enable);
    }

    public boolean canReportExactMethodCount() {
        return this.capabilities.get(6);
    }

    public void setReportExactMethodCount(boolean enable) {
        this.capabilities.set(6, enable);
    }

    public boolean canReportCallStack() {
        return this.capabilities.get(7);
    }

    public void setReportCallStack(boolean enable) {
        this.capabilities.set(7, enable);
    }

    public boolean canReportCallThread() {
        return this.capabilities.get(8);
    }

    public void setReportCallThread(boolean enable) {
        this.capabilities.set(8, enable);
    }

    public boolean canReportExactTimes() {
        return this.capabilities.get(9);
    }

    public void setReportExactTimes(boolean enable) {
        this.capabilities.set(9, enable);
    }

    public boolean canSetHighPrecision() {
        return this.capabilities.get(10);
    }

    public void setHighPrecision(boolean enable) {
        this.capabilities.set(10, enable);
    }

    public boolean canProfileMemory() {
        return this.capabilities.get(0);
    }

    public void setProfileMemory(boolean enable) {
        this.capabilities.set(0, enable);
    }

    public boolean canReportAllocatingLoader() {
        return this.capabilities.get(12);
    }

    public void setReportAllocatingLoader(boolean enable) {
        this.capabilities.set(12, enable);
    }

    public boolean canReportAllocatingStack() {
        return this.capabilities.get(13);
    }

    public void setReportAllocatingStack(boolean enable) {
        this.capabilities.set(13, enable);
    }

    public boolean canReportAllocatingThread() {
        return this.capabilities.get(14);
    }

    public void setReportAllocatingThread(boolean enable) {
        this.capabilities.set(14, enable);
    }

    public boolean canReportIndividualObjects() {
        return this.capabilities.get(15);
    }

    public void setReportIndividualObjects(boolean enable) {
        this.capabilities.set(15, enable);
    }

    public boolean canReportMemoryUsed() {
        return this.capabilities.get(16);
    }

    public void setReportMemoryUsed(boolean enable) {
        this.capabilities.set(16, enable);
    }

    public boolean canReportInclusiveUsed() {
        return this.capabilities.get(17);
    }

    public void setReportInclusiveUsed(boolean enable) {
        this.capabilities.set(17, enable);
    }

    public boolean canReportExclusiveUsed() {
        return this.capabilities.get(18);
    }

    public void setReportExclusiveUsed(boolean enable) {
        this.capabilities.set(18, enable);
    }

    public boolean canProfileEvents() {
        return this.capabilities.get(19);
    }

    public void setProfileEvents(boolean enable) {
        this.capabilities.set(19, enable);
    }

    public Capabilities or(Capabilities c1, Capabilities c2) {
        CapabilitiesImpl r = new CapabilitiesImpl((CapabilitiesImpl)c1);
        r.capabilities.or(((CapabilitiesImpl)c2).capabilities);
        return r;
    }

    public Capabilities and(Capabilities c1, Capabilities c2) {
        CapabilitiesImpl r = new CapabilitiesImpl((CapabilitiesImpl)c1);
        r.capabilities.and(((CapabilitiesImpl)c2).capabilities);
        return r;
    }

    public Capabilities diff(Capabilities c1, Capabilities c2) {
        CapabilitiesImpl r = new CapabilitiesImpl((CapabilitiesImpl)c1);
        BitSet cap1 = r.capabilities;
        BitSet cap2 = ((CapabilitiesImpl)c2).capabilities;
        int i = 0;
        int n = r.capabilities.size();
        while (i < n) {
            cap1.set(i, cap1.get(i) && !cap2.get(i));
            ++i;
        }
        return r;
    }

    String stringRep(String prefix, String suffix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        int i = 0;
        int n = this.capabilities.size();
        while (i < n) {
            if (this.capabilities.get(i)) {
                if (i > 0) {
                    buf.append(';');
                }
                buf.append(capabilityStrings[i]);
            }
            ++i;
        }
        buf.append(suffix);
        return buf.toString();
    }
}

