/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.jdevimpl.profiler.jvmti.ClassInfo;
import oracle.jdevimpl.profiler.jvmti.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classes {
    private ArrayList<ClassInfo> classes;
    private HashMap<String, ArrayList> classMap;
    private Model model;
    public static final int JAVA_LANG_CLASS = 1;

    private void $init$() {
        this.classes = new ArrayList();
        this.classMap = new HashMap();
    }

    public Classes(Model model) {
        this.$init$();
        this.model = model;
        this.defineClass(1, "java/lang/Class");
    }

    public void defineClass(int classId, String name) {
        this.model.getObjects().defineObject(1, classId);
        while (this.classes.size() <= classId) {
            this.classes.add(null);
        }
        ClassInfo info = this.classes.get(classId);
        if (info != null) {
            if (!info.getName().equals(name)) {
                throw new IllegalStateException("Class id " + classId + " already defined as " + info.getName() + " not " + name);
            }
        } else {
            info = new ClassInfo(classId, name);
            this.classes.set(classId, info);
            ArrayList<ClassInfo> tmp = this.classMap.get(name);
            if (tmp == null) {
                tmp = new ArrayList<ClassInfo>(1);
                this.classMap.put(name, tmp);
            }
            tmp.add(info);
        }
    }

    public ClassInfo getClassInfo(int id) {
        ClassInfo info = this.classes.get(id);
        if (info == null) {
            throw new IllegalStateException("Id " + id + " not defined");
        }
        return info;
    }

    public ArrayList<ClassInfo> getClasses(String className) {
        return this.classMap.get(className);
    }
}

