/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import oracle.jdevimpl.profiler.jvmti.CapabilitiesImpl;
import oracle.jdevimpl.profiler.jvmti.SessionImpl;
import oracle.jdevimpl.profiler.support.SessionException;

public class Commands {
    private SessionImpl session;
    private static final char GET_CAPABILITIES = '\u0000';
    private static final char REQUEST_CAPABILITIES = '\u0001';
    private static final char START_COLLECTING = '\u0002';
    private static final char STOP_COLLECTING = '\u0003';
    private static final char SET_FILTER = '\u0004';
    private static final char SET_SAMPLE_INTERVAL = '\u0005';
    private static final char SET_CALL_STACK_MAX = '\u0006';
    private static final char SET_ALLOC_STACK_MAX = '\u0007';
    private static final char START_APPLICATION = '\n';
    private static final byte TIME = 0;
    private static final byte MEMORY = 0;
    private static final byte EVENTS = 0;

    Commands(SessionImpl session) {
        this.session = session;
    }

    private void sendCommand(char commandId) throws IOException {
        this.session.getTransport().sendByte((byte)commandId);
    }

    public synchronized void startApplication() throws SessionException {
        try {
            this.sendCommand('\n');
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    public synchronized void getCapabilities() throws SessionException {
        try {
            this.sendCommand('\u0000');
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    public synchronized void requestCapabilities(CapabilitiesImpl requested) {
        try {
            this.sendCommand('\u0001');
            this.session.getTransport().sendString(requested.stringRep("rc[", "]"));
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    private void startCollecting(byte what) {
        try {
            this.sendCommand('\u0002');
            this.session.getTransport().sendByte(what);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    private void stopCollecting(byte what) {
        try {
            this.sendCommand('\u0003');
            this.session.getTransport().sendByte(what);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    public synchronized void startCollectingTime() throws SessionException {
        this.startCollecting((byte)0);
    }

    public synchronized void stopCollectingTime() throws SessionException {
        this.stopCollecting((byte)0);
    }

    public synchronized void startCollectingMemory() throws SessionException {
        this.startCollecting((byte)0);
    }

    public synchronized void stopCollectingMemory() throws SessionException {
        this.stopCollecting((byte)0);
    }

    public synchronized void startCollectingEvents() throws SessionException {
        this.startCollecting((byte)0);
    }

    public synchronized void stopCollectingEvents() throws SessionException {
        this.stopCollecting((byte)0);
    }

    private String packFilter(String prefix, String filter, String suffix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        boolean first = true;
        boolean insep = false;
        int i = 0;
        int n = filter.length();
        while (i < n) {
            char c = filter.charAt(i);
            if (c == ';' || c == ' ' || c == '\t' || c == ',') {
                insep = true;
            } else {
                if (insep && !first) {
                    buf.append(';');
                }
                first = false;
                insep = false;
                buf.append(c);
            }
            ++i;
        }
        buf.append(suffix);
        return buf.toString();
    }

    private void setFilter(String encodedFilter) {
        try {
            this.sendCommand('\u0004');
            this.session.getTransport().sendString(encodedFilter);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    public synchronized void setStackFilter(String filter) throws SessionException {
        this.setFilter(this.packFilter("sf[", filter, "]"));
    }

    public synchronized void setMemoryFilter(String filter) throws SessionException {
        this.setFilter(this.packFilter("mf[", filter, "]"));
    }

    public synchronized void setEventFilter(String filter) throws SessionException {
        this.setFilter(this.packFilter("ef[", filter, "]"));
    }

    public synchronized void setSampleInterval(long interval) throws SessionException {
        try {
            this.sendCommand('\u0005');
            this.session.getTransport().sendLong(interval);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    public synchronized void setCallStackDepth(int maxDepth) throws SessionException {
        try {
            this.sendCommand('\u0006');
            this.session.getTransport().sendInt(maxDepth);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }
}

