/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import oracle.jdevimpl.jvmti.common.Transport;
import oracle.jdevimpl.profiler.jvmti.EventManager;
import oracle.jdevimpl.profiler.jvmti.SessionImpl;

public class EventLoop
implements Runnable {
    private static EventLoop eventLoop;
    private static SessionImpl session;
    private static Thread eventThread;
    private static boolean stayAlive;

    public static void startEventLoop(SessionImpl session) {
        if (eventLoop != null) {
            throw new IllegalStateException();
        }
        eventLoop = new EventLoop();
        EventLoop.session = session;
        eventThread = new Thread(eventLoop);
        eventThread.setName("ProfilerEventLoop");
        eventThread.setPriority(5);
        stayAlive = true;
        eventThread.start();
    }

    public static void stopEventLoop() {
        if (eventThread != null) {
            stayAlive = false;
            eventThread.interrupt();
        }
    }

    public void run() {
        block4: {
            try {
                while (stayAlive) {
                    Transport transport = session.getTransport();
                    if (transport != null) {
                        char event = (char)transport.receiveByte();
                        EventManager.handleEvent(event, transport);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (!stayAlive) break block4;
                session.abnormalTerminate(e);
            }
        }
    }
}

