/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import java.util.HashMap;
import oracle.jdevimpl.jvmti.common.Transport;
import oracle.jdevimpl.profiler.jvmti.EventHandler;

public class EventManager {
    private static HashMap<Character, EventHandler> handlers;

    public void reset() {
        handlers = null;
    }

    public static synchronized void addEventHandler(char event, EventHandler handler) {
        if (handlers == null) {
            handlers = new HashMap();
        }
        handlers.put(Character.valueOf(event), handler);
    }

    private static synchronized EventHandler getHandler(char event) {
        if (handlers == null) {
            throw new IllegalStateException("Internal error: no event handlers installed");
        }
        if (!handlers.containsKey(Character.valueOf(event))) {
            throw new IllegalStateException("Internal error: no event handlers installed for event " + event);
        }
        return handlers.get(Character.valueOf(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEvent(char event, Transport transport) throws IOException {
        EventHandler handler = EventManager.getHandler(event);
        handler.handleEvent(event, transport);
        EventHandler eventHandler = handler;
        synchronized (eventHandler) {
            handler.notifyAll();
        }
    }

    public static Object getLockObject(char event) {
        return EventManager.getHandler(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForEvent(char event) throws InterruptedException {
        EventHandler handler;
        EventHandler eventHandler = handler = EventManager.getHandler(event);
        synchronized (eventHandler) {
            handler.wait();
        }
    }
}

