/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.profiler.jvmti;

import java.io.IOException;
import oracle.jdevimpl.jvmti.common.Transport;
import oracle.jdevimpl.profiler.jvmti.AgentState;
import oracle.jdevimpl.profiler.jvmti.CapabilitiesImpl;
import oracle.jdevimpl.profiler.jvmti.EventHandler;
import oracle.jdevimpl.profiler.jvmti.EventManager;
import oracle.jdevimpl.profiler.jvmti.SessionImpl;

public class LowLevelEventHandler
implements EventHandler {
    private SessionImpl session;

    LowLevelEventHandler(SessionImpl session) {
        this.session = session;
        EventManager.addEventHandler('\u0000', this);
        EventManager.addEventHandler('\u0001', this);
        EventManager.addEventHandler('\u0002', this);
        EventManager.addEventHandler('\u0003', this);
    }

    public void handleEvent(char event, Transport transport) {
        switch (event) {
            case '\u0000': {
                this.handleAgentState(transport);
                break;
            }
            case '\u0001': {
                this.handleDefineClass(transport);
                break;
            }
            case '\u0002': {
                this.handleDefineObject(transport);
                break;
            }
            case '\u0003': {
                this.handleDefineThread(transport);
                break;
            }
        }
    }

    private void handleAgentState(Transport transport) {
        try {
            AgentState agentState = this.session.getAgentState();
            agentState.setAvailableCapabilities(new CapabilitiesImpl(transport.receiveString(), "ac[", "]"));
            agentState.setRequestedCapabilities(new CapabilitiesImpl(transport.receiveString(), "rc[", "]"));
            agentState.setEnabledCapabilities(new CapabilitiesImpl(transport.receiveString(), "ec[", "]"));
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    private void handleDefineClass(Transport transport) {
        try {
            int objectId = transport.receiveInt();
            String className = transport.receiveString();
            this.session.getModel().getClasses().defineClass(objectId, className);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    private void handleDefineObject(Transport transport) {
        try {
            int classId = transport.receiveInt();
            int objectId = transport.receiveInt();
            this.session.getModel().getObjects().defineObject(classId, objectId);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }

    private void handleDefineThread(Transport transport) {
        try {
            int classId = transport.receiveInt();
            int objectId = transport.receiveInt();
            String threadName = transport.receiveString();
            this.session.getModel().getThreads().defineThread(classId, objectId, threadName);
        }
        catch (IOException e) {
            this.session.transportIOException(e);
        }
    }
}

