/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import oracle.ide.controls.AWTColorComponent;
import oracle.ide.controls.JavaColorChooserPane;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyState;

public final class ColorEditor
implements CmtPropertyEditor {
    private String propName;
    private PropertyChangeListener listener;
    private Color color;
    private ColorChooserPane editor;

    public void setPropertyState(CmtPropertyState ps) {
        this.propName = ps != null ? ps.getProperty().getName() : null;
    }

    public Color getColorValue() {
        return this.color;
    }

    public void setColorValue(Color c) {
        this.color = c;
        this.fire();
        if (this.editor != null) {
            this.editor.setCurrentColor(c);
        }
    }

    public void setValue(Object o) {
        if (o == null) {
            this.setColorValue(Color.black);
        } else {
            this.setColorValue((Color)o);
        }
    }

    public Object getValue() {
        return this.getColorValue();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle box) {
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        g.drawRect(box.x + 3, box.y + 3, 13, box.height - 7);
        g.setColor(this.color);
        g.fillRect(box.x + 4, box.y + 4, 12, box.height - 8);
        g.setColor(oldColor);
        String text = this.getText();
        if (text != null) {
            FontMetrics fm = g.getFontMetrics(g.getFont());
            int height = fm.getAscent() - fm.getDescent();
            int y = box.y + box.height - (box.height - height) / 2;
            SwingUtils.drawString((Graphics)g, (String)text, (int)(box.x + 21), (int)y);
        }
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String s) {
    }

    protected String getText() {
        Color v = this.getColorValue();
        if (v == null) {
            return null;
        }
        String text = AWTColorComponent.getText((Color)v);
        if (text == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(v.getRed());
            buf.append(", ");
            buf.append(v.getGreen());
            buf.append(", ");
            buf.append(v.getBlue());
            return buf.toString();
        }
        return text;
    }

    public String getJavaInitializationString() {
        String text = AWTColorComponent.getText((Color)this.getColorValue());
        if (text != null) {
            return "java.awt." + text;
        }
        text = "new java.awt.Color(" + this.color.getRed() + ", " + this.color.getGreen() + ", " + this.color.getBlue() + ")";
        return text;
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ColorChooserPane(this.getColorValue());
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this.editor), "f1_guipropedcolor_html");
        }
        return this.editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, this.propName, null, this.getValue()));
        }
    }

    static void wa$color(ColorEditor colorEditor, Color color) {
        colorEditor.color = color;
    }

    private class ColorChooserPane
    extends JavaColorChooserPane
    implements VetoableChangeListener {
        public ColorChooserPane(Color c) {
            super(c);
        }

        public void vetoableChange(PropertyChangeEvent e) {
            if ("closed".equals(e.getPropertyName()) && Boolean.TRUE.equals(e.getNewValue())) {
                Color c = this.getSelectedColor();
                ColorEditor.wa$color(ColorEditor.this, c);
                ColorEditor.this.fire();
            }
        }
    }
}

