/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;

public final class DimensionEditor
implements PropertyEditor {
    private PropertyChangeListener listener;
    private Dimension value;

    public void setValue(Object o) {
        this.value = (Dimension)o;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return String.valueOf(this.value.width) + ", " + this.value.height;
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return null;
        }
        return "new java.awt.Dimension(" + this.value.width + ", " + this.value.height + ")";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(text, ",");
        String[] argv = new String[tokenizer.countTokens()];
        int argc = 0;
        while (tokenizer.hasMoreTokens()) {
            argv[argc++] = tokenizer.nextToken().trim();
        }
        if (argc != 2) {
            throw new IllegalArgumentException();
        }
        try {
            this.value = new Dimension(Integer.parseInt(argv[0]), Integer.parseInt(argv[1]));
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException();
        }
        this.fire();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, null, null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

