/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.collection.Range;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.propertyeditor.Res;
import oracle.jdevimpl.propertyeditor.SortedComboBoxModel;

public class FontChooserPanel
extends JPanel
implements ItemListener,
ChangeListener,
ActionListener {
    Font font;
    boolean changed;
    GridBagLayout gridBagLayout1;
    JLabel nameLabel;
    JComboBox nameList;
    JCheckBox boldBox;
    JCheckBox italicBox;
    JLabel sizeLabel;
    NumericSpinBox sizeField;
    JLabel sampleLabel;
    JTextField sampleField;

    public FontChooserPanel() {
        this.$init$();
        try {
            this.init();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guipropedfont_html");
        }
        catch (Exception x) {
            Assert.printStackTrace((Throwable)x);
        }
    }

    public FontChooserPanel(Font font) {
        this();
        this.setFontValue(font);
    }

    private void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.nameLabel = new JLabel();
        this.nameList = new JComboBox();
        this.boldBox = new JCheckBox();
        this.italicBox = new JCheckBox();
        this.sizeLabel = new JLabel();
        this.sizeField = new NumericSpinBox();
        this.sampleLabel = new JLabel();
        this.sampleField = new JTextField();
    }

    void init() {
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        SortedComboBoxModel model = new SortedComboBoxModel();
        int i = fontList.length - 1;
        while (i >= 0) {
            model.addElement(fontList[i]);
            --i;
        }
        this.nameList.setModel(model);
        this.nameList.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.nameLabel, (Component)this.nameList, (String)Res.getString(88));
        this.boldBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.boldBox, (String)Res.getString(171));
        this.italicBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.italicBox, (String)Res.getString(71));
        this.sizeField.setRange(new Range(1, 1000));
        this.sizeField.addChangeListener((ChangeListener)this);
        ResourceUtils.resLabel((JLabel)this.sizeLabel, (Component)this.sizeField, (String)Res.getString(78));
        this.sampleLabel.setText(Res.getString(143));
        this.sampleField.setText(Res.getString(44));
        this.sampleField.setEditable(false);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.nameList, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.boldBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.italicBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.sizeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.sizeField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.sampleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.sampleField, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 150, 50));
    }

    public Font getFontValue() {
        return this.font;
    }

    public void setFontValue(Font font) {
        if (font != null) {
            this.sizeField.setIntValue(font.getSize());
            this.changeFont(font);
        } else {
            this.sizeField.setIntValue(12);
            this.nameList.setSelectedItem(null);
        }
        this.sizeField.setEnabled(font != null);
        this.boldBox.setEnabled(font != null);
        this.italicBox.setEnabled(font != null);
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void fontChanged(Font newFont) {
        this.changed = true;
    }

    protected void changeFont(Font font) {
        this.changeFont(font, false, false);
    }

    protected void changeFont(Font font, boolean suppressList, boolean suppressText) {
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (font == null) {
            return;
        }
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (!suppressList && fontList != null && this.nameList != null) {
            int i = 0;
            while (i < fontList.length) {
                if (fontList[i].equals(font.getName())) {
                    this.nameList.setSelectedItem(fontList[i]);
                    break;
                }
                ++i;
            }
        }
        if (this.boldBox != null) {
            this.boldBox.setSelected(font.isBold());
        }
        if (this.italicBox != null) {
            this.italicBox.setSelected(font.isItalic());
        }
        this.sampleField.setFont(font);
        this.fontChanged(font);
    }

    int getFontSize() {
        return this.sizeField.getIntValue();
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateFont(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.updateFont(true);
    }

    public void stateChanged(ChangeEvent e) {
        this.itemStateChanged(null);
    }

    private void updateFont(boolean listAsOrigin) {
        String name = (String)this.nameList.getSelectedItem();
        this.sizeField.setEnabled(true);
        this.boldBox.setEnabled(true);
        this.italicBox.setEnabled(true);
        Font f = new Font(name != null ? name : "Dialog", (this.boldBox.isSelected() ? 1 : 0) + (this.italicBox.isSelected() ? 2 : 0), this.getFontSize());
        this.changeFont(f, listAsOrigin, false);
    }
}

