/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import oracle.jdevimpl.propertyeditor.ActualFontEditor;

public final class FontEditor
implements PropertyEditor {
    PropertyChangeListener listener;
    Font font;
    ActualFontEditor editor;
    private static final int LEADING_SPACE = 1;
    private static final int UNQUOTED_ARG = 2;
    private static final int QUOTED_ARG = 3;
    private static final int TRAILING_SPACE = 4;

    public Font getFontValue() {
        return this.font;
    }

    public void setFontValue(Font f) {
        if (this.editor != null) {
            this.editor.setFontValue(f);
        } else {
            this.font = f;
            this.fire();
        }
    }

    public void setValue(Object o) {
        this.setFontValue((Font)o);
    }

    public Object getValue() {
        return this.getFontValue();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle box) {
    }

    public String getAsText() {
        Font font = this.getFontValue();
        return font != null ? "\"" + font.getName() + "\", " + this.getStyleText() + ", " + font.getSize() : "";
    }

    public String getJavaInitializationString() {
        return "new java.awt.Font(" + this.getAsText() + ")";
    }

    private String getStyleText() {
        Font font = this.getFontValue();
        return String.valueOf(font.getStyle());
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String[] args = this.splitArgs(text);
        if (args == null || args.length != 3) {
            throw new IllegalArgumentException();
        }
        try {
            String fontName = args[0];
            int fontStyle = Integer.parseInt(args[1]);
            int fontSize = Integer.parseInt(args[2]);
            this.setValue(new Font(fontName, fontStyle, fontSize));
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ActualFontEditor(this);
        }
        return this.editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "FontEditor???", null, this.getValue()));
        }
    }

    private String[] splitArgs(String text) {
        ArrayList<String> result = new ArrayList<String>();
        int state = 1;
        StringBuffer sb = new StringBuffer();
        int count = text != null ? text.length() : 0;
        int i = 0;
        while (i < count) {
            char c = text.charAt(i);
            switch (state) {
                case 1: {
                    if (c == '\"') {
                        state = 3;
                        sb.setLength(0);
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = 2;
                    sb.setLength(0);
                    this.copyChar(text, i, sb);
                    break;
                }
                case 3: {
                    if (c == '\"') {
                        state = 4;
                        result.add(sb.toString());
                        break;
                    }
                    this.copyChar(text, i, sb);
                    break;
                }
                case 2: {
                    if (c == ',') {
                        state = 1;
                        result.add(sb.toString().trim());
                        break;
                    }
                    this.copyChar(text, i, sb);
                    break;
                }
                case 4: {
                    if (c != ',') break;
                    state = 1;
                    break;
                }
            }
            i = this.nextPos(text, i);
        }
        if (state == 2) {
            result.add(sb.toString().trim());
        } else if (state == 3) {
            result.add(sb.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private int nextPos(String text, int index) {
        char c = text.charAt(index);
        if (Character.isHighSurrogate(c)) {
            return index + 2;
        }
        return index + 1;
    }

    private void copyChar(String text, int index, StringBuffer target) {
        char c = text.charAt(index);
        if (Character.isHighSurrogate(c)) {
            if (index + 1 < text.length()) {
                target.append(c);
                target.append(text.charAt(index + 1));
            }
        } else {
            target.append(c);
        }
    }
}

