/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.ResultCallback;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtPropertyEditor2;
import oracle.jdeveloper.cmt.CmtPropertySetting;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.propertyeditor.Res;

public final class IconEditor
implements CmtPropertyEditor2 {
    Project project;
    HashMap hash;
    private String valueText;
    private String propertyText;
    private PropertyChangeListener listener;
    private Object value;
    private CmtPropertyState ps;

    private void $init$() {
        this.hash = new HashMap();
    }

    public IconEditor() {
        this.$init$();
    }

    private boolean isImage(String text, String[] extensions) {
        if (extensions == null) {
            return false;
        }
        String[] stringArray = extensions;
        int n = 0;
        while (n < stringArray.length) {
            String extension = stringArray[n];
            if (extension != null && text.endsWith(extension)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        boolean isImage;
        Object obj;
        if (text == null) {
            throw new IllegalArgumentException("Text is null");
        }
        if (text.length() == 0) {
            text = Res.getString(40);
        }
        if (text.equals(Res.getString(40))) {
            this.value = null;
            return;
        }
        CmtComponent c = null;
        Object object = obj = this.ps != null ? this.ps.getObject() : null;
        if (obj == null) {
            return;
        }
        if (obj instanceof CmtSubcomponent) {
            c = ((CmtSubcomponent)obj).getOuterComponent();
        }
        if (isImage = this.isImage(text, GraphicsUtils.getImageExtensions())) {
            block17: {
                try {
                    String designDir = null;
                    if (c != null) {
                        String designFile = c.getFile().getURL().getPath();
                        designDir = designFile.substring(0, designFile.lastIndexOf(File.separator) + 1);
                    }
                    this.valueText = (String)this.hash.get(text);
                    this.propertyText = "new ImageIcon(new java.net.URL(\"" + this.valueText.replace('\\', '/') + "\"))";
                    String imageName = this.valueText.substring(8);
                    int zipEntry = imageName.indexOf(93);
                    if (zipEntry > 0) {
                        this.setPropertyText(imageName.substring(zipEntry + 1), text);
                        break block17;
                    }
                    if (c != null && imageName.startsWith(designDir)) {
                        imageName = imageName.substring(designDir.length());
                        imageName = imageName.replace('\\', '/');
                        this.propertyText = "new ImageIcon(" + c.getType().getName() + ".class.getResource(\"" + imageName + "\"))";
                    } else {
                        String imagePackage;
                        String dir = PathsConfiguration.getInstance((Project)this.project).getSourcePath().toString();
                        if (!imageName.startsWith(dir = dir.substring(0, dir.indexOf(File.pathSeparator)))) {
                            dir = URLFileSystem.getPlatformPathName((URL)JavaProject.getInstance((Project)this.project).getOutputDirectory());
                        }
                        if (imageName.startsWith(dir) && this.setPropertyText(imagePackage = imageName.substring(dir.length()), text)) break block17;
                    }
                    this.value = new ImageIcon(new URL(this.valueText));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.firePropertyChange();
            return;
        }
        if (c != null) {
            CmtSubcomponent[] subcomponents = c.getSubcomponents();
            int i = 0;
            while (i < subcomponents.length) {
                if (subcomponents[i].getName().equals(text)) {
                    this.value = subcomponents[i].getLiveInstance();
                    this.firePropertyChange();
                    return;
                }
                ++i;
            }
        }
    }

    boolean setPropertyText(String imagePackage, String imageFile) {
        if (imagePackage.startsWith("\\")) {
            imagePackage = imagePackage.substring(1);
        }
        imagePackage = imagePackage.substring(0, imagePackage.length() - imageFile.length() - 1);
        imagePackage = imagePackage.replace('\\', '.');
        CmtPackages pkgs = this.ps.getSubcomponent().getOuterComponent().getComponents().getPackages();
        while (true) {
            try {
                JavaPackage pkg = pkgs.getPackage(imagePackage);
                Iterator clsIter = pkg.getDeclaredClasses().iterator();
                if (clsIter.hasNext()) {
                    JavaClass cls = (JavaClass)clsIter.next();
                    String clsName = cls.getQualifiedName();
                    int idx = clsName.lastIndexOf(46);
                    if (idx != -1) {
                        clsName = clsName.substring(idx + 1);
                    }
                    this.propertyText = "new ImageIcon(" + clsName + ".class.getResource(\"" + imageFile + "\"))";
                    this.value = new ImageIcon(pkgs.loadClass(cls.getQualifiedName(), false).getResource(imageFile));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int i = imagePackage.lastIndexOf(46);
            if (i < 0) break;
            imageFile = imagePackage.substring(i + 1) + "/" + imageFile;
            imagePackage = imagePackage.substring(0, i);
        }
        return false;
    }

    public String[] getTags() {
        ArrayList<String> tagsArray = new ArrayList<String>();
        Object obj = this.ps != null ? this.ps.getObject() : null;
        this.hash.clear();
        tagsArray.add(Res.getString(40));
        if (obj instanceof CmtSubcomponent) {
            CmtComponent source = ((CmtSubcomponent)obj).getOuterComponent();
            CmtSubcomponent[] subcomponents = source.getSubcomponents();
            JavaType propType = this.ps.getProperty().getType();
            if (propType != null) {
                int i = 0;
                while (i < subcomponents.length) {
                    JavaClass scClass;
                    if (obj != subcomponents[i] && (scClass = subcomponents[i].getDeclaredClass()) != null && propType.isAssignableFrom((JavaType)scClass)) {
                        tagsArray.add(subcomponents[i].getName());
                    }
                    ++i;
                }
            }
        }
        if (obj != null && this.project != null) {
            String[] extensions = GraphicsUtils.getImageExtensions();
            1 callback = new 1(this, extensions, tagsArray);
            Index index = IndexManager.getIndexManager().getIndex(this.project);
            try {
                index.findNodes(Locatable.class, (ResultCallback)callback);
            }
            finally {
                index.release();
            }
        }
        String[] tags = new String[tagsArray.size()];
        tagsArray.toArray(tags);
        return tags;
    }

    private String getAsText(boolean forSource) {
        if (this.value != null) {
            Object obj;
            Object object = obj = this.ps != null ? this.ps.getObject() : null;
            if (obj instanceof CmtSubcomponent) {
                CmtComponent component = ((CmtSubcomponent)obj).getOuterComponent();
                CmtSubcomponent[] subcomponents = component.getSubcomponents();
                int i = 0;
                while (i < subcomponents.length) {
                    Object instance = subcomponents[i].getLiveInstance();
                    if (instance == this.value) {
                        return forSource ? subcomponents[i].getName() : subcomponents[i].getName();
                    }
                    ++i;
                }
            }
            return forSource ? this.propertyText : this.getValueSource();
        }
        return forSource && this.value == null ? "null" : "";
    }

    String getValueSource() {
        if (this.ps != null) {
            int j;
            int i;
            String source;
            CmtPropertySetting prop = this.ps.getPropertySetting();
            String string = source = prop != null ? prop.getValueSource() : null;
            if (source != null && (i = source.indexOf(34)) > 0 & (j = source.lastIndexOf(34)) > i) {
                return source.substring(i + 1, j);
            }
            return source;
        }
        return "null";
    }

    public String getAsText() {
        return this.getAsText(false);
    }

    public String getJavaInitializationString() {
        return this.getAsText(true);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void prepareOpen() {
    }

    public void prepareCommit() throws PropertyVetoException {
    }

    public void setPropertyState(CmtPropertyState ps) {
        this.ps = ps;
    }

    public void setValue(Object o) {
        this.value = o;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void firePropertyChange() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "SubcomponentChoiceEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    final class 1
    implements ResultCallback {
        private final /* synthetic */ String[] v$extensions;
        private final /* synthetic */ ArrayList v$tagsArray;
        final /* synthetic */ IconEditor this$0;

        public void result(Node child) {
            if (!(child instanceof Locatable)) {
                return;
            }
            URL childURL = ((Locatable)child).getURL();
            String childFile = childURL.getFile();
            if (child.mayHaveChildren()) {
                Iterator moreChildren = child.getChildren();
                while (moreChildren.hasNext()) {
                    Element grandChild = (Element)moreChildren.next();
                    if (!(grandChild instanceof Locatable)) continue;
                    URL grandChildURL = ((Locatable)grandChild).getURL();
                    String grandChildFile = grandChildURL.getFile();
                    boolean isImage = false;
                    if (this.v$extensions != null) {
                        int i = 0;
                        while (i < this.v$extensions.length) {
                            if (this.v$extensions[i] != null && grandChildFile.endsWith(this.v$extensions[i])) {
                                isImage = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!isImage) continue;
                    String imageName = grandChildFile.substring(grandChildFile.lastIndexOf(File.separator) + 1);
                    this.v$tagsArray.add(imageName);
                    this.this$0.hash.put(imageName, grandChildFile);
                }
            } else {
                boolean isImage = false;
                if (this.v$extensions != null) {
                    int i = 0;
                    while (i < this.v$extensions.length) {
                        if (this.v$extensions[i] != null && childFile.endsWith(this.v$extensions[i])) {
                            isImage = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (isImage) {
                    String imageName = childFile.substring(childFile.lastIndexOf(File.separator) + 1);
                    this.v$tagsArray.add(imageName);
                    this.this$0.hash.put(imageName, childFile);
                }
            }
        }

        public void done() {
        }

        public 1(IconEditor iconEditor, String[] stringArray, ArrayList arrayList) {
            this.v$tagsArray = arrayList;
            this.v$extensions = stringArray;
            this.this$0 = iconEditor;
        }
    }
}

