/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class IntegerTagEditor
implements PropertyEditor {
    private int[] values;
    private String[] resourceStrings;
    private String[] sourceCodeStrings;
    private PropertyChangeListener listener;
    private Object value;

    public IntegerTagEditor(int[] values, String[] resourceStrings, String[] sourceCodeStrings) {
        if (values == null) {
            values = new int[resourceStrings.length];
            int i = 0;
            while (i < values.length) {
                values[i] = i;
                ++i;
            }
        }
        this.values = values;
        this.resourceStrings = resourceStrings;
        this.sourceCodeStrings = sourceCodeStrings != null ? sourceCodeStrings : resourceStrings;
    }

    public IntegerTagEditor(int[] values, String[] resourceStrings, String[] sourceCodeStrings, boolean sort) {
        this(values, resourceStrings, sourceCodeStrings);
        if (sort) {
            int i = 0;
            while (i < resourceStrings.length) {
                int j = i + 1;
                while (j < resourceStrings.length) {
                    int compare = resourceStrings[i].compareTo(resourceStrings[j]);
                    if (compare > 0) {
                        String s = resourceStrings[i];
                        resourceStrings[i] = resourceStrings[j];
                        resourceStrings[j] = s;
                        s = sourceCodeStrings[i];
                        sourceCodeStrings[i] = sourceCodeStrings[j];
                        sourceCodeStrings[j] = s;
                        int iVal = values[i];
                        values[i] = values[j];
                        values[j] = iVal;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public final void setValue(Object o) {
        this.value = o;
        this.fire();
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isPaintable() {
        return false;
    }

    public final void paintValue(Graphics gfx, Rectangle box) {
    }

    private String getAsText(boolean forSourceCode) {
        int iVal = this.value == null || !(this.value instanceof Integer) ? this.values[0] : (Integer)this.value;
        int iPos = 0;
        while (iPos < this.values.length) {
            if (this.values[iPos] == iVal) break;
            ++iPos;
        }
        if (iPos >= this.values.length) {
            return "";
        }
        return forSourceCode ? this.sourceCodeStrings[iPos] : this.resourceStrings[iPos];
    }

    public final String getAsText() {
        return this.getAsText(false);
    }

    public final String getJavaInitializationString() {
        return this.getAsText(true);
    }

    public final void setAsText(String text) throws IllegalArgumentException {
        int iPos = 0;
        if (text != null) {
            while (iPos < this.resourceStrings.length) {
                if (text.equals(this.resourceStrings[iPos])) break;
                ++iPos;
            }
            if (iPos >= this.resourceStrings.length) {
                throw new IllegalArgumentException();
            }
            this.value = new Integer(this.values[iPos]);
            this.fire();
        }
    }

    public final String[] getTags() {
        return this.resourceStrings;
    }

    public final Component getCustomEditor() {
        return null;
    }

    public final boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "???", null, this.value));
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

