/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.jdevimpl.propertyeditor.Res;

public final class LocaleEditor
implements PropertyEditor {
    static String[] resourceStrings;
    static boolean initialized;
    private boolean defaultSelected;
    private String[][] locales;
    private PropertyChangeListener listener;
    private Locale value;

    private void $init$() {
        this.defaultSelected = false;
        this.locales = new String[][]{{"ar", "Arabic"}, {"be", "Byelorussian"}, {"bg", "Bulgarian"}, {"ca", "Catalan"}, {"cs", "Czech"}, {"da", "Danish"}, {"de", "German"}, {"de_AT", "German (Austria)"}, {"de_CH", "German (Switzerland)"}, {"el", "Greek"}, {"en", "English"}, {"en_AU", "English (Australia)"}, {"en_CA", "English (Canada)"}, {"en_GB", "English (United Kingdom)"}, {"en_IE", "English (Ireland)"}, {"en_NZ", "English (New Zealand)"}, {"en_ZA", "English (South Africa)"}, {"es", "Spanish"}, {"es_AR", "Spanish (Argentina)"}, {"es_BO", "Spanish (Bolivia)"}, {"es_CL", "Spanish (Chile)"}, {"es_CO", "Spanish (Colombia)"}, {"es_CR", "Spanish (Costa Rica)"}, {"es_DO", "Spanish (Dominican Republic)"}, {"es_EC", "Spanish (Ecuador)"}, {"es_GT", "Spanish (Guatemala"}, {"es_HN", "Spanish (Honduras)"}, {"es_MX", "Spanish (Mexico)"}, {"es_NI", "Spanish (Nicaragua"}, {"es_PA", "Spanish (Panama)"}, {"es_PE", "Spanish (Peru)"}, {"es_PR", "Spanish (Puerto Rico)"}, {"es_PY", "Spanish (Paraguay)"}, {"es_SV", "Spanish (El Salvador)"}, {"es_UY", "Spanish (Uruguay)"}, {"es_VE", "Spanish (Venezuela)"}, {"et", "Estonian"}, {"fi", "Finnish"}, {"fr", "French"}, {"fr_BE", "French (Belgium)"}, {"fr_CA", "French (Canada)"}, {"fr_CH", "French (Switzerland)"}, {"hr", "Croatian"}, {"hu", "Hungarian"}, {"is", "Icelandic"}, {"it", "Italian"}, {"it_CH", "Italian (Switzerland)"}, {"iw", "Hebrew"}, {"ja", "Japanese"}, {"ko", "Korean "}, {"lt", "Lithuanian"}, {"lv", "Latvian (Lettish)"}, {"mk", "Macedonian"}, {"nl", "Dutch"}, {"nl_BE", "Dutch (Belgium)"}, {"no", "Norwegian"}, {"no_NO_NY", "Norwegian (Norway, NY)"}, {"pl", "Polish"}, {"pt", "Portuguese"}, {"pt_BR", "Portuguese (Brazil)"}, {"ro", "Romanian"}, {"ru", "Russian"}, {"sh", "Serbo-Croatian"}, {"sk", "Slovak"}, {"sl", "Slovenian"}, {"sq", "Albanian"}, {"sr", "Serbian"}, {"sv", "Swedish"}, {"th", "Thai"}, {"tr", "Turkish"}, {"uk", "Ukrainian"}, {"zh", "Chinese"}, {"zh_TW", "Chinese (Taiwan)"}};
    }

    public LocaleEditor() {
        this.$init$();
        if (!initialized) {
            initialized = true;
            resourceStrings = new String[this.locales.length + 1];
            LocaleEditor.resourceStrings[0] = Res.getString(184);
            String currentLocaleId = Locale.getDefault().toString();
            int i = 0;
            while (i < this.locales.length) {
                LocaleEditor.resourceStrings[i + 1] = currentLocaleId.equals(this.locales[i][0]) ? LocaleEditor.getLocaleDisplayName(Locale.getDefault()) : this.locales[i][1] + " [" + this.locales[i][0] + "]";
                ++i;
            }
        }
    }

    private static String getLocaleDisplayName0(Locale loc, Locale locDisp) {
        String variant;
        StringBuffer result = new StringBuffer(loc.getDisplayLanguage(locDisp));
        String country = loc.getCountry().length() != 0 ? loc.getDisplayCountry(locDisp) : "";
        String string = variant = loc.getVariant().length() != 0 ? loc.getDisplayVariant(locDisp) : "";
        if (country.length() != 0 || variant.length() != 0) {
            result.append(" (");
            result.append(country);
            if (country.length() != 0 && variant.length() != 0) {
                result.append(",");
            }
            result.append(variant);
            result.append(")");
        }
        return result.toString();
    }

    private static String getLocaleDisplayName(Locale loc) {
        String result = loc.getLanguage().equals(Locale.getDefault().getLanguage()) ? LocaleEditor.getLocaleDisplayName0(loc, loc) : LocaleEditor.getLocaleDisplayName0(loc, Locale.ENGLISH);
        return result + " [" + loc.toString() + "]".toString();
    }

    private static String getConstructorString(Locale loc) {
        return "new java.util.Locale(\"" + loc.getLanguage() + "\", \"" + loc.getCountry() + "\", \"" + loc.getVariant() + "\")";
    }

    public void setValue(Object o) {
        this.defaultSelected = o == null || o == Locale.getDefault();
        this.value = (Locale)o;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        if (this.defaultSelected) {
            return Res.getString(184);
        }
        return LocaleEditor.getLocaleDisplayName(this.value);
    }

    public String getJavaInitializationString() {
        if (this.value == null) {
            return null;
        }
        if (this.defaultSelected) {
            return "java.util.Locale.getDefault()";
        }
        return LocaleEditor.getConstructorString(this.value);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text != null) {
            int pos = 0;
            while (pos < resourceStrings.length) {
                if (text.equals(resourceStrings[pos])) {
                    if (pos == 0) {
                        this.defaultSelected = true;
                        this.value = Locale.getDefault();
                    } else {
                        this.value = LocaleEditor.getLocale(this.locales[pos - 1][0]);
                        this.defaultSelected = false;
                    }
                    this.fire();
                    return;
                }
                ++pos;
            }
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return resourceStrings;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "LocaleEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    static Locale getLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] strings = new String[3];
        strings[2] = "";
        strings[1] = "";
        strings[0] = "";
        StringTokenizer tokenizer = new StringTokenizer(localeString, "_");
        int i = 0;
        while (i < strings.length && tokenizer.hasMoreTokens()) {
            strings[i] = tokenizer.nextToken();
            ++i;
        }
        return new Locale(strings[0], strings[1], strings[2]);
    }

    static {
        initialized = false;
    }
}

