/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import oracle.ide.util.FastStringBuffer;

public class StringEditor
implements PropertyEditor {
    private static String[] logicalChars = new String[]{"<TAB>", "<CR>", "<NL>", "<FF>", "<<>", "<LF>"};
    private static char[] physicalChars = new char[]{'\t', '\r', '\n', '\f', '<', '\n'};
    private PropertyChangeListener listener;
    protected String value;

    public final void setValue(Object o) {
        this.value = (String)o;
        this.fire();
    }

    public final Object getValue() {
        return this.value;
    }

    public final boolean isPaintable() {
        return false;
    }

    public final void paintValue(Graphics gfx, Rectangle box) {
    }

    public final String getAsText() {
        String s = this.value == null ? null : StringEditor.rawTextToDisplay(this.value);
        return s;
    }

    public String getJavaInitializationString() {
        String s = StringEditor.textToSource(this.value);
        return s;
    }

    public static final String textToSource(String text) {
        return FastStringBuffer.textToSource((String)text, (boolean)false).toString();
    }

    public final void setAsText(String text) throws IllegalArgumentException {
        this.value = text == null ? null : StringEditor.displayTextToRaw(text);
    }

    public final String[] getTags() {
        return null;
    }

    public final Component getCustomEditor() {
        return null;
    }

    public final boolean supportsCustomEditor() {
        return false;
    }

    public static final boolean inCurrentCodePage(char ch) {
        String src = String.valueOf(ch);
        byte[] bts = src.getBytes();
        String dst = new String(bts);
        return src.charAt(0) == dst.charAt(0);
    }

    public static final String rawTextToDisplay(String s) {
        FastStringBuffer src = new FastStringBuffer(s);
        FastStringBuffer dst = new FastStringBuffer();
        char ch = src.firstChar();
        while (ch != '\u0000') {
            int i = 0;
            while (i < physicalChars.length) {
                if (ch == physicalChars[i]) {
                    dst.append(logicalChars[i]);
                    break;
                }
                ++i;
            }
            if (i >= physicalChars.length) {
                if (ch > '\u001f' && StringEditor.inCurrentCodePage(ch)) {
                    dst.append(ch);
                } else {
                    dst.append("<" + Integer.toString(ch, 16) + ">");
                }
            }
            ch = src.nextChar();
        }
        return dst.toString();
    }

    public static final String displayTextToRaw(String s) {
        FastStringBuffer src = new FastStringBuffer(s);
        FastStringBuffer dst = new FastStringBuffer();
        char ch = src.firstChar();
        while (ch != '\u0000') {
            if (ch != '<') {
                dst.append(ch);
            } else {
                int offset = src.getOffset();
                FastStringBuffer log = new FastStringBuffer();
                ch = src.nextChar();
                while (ch != '\u0000') {
                    if (ch == '>') {
                        String logStr = "<" + log.toString() + ">";
                        int i = 0;
                        while (i < logicalChars.length) {
                            if (logStr.equalsIgnoreCase(logicalChars[i])) {
                                dst.append(physicalChars[i]);
                                break;
                            }
                            ++i;
                        }
                        if (i < logicalChars.length) break;
                        String logStrNumber = log.toString();
                        try {
                            dst.append((char)Integer.valueOf(logStrNumber, 16).intValue());
                        }
                        catch (Exception ex) {
                            dst.append(logStr);
                        }
                        break;
                    }
                    log.append(ch);
                    ch = src.nextChar();
                }
                if (ch == '\u0000') {
                    dst.append('<');
                    src.setOffset(offset);
                }
            }
            ch = src.nextChar();
        }
        return dst.toString();
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, null, null, this.value));
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

