/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.AddinManager;
import oracle.ide.docking.DockableView;
import oracle.ide.inspector.Extension;
import oracle.ide.inspector.InspectorManager;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtExtension;
import oracle.jdeveloper.cmt.CmtPropertyEditor;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.inspector.extension.BorderExtension;
import oracle.jdevimpl.inspector.extension.BoundedRangeModelExtension;
import oracle.jdevimpl.inspector.extension.ButtonModelExtension;
import oracle.jdevimpl.inspector.extension.CaretExtension;
import oracle.jdevimpl.inspector.extension.ComboBoxModelExtension;
import oracle.jdevimpl.inspector.extension.DocumentExtension;
import oracle.jdevimpl.inspector.extension.EditorKitExtension;
import oracle.jdevimpl.inspector.extension.JTableHeaderExtension;
import oracle.jdevimpl.inspector.extension.KeyStrokeExtension;
import oracle.jdevimpl.inspector.extension.ListModelExtension;
import oracle.jdevimpl.inspector.extension.ListSelectionModelExtension;
import oracle.jdevimpl.inspector.extension.TableColumnModelExtension;
import oracle.jdevimpl.inspector.extension.TableModelExtension;
import oracle.jdevimpl.inspector.extension.TreeSelectionModelExtension;
import oracle.jdevimpl.propertyeditor.Res;
import oracle.jdevimpl.propertyeditor.ResetsOnNull;

public final class SubcomponentChoiceEditor
implements CmtPropertyEditor,
ResetsOnNull,
PropertyChangeListener {
    public static final String EXTENSION_PREFIX = "jdeveloper.editorextension.";
    private static HashMap typeToExtensions = new HashMap();
    private PropertyChangeListener listener;
    private Object value;
    private CmtPropertyState ps;
    private Extension extension;
    private String lastTag;
    private String secondLastTag;

    static {
        typeToExtensions.put("javax.swing.border.Border", new Extension[]{new BorderExtension()});
        typeToExtensions.put("javax.swing.BoundedRangeModel", new Extension[]{new BoundedRangeModelExtension()});
        typeToExtensions.put("javax.swing.ButtonModel", new Extension[]{new ButtonModelExtension()});
        typeToExtensions.put("javax.swing.text.Caret", new Extension[]{new CaretExtension()});
        typeToExtensions.put("javax.swing.ComboBoxModel", new Extension[]{new ComboBoxModelExtension()});
        typeToExtensions.put("javax.swing.text.Document", new Extension[]{new DocumentExtension()});
        typeToExtensions.put("javax.swing.text.EditorKit", new Extension[]{new EditorKitExtension()});
        typeToExtensions.put("javax.swing.table.JTableHeader", new Extension[]{new JTableHeaderExtension()});
        typeToExtensions.put("javax.swing.KeyStroke", new Extension[]{new KeyStrokeExtension()});
        typeToExtensions.put("javax.swing.ListModel", new Extension[]{new ListModelExtension()});
        typeToExtensions.put("javax.swing.ListSelectionModel", new Extension[]{new ListSelectionModelExtension()});
        typeToExtensions.put("javax.swing.table.TableColumnModel", new Extension[]{new TableColumnModelExtension()});
        typeToExtensions.put("javax.swing.table.TableModel", new Extension[]{new TableModelExtension()});
        typeToExtensions.put("javax.swing.tree.TreeSelectionModel", new Extension[]{new TreeSelectionModelExtension()});
        Properties properties = AddinManager.getAddinManager().getProductProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(EXTENSION_PREFIX)) continue;
            String type = key.substring(EXTENSION_PREFIX.length());
            String extensions = properties.getProperty(key);
            StringTokenizer tokenizer = new StringTokenizer(extensions, ";");
            while (tokenizer.hasMoreTokens()) {
                String extName = tokenizer.nextToken();
                try {
                    Extension[] newArray;
                    Class<?> cls = Class.forName(extName);
                    Extension ext = (Extension)cls.newInstance();
                    Extension[] oldArray = (Extension[])typeToExtensions.get(type);
                    if (oldArray != null) {
                        newArray = new Extension[oldArray.length + 1];
                        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
                    } else {
                        newArray = new Extension[1];
                    }
                    newArray[newArray.length - 1] = ext;
                    typeToExtensions.put(type, newArray);
                }
                catch (Exception e) {
                    System.err.println("Extension for " + extName + " could not be registered: " + extensions);
                }
            }
        }
    }

    private void $init$() {
        this.extension = null;
        this.lastTag = null;
        this.secondLastTag = null;
    }

    public void setPropertyState(CmtPropertyState ps) {
        this.ps = ps;
        if (this.extension instanceof CmtExtension) {
            ((CmtExtension)this.extension).setPropertyState(ps);
        }
    }

    public void setValue(Object o) {
        this.value = o;
        if (this.extension != null) {
            this.extension.removePropertyChangeListener((PropertyChangeListener)this);
            this.extension = null;
        }
        this.secondLastTag = this.lastTag;
        this.lastTag = this.getAsText();
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
    }

    private String getAsText(boolean forSource) {
        Extension ext;
        if (this.value != null && this.ps != null) {
            CmtComponent component = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] subcomponents = component.getSubcomponents();
            int i = 0;
            while (i < subcomponents.length) {
                if (subcomponents[i].getLiveInstance() == this.value) {
                    return subcomponents[i].getName();
                }
                ++i;
            }
        }
        if ((ext = this.getExtension()) != null) {
            return forSource ? ext.getJavaInitializationString() : ext.getDisplayString();
        }
        return forSource && this.value == null ? "null" : Res.getString(189);
    }

    public String getAsText() {
        return this.getAsText(false);
    }

    public String getJavaInitializationString() {
        this.lastTag = this.secondLastTag;
        return this.getAsText(true);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text != null) {
            if (text.equals(Res.getString(189))) {
                this.value = null;
                this.firePropertyChange();
                return;
            }
            if (text.equals(this.lastTag)) {
                return;
            }
            if (this.ps != null) {
                Extension[] extensions;
                CmtComponent component = this.ps.getSubcomponent().getOuterComponent();
                CmtSubcomponent[] subcomponents = component.getSubcomponents();
                int i = 0;
                while (i < subcomponents.length) {
                    if (subcomponents[i].getName().equals(text)) {
                        this.value = subcomponents[i].getLiveInstance();
                        this.lastTag = text;
                        this.firePropertyChange();
                        return;
                    }
                    ++i;
                }
                JavaType type = this.ps.getProperty().getType();
                Extension[] extensionArray = extensions = type != null ? (Extension[])typeToExtensions.get(type.getQualifiedName()) : null;
                if (extensions != null) {
                    int i2 = 0;
                    while (i2 < extensions.length) {
                        Extension ext = extensions[i2];
                        if (ext instanceof CmtExtension) {
                            ((CmtExtension)ext).setPropertyState(this.ps);
                        }
                        String[] tags = ext.getTags();
                        int j = 0;
                        while (j < tags.length) {
                            if (text.equals(tags[j])) {
                                ext.setSelectedTag(tags[j]);
                                if (ext.supportsCustomEditor() && !this.showCustomEditor(ext)) {
                                    this.lastTag = text;
                                    return;
                                }
                                this.value = ext.getValue();
                                this.lastTag = text;
                                this.firePropertyChange();
                                return;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                }
            }
        }
        throw new IllegalArgumentException(text);
    }

    public String[] getTags() {
        ArrayList<String> tagsArray = new ArrayList<String>();
        if (this.ps != null) {
            Extension[] extensions;
            String currentValue;
            CmtComponent component = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] subcomponents = component.getSubcomponents();
            JavaType type = this.ps.getProperty().getType();
            if (type != null) {
                int i = 0;
                while (i < subcomponents.length) {
                    JavaClass scClass;
                    if (this.ps.getSubcomponent() != subcomponents[i] && (scClass = subcomponents[i].getDeclaredClass()) != null && type.isAssignableFrom((JavaType)scClass)) {
                        tagsArray.add(subcomponents[i].getName());
                    }
                    ++i;
                }
            }
            if (!tagsArray.contains(currentValue = this.getAsText())) {
                tagsArray.add(currentValue);
            }
            if (type != null && (extensions = (Extension[])typeToExtensions.get(type.getQualifiedName())) != null) {
                int i = 0;
                while (i < extensions.length) {
                    Extension extension = extensions[i];
                    if (extension instanceof CmtExtension) {
                        ((CmtExtension)extension).setPropertyState(this.ps);
                    }
                    String[] tags = extension.getTags();
                    int j = 0;
                    while (j < tags.length) {
                        String tag = tags[j];
                        if (!tagsArray.contains(tag)) {
                            tagsArray.add(tag);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        String[] tags = new String[tagsArray.size()];
        tagsArray.toArray(tags);
        return tags;
    }

    public Component getCustomEditor() {
        Extension extension = this.getExtension();
        return extension != null ? extension.getCustomEditor() : null;
    }

    public boolean supportsCustomEditor() {
        Extension extension = this.getExtension();
        return extension != null ? extension.supportsCustomEditor() : false;
    }

    private boolean showCustomEditor(Extension ext) {
        InspectorManager mgr = InspectorManager.getInspectorManager();
        DockableView view = mgr.getLastView();
        JEWTDialog editorDialog = new JEWTDialog(WindowUtils.parentFrame((Component)view.getGUI()), this.ps.getProperty().getName(), 7);
        Component panel = ext.getCustomEditor();
        boolean isVetoable = panel instanceof VetoableChangeListener;
        SwingUtilities.updateComponentTreeUI(panel);
        editorDialog.setContent(panel);
        if (isVetoable) {
            editorDialog.addVetoableChangeListener((VetoableChangeListener)((Object)panel));
        }
        WindowUtils.centerWindow((Window)editorDialog, (Component)view.getGUI());
        boolean isOK = editorDialog.runDialog();
        if (isVetoable) {
            editorDialog.removeVetoableChangeListener((VetoableChangeListener)((Object)panel));
        }
        editorDialog.dispose();
        return isOK;
    }

    private Extension getExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.value != null && this.ps != null) {
            Extension[] extensions;
            CmtComponent component = this.ps.getSubcomponent().getOuterComponent();
            CmtSubcomponent[] subcomponents = component.getSubcomponents();
            int i = 0;
            while (i < subcomponents.length) {
                if (subcomponents[i].getLiveInstance() == this.value) {
                    return null;
                }
                ++i;
            }
            Class<?> cls = this.value.getClass();
            JavaType type = this.ps.getProperty().getType();
            Extension[] extensionArray = extensions = type != null ? (Extension[])typeToExtensions.get(type.getQualifiedName()) : null;
            if (extensions != null) {
                int i2 = 0;
                while (i2 < extensions.length) {
                    Extension ext = extensions[i2];
                    Class[] classes = ext.getImplementationClasses();
                    int j = 0;
                    while (j < classes.length) {
                        if (cls == classes[j]) {
                            this.extension = ext;
                            if (this.extension instanceof CmtExtension) {
                                ((CmtExtension)this.extension).setPropertyState(this.ps);
                            }
                            this.extension.setValue(this.value);
                            this.extension.addPropertyChangeListener((PropertyChangeListener)this);
                            return this.extension;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        return null;
    }

    private void firePropertyChange() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "SubcomponentChoiceEditor???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.value = this.getExtension().getValue();
        this.firePropertyChange();
    }

    public SubcomponentChoiceEditor() {
        this.$init$();
    }
}

