/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.java.explorer.ImportElement;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.MethodElement;
import oracle.jdevimpl.java.explorer.PackageElement;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public class ElementAt {
    public static final int TYPE_JAVA_CLASS = 1;
    public static final int TYPE_JAVA_CTOR = 2;
    public static final int TYPE_JAVA_METHOD = 3;
    public static final int TYPE_JAVA_FIELD = 4;
    public static final int TYPE_JAVA_VARIABLE = 5;
    public static final int TYPE_JAVA_PACKAGE = 6;
    public static final int TYPE_JAVA_ENUM_CONSTANT = 7;
    private int _elementType;
    private SourceElement _sourceElement;
    private JavaElement _javaElement;
    private SourceElement _sourceContext;
    private static ElementAt _cachedElementAt;
    private static URL _cachedElementAtUrl;
    private static int _cachedElementAtCaretPos;
    private static boolean _cacheEnabled;

    protected ElementAt(int elementType, SourceElement sourceElement) {
        this._elementType = elementType;
        this._sourceElement = sourceElement;
    }

    protected ElementAt(JavaElement javaElement, int elementType) {
        this._elementType = elementType;
        this._javaElement = javaElement;
    }

    protected ElementAt(JavaClass javaClass) {
        this((JavaElement)javaClass, 1);
    }

    protected ElementAt(JavaMethod javaMethod) {
        this((JavaElement)javaMethod, javaMethod.isConstructor() ? 2 : 3);
    }

    protected ElementAt(JavaField javaField) {
        this((JavaElement)javaField, 4);
    }

    protected ElementAt(SourceVariable variable) {
        this(5, (SourceElement)variable);
    }

    protected ElementAt(JavaPackage javaPackage) {
        this._javaElement = javaPackage;
        this._elementType = 6;
    }

    public static void beginCache() {
        ElementAt.clearCache();
        _cacheEnabled = true;
    }

    public static void endCache() {
        _cacheEnabled = false;
        ElementAt.clearCache();
    }

    private static void clearCache() {
        _cachedElementAt = null;
        _cachedElementAtUrl = null;
    }

    public int getElementType() {
        return this._elementType;
    }

    public SourceElement getSourceElement() {
        SourceElement ret = this._sourceElement != null ? this._sourceElement : this._javaElement.getSourceElement();
        return ret;
    }

    public JavaElement getJavaElement() {
        return this._javaElement;
    }

    public JavaPackage getJavaPackage() {
        return (JavaPackage)this._javaElement;
    }

    private void setSourceContext(SourceElement sourceContext) {
        this._sourceContext = sourceContext;
    }

    public SourceElement getSourceContext() {
        return this._sourceContext;
    }

    public static ElementAt findElementAt(Context context) {
        ElementAt ret = null;
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            ret = ElementAt.findElementAt(context, codeEditor);
        } else if (view instanceof UIEditor) {
            ret = ElementAt.findElementAt(((UIEditor)view).getActiveCanvas());
        } else if (view instanceof NavigatorWindow) {
            ret = ElementAt.findElementAt(context, project);
        } else if (view instanceof ExplorerWindow) {
            ExplorerWindow explorerWindow = (ExplorerWindow)view;
            ret = ElementAt.findElementAt(explorerWindow, project);
        } else {
            Node node = context.getNode();
            if (node instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)node;
                ret = ElementAt.findElementAt(javaSourceNode, context.getProject());
            }
        }
        return ret;
    }

    public static ElementAt findElementAt(Context context, CodeEditor codeEditor) {
        Project project = context.getProject();
        ElementAt ret = null;
        int caretPosition = codeEditor.getCaretPosition();
        Node node = context.getNode();
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            ret = ElementAt.findElementAt(textNode, project, caretPosition);
        }
        return ret;
    }

    public static ElementAt findElementAt(UIEditorCanvas canvas) {
        Element[] selection;
        ElementAt ret = null;
        Element[] elementArray = selection = canvas != null ? canvas.getSelection() : null;
        if (selection != null && selection.length == 1) {
            SourceVariable var;
            CmtModelNode node = (CmtModelNode)selection[0];
            CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
            SourceVariable sourceVariable = var = sub != null ? sub.getVariable() : null;
            if (var instanceof JavaField) {
                ret = sub.getName().equals("this") ? new ElementAt(sub.getOuterComponent().getType()) : new ElementAt((JavaField)var);
            } else if (var != null) {
                ret = new ElementAt(var);
            }
        }
        return ret;
    }

    private static ElementAt findElementAt(Context context, Project project) {
        ElementAt ret = null;
        Element[] selection = context.getSelection();
        if (selection.length == 1) {
            Element element = selection[0];
            if (element instanceof RelativeDirectoryContextFolder) {
                RelativeDirectoryContextFolder contextFolder = (RelativeDirectoryContextFolder)element;
                String relativePath = contextFolder.getRelativePath();
                if (ModelUtil.hasLength((String)relativePath)) {
                    JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                    JavaPackage javaPackage = javaManager.getPackage(relativePath.replace('/', '.'));
                    ret = new ElementAt(javaPackage);
                }
            } else if (element instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)element;
                ret = ElementAt.findElementAt(javaSourceNode, project);
            }
        }
        return ret;
    }

    private static ElementAt findElementAt(JavaSourceNode javaSourceNode, Project project) {
        SourceClass sourceClass;
        ElementAt ret = null;
        URL url = javaSourceNode.getURL();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceFile sourceFile = javaManager.getSourceFile(url);
        if (sourceFile != null && (sourceClass = sourceFile.getSourcePrimaryClass()) != null) {
            ret = new ElementAt((JavaClass)sourceClass);
        }
        return ret;
    }

    private static ElementAt findElementAt(ExplorerWindow explorerWindow, Project project) {
        Explorer explorer;
        ElementAt ret = null;
        Explorer explorer2 = explorer = explorerWindow != null ? explorerWindow.getExplorer() : null;
        if (explorer instanceof JavaExplorer) {
            Context context;
            Node node;
            CodeElement codeElement = ElementAt.getCodeElement(explorerWindow);
            if (codeElement != null && (node = (context = explorerWindow.getContext()).getNode()) instanceof JavaSourceNode) {
                JavaSourceNode javaSourceNode = (JavaSourceNode)node;
                int startOffset = codeElement.getStartOffset();
                ret = ElementAt.findElementAt((TextNode)javaSourceNode, project, startOffset);
            }
        } else if (explorer instanceof UIEditorCanvas) {
            UIEditorCanvas uiEditorCanvas = (UIEditorCanvas)explorer;
            ret = ElementAt.findElementAt(uiEditorCanvas);
        }
        return ret;
    }

    public static CodeElement getCodeElement(ExplorerWindow explorerWindow) {
        CodeElement codeElement = null;
        Context context = explorerWindow.getContext();
        Element element = context.getElement();
        if (element instanceof ClassElement || element instanceof MethodElement || element instanceof FieldElement || element instanceof PackageElement || element instanceof ImportElement) {
            codeElement = (CodeElement)element;
        }
        return codeElement;
    }

    public static ElementAt findElementAt(TextNode textNode, Project project, int position) {
        ElementAt ret = null;
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        URL nodeURL = textNode.getURL();
        if (nodeURL == null) {
            return null;
        }
        SourceFile sourceFile = javaManager.getSourceFile(nodeURL);
        if (sourceFile != null) {
            if (_cachedElementAtUrl == nodeURL && _cachedElementAtCaretPos == position) {
                ret = _cachedElementAt;
            } else {
                ret = ElementAt.findElementInSourceElement(project, (SourceElement)sourceFile, position);
                if (_cacheEnabled) {
                    _cachedElementAt = ret;
                    _cachedElementAtCaretPos = position;
                    _cachedElementAtUrl = nodeURL;
                }
            }
        }
        return ret;
    }

    private static ElementAt findElementInSourceElement(Project project, SourceElement sourceElement, int position) {
        ElementAt ret = null;
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 21: {
                SourcePackage sourcePackage = (SourcePackage)sourceElement;
                String packageName = sourcePackage.getName();
                SourceFile owningFile = sourcePackage.getOwningSourceFile();
                JavaProvider provider = owningFile.getProvider();
                JavaPackage javaPackage = provider.getPackage(packageName);
                ret = new ElementAt(javaPackage);
                break;
            }
            case 14: {
                String importedName;
                SourceImport sourceImport = (SourceImport)sourceElement;
                if (sourceImport.isStatic() || !Patch.contains((SourceElement)sourceImport.getNameElement(), position) || (importedName = sourceImport.getName()).endsWith("*")) break;
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                JavaClass javaType = javaManager.getClass(importedName);
                ret = ElementAt.findElementAt((JavaType)javaType);
                break;
            }
            case 27: {
                SourceTypeReference sourceType = (SourceTypeReference)sourceElement;
                JavaType resolvedType = sourceType.getResolvedType();
                if (resolvedType != null) {
                    ret = ElementAt.findElementAt(resolvedType);
                    break;
                }
                ret = null;
                break;
            }
            case 57: {
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                ret = ElementAt.findElementInExpression((SourceExpression)sourceSimpleNameExpression);
                break;
            }
            case 49: {
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                SourceExpression lhsOperand = sourceDotExpression.getLhsOperand();
                if (Patch.contains((SourceElement)lhsOperand, position)) {
                    ret = ElementAt.findElementInSourceElement(project, (SourceElement)lhsOperand, position);
                    break;
                }
                ret = ElementAt.findElementInExpression((SourceExpression)sourceDotExpression);
                break;
            }
            case 53: {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                SourceName nameElement = sourceMethodCallExpression.getNameElement();
                if (Patch.contains((SourceElement)nameElement, position)) {
                    JavaMethod javaMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (javaMethod != null) {
                        ret = new ElementAt(javaMethod);
                        ret.setSourceContext((SourceElement)sourceMethodCallExpression);
                        break;
                    }
                    ret = null;
                    break;
                }
                ret = ElementAt.findElementInChildren(project, sourceElement, position);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                SourceName nameElement = sourceHasName.getNameElement();
                if (nameElement != null && Patch.contains((SourceElement)nameElement, position)) {
                    ret = ElementAt.findElementOfResolvedElement((SourceElement)sourceHasName);
                    break;
                }
                ret = ElementAt.findElementInChildren(project, sourceElement, position);
                break;
            }
            case 55: {
                SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)sourceElement;
                SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
                if (Patch.contains((SourceElement)sourceType, position)) {
                    JavaMethod resolvedMethod = sourceClassCreatorExpression.getResolvedMethod();
                    if (resolvedMethod == null) break;
                    ret = new ElementAt(resolvedMethod);
                    break;
                }
                ret = ElementAt.findElementInChildren(project, (SourceElement)sourceClassCreatorExpression, position);
                break;
            }
            case 7: {
                SourceEnumConstant sourceEnumConstant = (SourceEnumConstant)sourceElement;
                ret = new ElementAt((JavaElement)sourceEnumConstant, 7);
                break;
            }
            default: {
                ret = ElementAt.findElementInChildren(project, sourceElement, position);
                break;
            }
        }
        return ret;
    }

    private static ElementAt findElementInExpression(SourceExpression sourceExpression) {
        SourceElement sourceElement;
        ElementAt ret = null;
        JavaHasType resolvedHasType = sourceExpression.getResolvedObject();
        if (resolvedHasType != null && (sourceElement = resolvedHasType.getSourceElement()) != null && (ret = ElementAt.findElementOfResolvedElement(sourceElement)) != null) {
            ret.setSourceContext((SourceElement)sourceExpression);
        }
        return ret;
    }

    private static ElementAt findElementOfResolvedElement(SourceElement sourceElement) {
        ElementAt ret = null;
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 3: {
                SourceClass sourceClass = (SourceClass)sourceElement;
                ret = new ElementAt((JavaClass)sourceClass);
                break;
            }
            case 6: 
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                ret = new ElementAt((JavaMethod)sourceMethod);
                break;
            }
            case 10: {
                JavaField javaField = (JavaField)sourceElement;
                ret = new ElementAt(javaField);
                break;
            }
            case 13: 
            case 17: {
                SourceVariable sourceVariable = (SourceVariable)sourceElement;
                ret = new ElementAt(sourceVariable);
                break;
            }
            case 7: {
                SourceEnumConstant sourceEnumConstant = (SourceEnumConstant)sourceElement;
                ret = new ElementAt((JavaElement)sourceEnumConstant, 7);
                break;
            }
        }
        return ret;
    }

    private static ElementAt findElementInChildren(Project project, SourceElement sourceElement, int position) {
        ElementAt ret = null;
        SourceElement[] containedElements = sourceElement.getContainedElements();
        int i = 0;
        while (ret == null && i < containedElements.length) {
            SourceElement containedElement = containedElements[i];
            if (Patch.contains(containedElement, position)) {
                ret = ElementAt.findElementInSourceElement(project, containedElement, position);
            }
            ++i;
        }
        return ret;
    }

    private static ElementAt findElementAt(JavaType type) {
        ElementAt ret = null;
        if (type != null) {
            JavaClass closestClass;
            if (type.isArray()) {
                type = type.getBaseComponentType();
            }
            if ((closestClass = type.getTypeErasure()) != null) {
                ret = new ElementAt(closestClass);
            }
        }
        return ret;
    }

    public static SourceClass getSourceClassAt(Context context, boolean atCaret, boolean allowAnonymous) {
        Object ret = null;
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            int caretPosition = codeEditor.getCaretPosition();
            Node node = context.getNode();
            if (node instanceof TextNode) {
                SourceClass sourceClass;
                int elementType;
                ElementAt elementAt;
                TextNode textNode = (TextNode)node;
                if (atCaret && (elementAt = ElementAt.findElementAt(textNode, project, caretPosition)) != null && (elementType = elementAt.getElementType()) == 1 && (sourceClass = (SourceClass)elementAt.getSourceElement()) != null && Util.isClassInSources(workspace, project, sourceClass)) {
                    ret = sourceClass;
                }
                if (ret == null) {
                    ret = ElementAt.getSourceClassAt(workspace, project, textNode, caretPosition);
                }
                if (!allowAnonymous && ret != null) {
                    while (ret != null && ret.getName() == null) {
                        SourceClass enclosingClass = ret.getEnclosingClass();
                        ret = Util.isClassInSources(workspace, project, enclosingClass) ? enclosingClass : null;
                    }
                }
            }
        } else if (view instanceof UIEditor) {
            CmtComponentSource src;
            UIEditor uiEditor = (UIEditor)view;
            CmtComponentSource cmtComponentSource = src = uiEditor != null ? uiEditor.getComponentSource() : null;
            if (src != null) {
                ret = (SourceClass)src.getType().getSourceElement();
            }
        } else if (view instanceof NavigatorWindow) {
            ret = ElementAt.getSourceClassAt(context, workspace, project);
        } else if (view instanceof ExplorerWindow) {
            ExplorerWindow explorerWindow = (ExplorerWindow)view;
            ret = ElementAt.getSourceClassAt(explorerWindow);
        }
        return ret;
    }

    private static SourceClass getSourceClassAt(Context context, Workspace workspace, Project project) {
        Element element;
        SourceClass ret = null;
        Element[] selection = context.getSelection();
        if (selection.length == 1 && (element = selection[0]) instanceof JavaSourceNode) {
            SourceClass sourceClass;
            JavaSourceNode javaSourceNode = (JavaSourceNode)element;
            URL url = javaSourceNode.getURL();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            SourceFile sourceFile = javaManager.getSourceFile(url);
            if (sourceFile != null && Util.isClassInSources(workspace, project, sourceClass = Patch.getMainClass(sourceFile))) {
                ret = sourceClass;
            }
        }
        return ret;
    }

    private static SourceClass getSourceClassAt(Workspace workspace, Project project, TextNode textNode, int caretPosition) {
        URL nodeURL;
        SourceClass ret = null;
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceFile sourceFile = javaManager.getSourceFile(nodeURL = textNode.getURL());
        if (sourceFile != null) {
            SourceElement sourceElement = sourceFile.getElementAt(caretPosition);
            while (sourceElement != null && ret == null) {
                SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, sourceElement);
                if (sourceClass == null) break;
                if (Util.isClassInSources(workspace, project, sourceClass)) {
                    ret = sourceClass;
                }
                sourceElement = sourceClass.getParent();
            }
        }
        return ret;
    }

    private static SourceClass getSourceClassAt(ExplorerWindow explorerWindow) {
        UIEditorCanvas canvas;
        Element[] selection;
        Explorer explorer;
        SourceClass ret = null;
        if (explorerWindow != null && (explorer = explorerWindow.getExplorer()) instanceof UIEditorCanvas && (selection = (canvas = (UIEditorCanvas)explorer).getSelection()) != null && selection.length > 0) {
            CmtComponent comp;
            CmtModelNode node = (CmtModelNode)selection[0];
            CmtSubcomponent sub = node != null ? node.getSubcomponent() : null;
            CmtComponent cmtComponent = comp = sub != null ? sub.getOuterComponent() : null;
            if (comp != null) {
                ret = (SourceClass)comp.getType().getSourceElement();
            }
        }
        return ret;
    }
}

