/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.refactoring.RefactorManager;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.WeightedList;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.dialogs.SafeDeleteFailedDialog;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.events.RefactoringListener;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.RefactorAddin;
import oracle.jdevimpl.refactoring.dialogs.AskSafeRenameDlg;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.duplicate.DuplicateClassController;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceController;
import oracle.jdevimpl.refactoring.oprs.extractinterface.ExtractInterfaceURLHandler;
import oracle.jdevimpl.refactoring.oprs.makestatic.MakeStaticController;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigController;
import oracle.jdevimpl.refactoring.oprs.metsig.MetSigUrlHandler;
import oracle.jdevimpl.refactoring.oprs.move.MoveClassesOperation;
import oracle.jdevimpl.refactoring.oprs.move.MoveController;
import oracle.jdevimpl.refactoring.oprs.moveclasses.MoveClassesURLHandler;
import oracle.jdevimpl.refactoring.oprs.movemember.extractsuperclass.ExtractSuperclassController;
import oracle.jdevimpl.refactoring.oprs.movemember.pullup.PullUpController;
import oracle.jdevimpl.refactoring.oprs.movemember.pushdown.PushDownController;
import oracle.jdevimpl.refactoring.oprs.rename.RenameController;
import oracle.jdevimpl.refactoring.oprs.rename.RenameFileDialog;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameFieldURLHandler;
import oracle.jdevimpl.refactoring.oprs.rename.member.RenameMethodURLHandler;
import oracle.jdevimpl.refactoring.oprs.rename.variable.FindRenameVariableURLHandler;
import oracle.jdevimpl.refactoring.oprs.safedelete.IdeSafeDeleteCommand;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteClassHandler;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteController;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteFieldHandler;
import oracle.jdevimpl.refactoring.oprs.safedelete.SafeDeleteMethodHandler;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeController;
import oracle.jdevimpl.refactoring.oprs.usersupertype.UseSupertypeURLHandler;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;
import oracle.jdevimpl.refactoring.search.FindClassURLHandler;
import oracle.jdevimpl.refactoring.search.FindConstructorURLHandler;
import oracle.jdevimpl.refactoring.search.UsageController;

public class RefManagerImpl
extends RefactoringManager {
    private WeightedList _weightedUrlHandlers;
    private ArrayList _refListeners;
    private static final String FIELD_PREFIX = "_";

    private void $init$() {
        this._weightedUrlHandlers = new WeightedList();
        this._refListeners = new ArrayList();
    }

    static RefManagerImpl createInstance() {
        RefactorManager.INSTANCE = new RefManagerImpl();
        return (RefManagerImpl)RefactorManager.INSTANCE;
    }

    private RefManagerImpl() {
        this.$init$();
        this.registerUrlHandler(new FindClassURLHandler(), 0.5);
        this.registerUrlHandler(new FindConstructorURLHandler(), 0.5);
        this.registerUrlHandler(new FindRenameVariableURLHandler(), 0.5);
        this.registerUrlHandler(new RenameMethodURLHandler(), 0.5);
        this.registerUrlHandler(new RenameFieldURLHandler(), 0.5);
        this.registerUrlHandler(new SafeDeleteClassHandler(), 0.5);
        this.registerUrlHandler(new SafeDeleteMethodHandler(), 0.5);
        this.registerUrlHandler(new SafeDeleteFieldHandler(), 0.5);
        this.registerUrlHandler(new UseSupertypeURLHandler(), 0.5);
        this.registerUrlHandler(new MoveClassesURLHandler(), 0.5);
        this.registerUrlHandler(new ExtractInterfaceURLHandler(), 0.5);
        this.registerUrlHandler(new MetSigUrlHandler(), 0.5);
        this.registerUrlHandler(new TextURLHandler(), 1.0);
        IdeActionsController controller = new IdeActionsController(null);
        IdeActions.getFileRenameAction().addController((Controller)controller);
    }

    public void registerUrlHandler(URLHandler handler, double weight) {
        if (handler != null) {
            this._weightedUrlHandlers.add((Object)handler, weight);
        }
    }

    public void unregisterUrlHandler(URLHandler handler) {
        this._weightedUrlHandlers.remove((Object)handler);
    }

    public Iterator getRegisteredUrlHandlers() {
        return this._weightedUrlHandlers.iterator();
    }

    public void addRefactoringListener(RefactoringListener listener) {
        this._refListeners.add(listener);
    }

    public void removeRefactoringListener(RefactoringListener listener) {
        this._refListeners.remove(listener);
    }

    public void fireRefEvent(RefactoringEvent event) {
        RefactoringListener[] refListeners;
        int eventID = event.getId();
        RefactoringListener[] refactoringListenerArray = refListeners = this._refListeners.toArray(new RefactoringListener[this._refListeners.size()]);
        int n = 0;
        while (n < refactoringListenerArray.length) {
            RefactoringListener refListener = refactoringListenerArray[n];
            try {
                switch (eventID) {
                    case 1: {
                        refListener.beforeRefactor(event);
                        break;
                    }
                    case 2: {
                        refListener.nodesPopulated(event);
                        break;
                    }
                    case 3: {
                        refListener.usagesPopulated(event);
                        break;
                    }
                    case 4: {
                        refListener.beforeDo(event);
                        break;
                    }
                    case 5: {
                        refListener.afterDo(event);
                        break;
                    }
                    case 6: {
                        refListener.beforeUndo(event);
                        break;
                    }
                    case 7: {
                        refListener.afterUndo(event);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            ++n;
        }
    }

    public void addRefactoringController(int commandId, Controller controller, double weight) {
        RefactorAddin.getInstance().addRefactoringController(commandId, controller, weight);
    }

    public void addRefactoringController(int commandId, Controller controller) {
        RefactorAddin.getInstance().addRefactoringController(commandId, controller);
    }

    public void removeRefactoringController(int commandId, Controller controller) {
        RefactorAddin.getInstance().removeRefactoringController(commandId, controller);
    }

    public boolean canMoveClasses(Context context, SourceClass[] sourceClasses) {
        return MoveController.canMoveClasses(context, sourceClasses);
    }

    public void initiateMoveClasses(Context context, SourceClass[] sourceClasses) {
        MoveController.whenMoveClasses(context, sourceClasses);
    }

    public boolean moveClasses(Context context, MoveClassesCriteria moveClassesCriteria, boolean preview) {
        MoveClassesOperation searchOperation = new MoveClassesOperation(context, moveClassesCriteria);
        URL[] urls = moveClassesCriteria.getOldUrls();
        String[] clsNames = moveClassesCriteria.getFqOldClassesNames();
        JavaManager manager = JavaManager.getJavaManager((Project)context.getProject());
        int i = 0;
        while (i < clsNames.length) {
            if (manager.getSourceClass(clsNames[i]) == null) {
                int j = 0;
                while (j < urls.length) {
                    Node node = NodeFactory.find((URL)urls[j]);
                    if (node instanceof JavaSourceNode) {
                        moveClassesCriteria.hintMisplacedFile(manager.getSourceFile(urls[j]));
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return ((SearchOperationImpl)searchOperation).runRefactoring(preview);
    }

    public void initiateRenameFile(Context context, URL url, boolean preview) {
        RenameController.whenRenameUrl(context, url, preview);
    }

    public void initiateRenameClass(Context context, SourceClass sourceClass) {
        RenameController.whenRenameClass(context, sourceClass);
    }

    public boolean renameClasses(Context context, Map classMap) {
        boolean ret = true;
        MoveClassesCriteria criteria = new MoveClassesCriteria(false, false, null, null);
        JavaManager javaManager = JavaManager.getJavaManager((Project)context.getProject());
        Iterator keysIterator = classMap.keySet().iterator();
        while (ret && keysIterator.hasNext()) {
            String fqOldClassName = (String)keysIterator.next();
            SourceClass sourceClass = javaManager.getSourceClass(fqOldClassName);
            if (sourceClass != null) {
                String oldPackageName = sourceClass.getPackageName();
                String fqNewClassName = (String)classMap.get(fqOldClassName);
                JavaClass owningClass = sourceClass.getOwningClass();
                if (owningClass == null) {
                    String className = sourceClass.getName();
                    int dotPos = fqNewClassName.lastIndexOf(46);
                    String newPackageName = dotPos == -1 ? "" : fqNewClassName.substring(0, dotPos);
                    String newClassName = fqNewClassName.substring(dotPos + 1);
                    criteria.addClassMove(javaManager, oldPackageName, className, newPackageName, newClassName);
                    continue;
                }
                String qualifiedOwningClassName = owningClass.getQualifiedName();
                if (fqNewClassName.startsWith(qualifiedOwningClassName)) {
                    String oldSuffix = fqOldClassName.substring(qualifiedOwningClassName.length() + 1);
                    String newSuffix = fqNewClassName.substring(qualifiedOwningClassName.length() + 1);
                    if (newSuffix.indexOf(46) == -1) {
                        String prefix = owningClass.getName();
                        criteria.addClassMove(javaManager, oldPackageName, prefix + '.' + oldSuffix, oldPackageName, prefix + '.' + newSuffix);
                        continue;
                    }
                    ret = false;
                    continue;
                }
                ret = false;
                continue;
            }
            ret = false;
        }
        if (ret) {
            ret = this.moveClasses(context, criteria, false);
        }
        return ret;
    }

    public boolean canRenamePackage(Context context, JavaPackage javaPackage) {
        return RenameController.canRenamePackage();
    }

    public void initiateRenamePackage(Context context, JavaPackage javaPackage) {
        RenameController.whenRenamePackage(context, javaPackage);
    }

    public boolean canRenameMethod(Context context, SourceMethod sourceMethod) {
        return RenameController.canRenameMethod(context, sourceMethod);
    }

    public void initiateRenameMethod(Context context, SourceMethod sourceMethod) {
        RenameController.whenRenameMethod(context, sourceMethod);
    }

    public boolean renameMethod(Context context, String fqClassName, String methodName, String newMethodName, String[] fqParamTypes) {
        boolean ret = false;
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceClass sourceClass = javaManager.getSourceClass(fqClassName);
        if (sourceClass != null) {
            JavaMethod javaMethod;
            boolean failedParam = false;
            JavaType[] parameters = new JavaType[fqParamTypes.length];
            int i = 0;
            while (i < fqParamTypes.length) {
                String fqParamType = fqParamTypes[i];
                parameters[i] = javaManager.getClass(fqParamType);
                if (parameters[i] == null) {
                    failedParam = true;
                }
                ++i;
            }
            if (!failedParam && (javaMethod = sourceClass.getMethod(methodName, parameters)) != null) {
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                MethodDescription methodDescription = new MethodDescription((JavaMethod)sourceMethod);
                RenameMethodCriteria criteria = new RenameMethodCriteria(methodDescription, newMethodName, false, false);
                SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
                ret = searchOperation.runRefactoring(false);
            }
        }
        return ret;
    }

    public boolean canRenameField(Context context, SourceFieldVariable sourceFieldVariable) {
        return RenameController.canRenameField(context, sourceFieldVariable);
    }

    public void initiateRenameField(Context context, SourceFieldVariable sourceFieldVariable) {
        RenameController.whenRenameField(context, (SourceMemberVariable)sourceFieldVariable);
    }

    public boolean renameField(Context context, String fqClassName, String fqFieldType, String fieldName, String newFieldName) {
        return this.renameField(context, fqClassName, fqFieldType, fieldName, newFieldName, false, false, false, false);
    }

    public boolean renameField(Context context, String fqClassName, String fqFieldType, String fieldName, String newFieldName, boolean searchInComments, boolean searchNonJavaFiles, boolean renameAccessors, boolean preview) {
        JavaField javaField;
        SourceFieldVariable sourceFieldVariable;
        boolean ret = false;
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceClass sourceClass = javaManager.getSourceClass(fqClassName);
        if (sourceClass != null && (sourceFieldVariable = (SourceFieldVariable)(javaField = sourceClass.getField(fieldName)).getSourceElement()) != null) {
            ret = RenameController.renameField(context, (SourceMemberVariable)sourceFieldVariable, newFieldName, searchInComments, searchNonJavaFiles, renameAccessors, preview);
        }
        return ret;
    }

    public boolean canSafeDelete(Context context, URL[] urls) {
        RefactorAddin refactorAddin = RefactorAddin.getInstance();
        IdeAction action = IdeAction.find((int)RefactoringManager.SAFE_DELETE_CMD_ID);
        List<Controller> controllers = refactorAddin.getControllersByIdeAction(action);
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            boolean canDelete = false;
            int j = 0;
            while (j < controllers.size()) {
                Controller controller = controllers.get(j);
                if (controller instanceof IdeSafeDeleteCommand && ((IdeSafeDeleteCommand)controller).canSafeDelete(context, url)) {
                    canDelete = true;
                    break;
                }
                ++j;
            }
            if (!canDelete) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean safeDeleteFiles(Context context, URL[] urls) {
        ArrayList<URL> javaURLs = new ArrayList<URL>();
        ArrayList<URL> otherURLs = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            if (Util.isJavaSource(url)) {
                javaURLs.add(url);
            } else {
                otherURLs.add(url);
            }
            ++i;
        }
        boolean ret = true;
        if (javaURLs.size() > 0) {
            ret = SafeDeleteController.safeDeleteFiles(context, javaURLs.toArray(new URL[javaURLs.size()]));
        }
        if (otherURLs.size() == 0) {
            return ret;
        }
        ret = true;
        RefactorAddin refactorAddin = RefactorAddin.getInstance();
        IdeAction action = IdeAction.find((int)RefactoringManager.SAFE_DELETE_CMD_ID);
        List<Controller> controllers = refactorAddin.getControllersByIdeAction(action);
        for (URL url : otherURLs) {
            for (Controller controller : controllers) {
                if (!(controller instanceof IdeSafeDeleteCommand) || ((IdeSafeDeleteCommand)controller).safeDeleteFile(context, url)) continue;
                ret = false;
            }
        }
        return ret;
    }

    public boolean safeDeleteClasses(Context context, SourceClass[] sourceClasses) {
        return SafeDeleteController.safeDeleteClasses(context, sourceClasses);
    }

    public boolean safeDeleteMethod(Context context, SourceMethod sourceMethod) {
        return SafeDeleteController.whenSafeDeleteMethod(context, sourceMethod);
    }

    public boolean safeDeleteField(Context context, SourceFieldVariable sourceFieldVariable) {
        return SafeDeleteController.whenSafeDeleteField(context, (SourceMemberVariable)sourceFieldVariable);
    }

    public static RefManagerImpl getImplInstance() {
        return (RefManagerImpl)RefManagerImpl.getRefactoringManager();
    }

    public boolean canMoveMember(Context context, SourceMember sourceMember) {
        return MoveController.canMoveStaticMember(context, sourceMember);
    }

    public void initiateMoveMember(Context context, SourceMember sourceMember) {
        MoveController.whenMoveStaticMembers(context, sourceMember);
    }

    public boolean canFindClassUsages(Context context, JavaClass javaClass) {
        return true;
    }

    public void initiateFindClassUsages(Context context, JavaClass javaClass) {
        UsageController.whenFindClassUsages(context, javaClass);
    }

    public boolean canFindMethodUsages(JavaMethod javaMethod) {
        return true;
    }

    public void initiateFindMethodUsages(Context context, JavaMethod javaMethod) {
        UsageController.whenFindMethodUsages(context, javaMethod);
    }

    public boolean canExtractInterface(Context context, SourceClass sourceClass) {
        return ExtractInterfaceController.canExtract(context, sourceClass);
    }

    public void initiateExtractInterface(Context context, SourceClass sourceClass) {
        ExtractInterfaceController.whenExtract(context, sourceClass);
    }

    public boolean extractInterface(Context context, SourceClass sourceClass, String pkgName, String interfaceName, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields) {
        return ExtractInterfaceController.extractInterface(context, sourceClass, pkgName, interfaceName, selectedInterfaces, selectedMethods, selectedFields);
    }

    public boolean canExtractSuperclass(Context context, SourceClass sourceClass) {
        return ExtractSuperclassController.canExtract(context, sourceClass);
    }

    public void initiateExtractSuperclass(Context context, SourceClass sourceClass) {
        ExtractSuperclassController.whenExtract(context, sourceClass);
    }

    public boolean canChangeMethod(Context context, SourceMethod sourceMethod) {
        return MetSigController.canHandle(context, sourceMethod);
    }

    public void initiateChangeMethod(Context context, SourceMethod sourceMethod) {
        MetSigController.whenHandle(context, sourceMethod);
    }

    public boolean changeMethod(Context context, ChangeMethodCriteria criteria) {
        return MetSigController.changeMethod(context, criteria);
    }

    public boolean canUseSupertype(Context context, SourceClass sourceClass) {
        return UseSupertypeController.canUseSupertype(context, sourceClass);
    }

    public void initiateUseSupertype(Context context, SourceClass sourceClass) {
        UseSupertypeController.whenUseSupertype(context, sourceClass);
    }

    public boolean canPullUp(SourceClass sourceClass) {
        return PullUpController.canPullUp(sourceClass);
    }

    public void initiatePullUp(Context context, SourceClass sourceClass, SourceMember preselectedMember) {
        PullUpController.whenPullUp(context, sourceClass, preselectedMember);
    }

    public boolean canPushDown(SourceClass sourceClass) {
        return PushDownController.canPushDown(sourceClass);
    }

    public void initiatePushDown(Context context, SourceClass sourceclass, SourceMember preselectedMember) {
        PushDownController.whenPushDown(context, sourceclass, preselectedMember);
    }

    public static String getDefaultFieldPrefix() {
        return FIELD_PREFIX;
    }

    private SourceClass getSourceClass(Context context, URL url) {
        JavaClass primaryClass;
        SourceFile sourceFile;
        JavaManager javaManager;
        SourceClass sourceClass = null;
        Project project = context.getProject();
        if (project != null && (javaManager = JavaManager.getJavaManager((Project)project)) != null && (sourceFile = javaManager.getSourceFile(url)) != null && (primaryClass = sourceFile.getPrimaryClass()) != null) {
            sourceClass = (SourceClass)primaryClass.getSourceElement();
        }
        return sourceClass;
    }

    public boolean doSafeRename(Context context, URL url, boolean preview) {
        SourceClass sourceClass = this.getSourceClass(context, url);
        if (sourceClass != null) {
            this.initiateRenameClass(context, sourceClass);
        } else {
            this.initiateRenameFile(context, url, preview);
        }
        return true;
    }

    public boolean canMakeStatic(Context context, SourceMethod sourceMethod) {
        return MakeStaticController.handle(context, (JavaMethod)sourceMethod, false);
    }

    public boolean initiateMakeStatic(Context context, SourceMethod sourceMethod) {
        return MakeStaticController.handle(context, (JavaMethod)sourceMethod, true);
    }

    public boolean canMakeStatic(Context context, SourceFieldVariable sourceFieldVariable) {
        return MakeStaticController.handle(context, (JavaField)sourceFieldVariable, false);
    }

    public boolean initiateMakeStatic(Context context, SourceFieldVariable sourceFieldVariable) {
        return MakeStaticController.handle(context, (JavaField)sourceFieldVariable, true);
    }

    public boolean canDuplicate(Context context, SourceClass sourceClass) {
        return DuplicateClassController.handle(context, sourceClass, false);
    }

    public boolean initiateDuplicate(Context context, SourceClass sourceClass) {
        return DuplicateClassController.whenDuplicateClass(context, sourceClass);
    }

    public void runRefactoring(Context context, SearchCriteria criteria, boolean preview) {
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        searchOperation.runRefactoring(preview);
    }

    public void runFindUsages(Context context, SearchCriteria criteria, boolean useNewTab) {
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        if (searchOperation.doSearch()) {
            UsagesLogPage.showUsages(searchOperation, useNewTab);
        }
    }

    public boolean runSafeDelete(Context context, SearchCriteria criteria, String helpTopic) {
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, criteria);
        SearchResults searchResults = searchOperation.search();
        if (searchResults != null) {
            UsageModel usageModel = searchResults.getUsageModel();
            ArrayList usageEntries = usageModel.getUsageEntries();
            if (usageEntries.isEmpty()) {
                return searchOperation.doRefactoring();
            }
            if (Ide.getIdeArgs().getCreateUI()) {
                String title = criteria.getLongTitle();
                SafeDeleteFailedDialog dialog = new SafeDeleteFailedDialog(title, helpTopic);
                if (WizardLauncher.runDialog((JDialog)((Object)dialog))) {
                    if (dialog.isIgnorePressed()) {
                        return searchOperation.doRefactoring();
                    }
                    UsagesLogPage.showUsages(searchOperation, false);
                    return false;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    static SourceClass mav$getSourceClass(RefManagerImpl refManagerImpl, Context context, URL uRL) {
        return refManagerImpl.getSourceClass(context, uRL);
    }

    private class IdeActionsController
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            int commandId = action.getCommandId();
            if (commandId != 14) {
                return false;
            }
            boolean canDo = this.whenRename(context, false);
            action.setEnabled(canDo);
            return true;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int commandId = action.getCommandId();
            if (commandId == 14) {
                boolean canDo = this.whenRename(context, true);
                return canDo;
            }
            return false;
        }

        private boolean whenRename(Context context, boolean doit) {
            Element selected;
            Element[] selection;
            boolean ret = false;
            if (context.getView() instanceof CodeEditor) {
                Node node = context.getNode();
                ret = node.getAttributes().isSet(ElementAttributes.RENAMEABLE) && this.whenRenameFile(context, node, doit);
            } else if (context.getView() instanceof NavigatorWindow && (selection = context.getSelection()) != null && selection.length == 1 && (selected = selection[0]).getAttributes().isSet(ElementAttributes.RENAMEABLE)) {
                if (selected instanceof JavaSourceNode) {
                    ret = true;
                    if (doit) {
                        JavaSourceNode javaSourceNode = (JavaSourceNode)selected;
                        ret = this.whenRenameJavaSource(context, javaSourceNode, doit);
                    }
                } else if (selected instanceof Node) {
                    Node node = (Node)selected;
                    ret = this.whenRenameFile(context, node, doit);
                } else if (selected instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder contextFolder = (RelativeDirectoryContextFolder)selected;
                    if (this.canContainJavaSources(contextFolder)) {
                        String relativePath = contextFolder.getRelativePath();
                        if (ModelUtil.hasLength((String)relativePath)) {
                            Project project = context.getProject();
                            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                            JavaPackage javaPackage = javaManager.getPackage(relativePath.replace('/', '.'));
                            ret = this.whenRenamePackage(context, javaPackage, doit);
                        }
                    } else {
                        ret = this.whenRenameDirectory(context, contextFolder, doit);
                    }
                }
            }
            return ret;
        }

        private boolean whenRenameDirectory(Context context, RelativeDirectoryContextFolder contextFolder, boolean doit) {
            boolean ret = false;
            URLPath rootDirectories = contextFolder.getRootDirectories();
            URL[] roots = rootDirectories.getEntries();
            if (roots.length == 1) {
                String relativePath;
                URL root;
                URL url;
                RenameFileDialog renameFileDialog;
                boolean answer;
                ret = true;
                if (doit && (answer = (renameFileDialog = new RenameFileDialog(context, url = URLFactory.newURL((URL)(root = roots[0]), (String)(relativePath = contextFolder.getRelativePath())))).run())) {
                    String newName = renameFileDialog.getNewName();
                    URL newUrl = URLFactory.newFileURL((String)newName);
                    boolean preview = renameFileDialog.isPreview();
                    RenameController.doRenameUrl(context, url, newUrl, preview);
                }
            }
            return ret;
        }

        private boolean whenRenamePackage(Context context, JavaPackage javaPackage, boolean doit) {
            boolean ret = false;
            if (RenameController.canRenamePackage()) {
                ret = true;
                if (doit) {
                    RenameController.whenRenamePackage(context, javaPackage);
                }
            }
            return ret;
        }

        private boolean whenRenameFile(Context context, Node node, boolean doit) {
            if (doit) {
                URL url = node.getURL();
                if (node instanceof Workspace) {
                    return false;
                }
                if (node instanceof Project) {
                    return false;
                }
                AskSafeRenameDlg dlg = new AskSafeRenameDlg(url);
                int answer = dlg.run();
                switch (answer) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        RenameFileDialog renameFileDialog = new RenameFileDialog(context, url);
                        boolean ret = renameFileDialog.run();
                        if (!ret) break;
                        boolean preview = renameFileDialog.isPreview();
                        String newName = renameFileDialog.getNewName();
                        URL newUrl = URLFactory.newFileURL((String)newName);
                        RenameController.doRenameUrl(context, url, newUrl, preview);
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            return true;
        }

        private boolean whenRenameJavaSource(Context context, JavaSourceNode javaSourceNode, boolean doit) {
            if (doit) {
                URL url = javaSourceNode.getURL();
                AskSafeRenameDlg dlg = new AskSafeRenameDlg(url);
                int answer = dlg.run();
                switch (answer) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        SourceClass sourceClass = RefManagerImpl.mav$getSourceClass(RefManagerImpl.this, context, url);
                        RefManagerImpl.this.initiateRenameClass(context, sourceClass);
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            return true;
        }

        private boolean canContainJavaSources(RelativeDirectoryContextFolder contextFolder) {
            ContentSetProvider[] providers;
            List contentSetKeys = contextFolder.getContentSetKeys();
            ContentSetProvider[] contentSetProviderArray = providers = ProjectContent.getContentSetProviders();
            int n = 0;
            while (n < contentSetProviderArray.length) {
                String contentSetKey;
                ContentSetProvider contentSetProvider = contentSetProviderArray[n];
                if (contentSetProvider.canContainJavaSources() && contentSetKeys.contains(contentSetKey = contentSetProvider.getKey())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private IdeActionsController() {
        }

        IdeActionsController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

