/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.RefManagerImpl;

public class TextChangeCommand
extends Command {
    private static final String COMMAND_ID = "THE_CMD_ID";
    private String _commandName;
    private RefactoringChange[] _changes;
    protected SearchOperation _searchOperation;

    private static int getCommandID() {
        int cmdID = Ide.findOrCreateCmdID((String)COMMAND_ID);
        return cmdID;
    }

    public TextChangeCommand(Context context, String commandName, List changes) {
        super(TextChangeCommand.getCommandID(), 3);
        this._searchOperation = null;
        Collections.sort(changes);
        RefactoringChange[] refactoringChanges = changes.toArray(new RefactoringChange[changes.size()]);
        this.init(context, commandName, refactoringChanges);
    }

    public TextChangeCommand(SearchOperation searchOperation, List changes) {
        super(TextChangeCommand.getCommandID(), 3);
        this._searchOperation = searchOperation;
        Collections.sort(changes);
        RefactoringChange[] refactoringChanges = changes.toArray(new RefactoringChange[changes.size()]);
        this.init(searchOperation.getContext(), searchOperation.getCriteria().getShortTitle(), refactoringChanges);
    }

    private void init(Context context, String commandName, RefactoringChange[] changes) {
        this.setCommandName(commandName);
        if (changes != null) {
            this.setChanges(changes);
        }
        this.setContext(context);
    }

    protected void setCommandName(String commandName) {
        this._commandName = commandName;
    }

    protected void setChanges(RefactoringChange[] changes) {
        Assert.check((changes != null ? 1 : 0) != 0);
        this._changes = changes;
    }

    public int doit() throws Exception {
        if (!this.areNodesWritable()) {
            return 1;
        }
        this.fireEvent(true, true);
        boolean allDone = true;
        HashSet<Node> affectedNodes = new HashSet<Node>();
        int i = this._changes.length - 1;
        while (allDone && i >= 0) {
            RefactoringChange change = this._changes[i];
            if (change.doit()) {
                Node node = change.getNode();
                if (node != null) {
                    affectedNodes.add(node);
                }
            } else {
                int j = i + 1;
                while (j < this._changes.length) {
                    RefactoringChange changeToUndo = this._changes[j];
                    changeToUndo.undo();
                    ++j;
                }
                allDone = false;
            }
            --i;
        }
        if (allDone) {
            this.notifyNodes(affectedNodes);
        }
        this.fireEvent(true, false);
        return allDone ? 0 : 1;
    }

    private void notifyNodes(HashSet affectedNodes) {
        UpdateMessage change = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, null);
        for (Node node : affectedNodes) {
            node.notifyObservers((Object)node, change);
        }
    }

    public int undo() throws Exception {
        if (!this.areNodesWritable()) {
            return 1;
        }
        this.fireEvent(false, true);
        boolean allDone = true;
        HashSet<Node> affectedNodes = new HashSet<Node>();
        int i = 0;
        while (allDone && i < this._changes.length) {
            RefactoringChange change = this._changes[i];
            if (change.undo()) {
                Node node = change.getNode();
                if (node != null) {
                    affectedNodes.add(node);
                }
            } else {
                int j = i - 1;
                while (j >= 0) {
                    RefactoringChange changeToRedo = this._changes[j];
                    changeToRedo.doit();
                    --j;
                }
                allDone = false;
            }
            ++i;
        }
        this.fireEvent(false, false);
        if (allDone) {
            this.notifyNodes(affectedNodes);
        }
        return allDone ? 0 : 1;
    }

    public String getName() {
        return this._commandName;
    }

    public Node[] getAffectedNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        int i = 0;
        while (i < this._changes.length) {
            RefactoringChange change = this._changes[i];
            Node node = change.getNode();
            if (node != null) {
                nodes.add(node);
            }
            ++i;
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    private boolean areNodesWritable() {
        int i = 0;
        while (i < this._changes.length) {
            RefactoringChange change = this._changes[i];
            Node node = change.getNode();
            if (node != null && node.isReadOnly()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean prepareFiles() {
        boolean ret;
        ProgressBar progressBar;
        1MyRunnable myRunnable = new 1MyRunnable();
        myRunnable._progressBar = progressBar = new ProgressBar((Component)Ide.getMainWindow(), RefactoringArb.getString(361), (Runnable)myRunnable, true);
        progressBar.start(RefactoringArb.getString(319), "");
        if (myRunnable._failedFile != null) {
            String fileName = URLFileSystem.getPlatformPathName((URL)myRunnable._failedFile);
            String message = MessageFormat.format(RefactoringArb.getString(293), fileName);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)this._commandName, null);
            ret = false;
        } else {
            ret = progressBar.hasUserCancelled() ^ true;
        }
        return ret;
    }

    public boolean runCommand() {
        boolean ret = false;
        if (this.prepareFiles()) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            try {
                int retValue = commandProcessor.invoke((Command)this);
                ret = retValue == 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static boolean runCommand(Context context, String commandName, List changes) {
        TextChangeCommand textChangeCommand = new TextChangeCommand(context, commandName, changes);
        return textChangeCommand.runCommand();
    }

    public static boolean runCommand(List changes, SearchOperation searchOperation) {
        TextChangeCommand textChangeCommand = new TextChangeCommand(searchOperation, changes);
        return textChangeCommand.runCommand();
    }

    protected void fireEvent(boolean isDo, boolean isBefore) {
        int id = isDo ? (isBefore ? 4 : 5) : (isBefore ? 6 : 7);
        RefactoringEvent event = this.createRefactoringEvent(id);
        if (event != null) {
            RefManagerImpl refManager = RefManagerImpl.getImplInstance();
            refManager.fireRefEvent(event);
        }
    }

    protected RefactoringEvent createRefactoringEvent(int id) {
        if (this._searchOperation != null) {
            return new RefactoringEvent(id, this._searchOperation);
        }
        return null;
    }

    class 1MyRunnable
    implements Runnable {
        URL _failedFile;
        ProgressBar _progressBar;

        public void run() {
            Node[] affectedNodes = TextChangeCommand.this.getAffectedNodes();
            int j = 0;
            while (this._failedFile == null && j < affectedNodes.length) {
                Node affectedNode = affectedNodes[j];
                URL url = affectedNode.getURL();
                String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                this._progressBar.updateProgress(null, platformPathName);
                if (!URLFileSystem.setReadOnly((URL)url, (boolean)false) && !Util.setReadOnly(url, false)) {
                    this._failedFile = url;
                }
                ++j;
            }
            this._progressBar.setDoneStatus();
        }

        1MyRunnable() {
        }
    }
}

