/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.RadioKeyController;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;

public class AskSafeRenameDlg {
    public static final int SAFE_RENAME_YES = 0;
    public static final int SAFE_RENAME_NO = 1;
    public static final int SAFE_RENAME_CANCEL = 2;
    private final DismissableJEWTDialog _dialog;
    private final JRadioButton _radioRefactor;
    private final JCheckBox _previewCheckBox;

    public AskSafeRenameDlg(URL url) {
        boolean isDirectory = URLFileSystem.isDirectory((URL)url);
        this._dialog = new DismissableJEWTDialog((Frame)Ide.getMainWindow());
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton radioFile = new JRadioButton();
        String radioFileLabel = isDirectory ? "Rename the &directory only, do not update references." : RefactoringArb.getString(114);
        ResourceUtils.resButton((AbstractButton)radioFile, (String)radioFileLabel);
        buttonGroup.add(radioFile);
        radioFile.addMouseListener(this._dialog);
        this._radioRefactor = new JRadioButton();
        String radioRefactorLabel = isDirectory ? "Rename the directory and update references." : RefactoringArb.getString(93);
        ResourceUtils.resButton((AbstractButton)this._radioRefactor, (String)radioRefactorLabel);
        buttonGroup.add(this._radioRefactor);
        this._radioRefactor.addMouseListener(this._dialog);
        this._radioRefactor.getModel().addChangeListener(this._dialog);
        this._previewCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._previewCheckBox, (String)"&Preview");
        CopyableInteger prefs = CopyableInteger.loadCopyableInteger("FileRenamePref", 0);
        JRadioButton selected = prefs.isBitSet(1) ? this._radioRefactor : radioFile;
        selected.setSelected(true);
        this._previewCheckBox.setSelected(prefs.isBitSet(2));
        RadioKeyController.attach((ButtonGroup)buttonGroup);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)radioFile, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        panel.add((Component)this._radioRefactor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this._dialog.setContent(panel);
        this._dialog.setInitialFocus(selected);
        this._dialog.stateChanged(null);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_idedrenamefile_html");
    }

    public int run() {
        int ret = 1;
        if (this._dialog.runDialog()) {
            CopyableInteger prefs = CopyableInteger.loadCopyableInteger("FileRenamePref", 0);
            boolean isRefactor = this._radioRefactor.isSelected();
            prefs.setBit(1, isRefactor);
            if (this._previewCheckBox != null) {
                boolean preview = this._previewCheckBox.isSelected();
                prefs.setBit(2, preview);
            }
            if (isRefactor) {
                ret = 0;
            }
        } else {
            ret = 2;
        }
        return ret;
    }

    public boolean isPreview() {
        return this._previewCheckBox != null && this._previewCheckBox.isSelected();
    }

    static JCheckBox ra$_previewCheckBox(AskSafeRenameDlg askSafeRenameDlg) {
        return askSafeRenameDlg._previewCheckBox;
    }

    static JRadioButton ra$_radioRefactor(AskSafeRenameDlg askSafeRenameDlg) {
        return askSafeRenameDlg._radioRefactor;
    }

    private final class DismissableJEWTDialog
    extends JEWTDialog
    implements MouseListener,
    ChangeListener {
        public DismissableJEWTDialog(Frame owner) {
            super(owner, RefactoringArb.getString(208), 7);
        }

        public void dismiss() {
            this.dismissDialog(false);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.dismiss();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void stateChanged(ChangeEvent e) {
            AskSafeRenameDlg.ra$_previewCheckBox(AskSafeRenameDlg.this).setEnabled(AskSafeRenameDlg.ra$_radioRefactor(AskSafeRenameDlg.this).isSelected());
        }
    }
}

