/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdevimpl.refactoring.dnd.JavaSourceNodeDragHelper;

public class FolderDropHelper
implements DropHelper {
    public static final Class DROP_TARGET_CLASS = RelativeDirectoryContextFolder.class;
    private JavaManager javaManager;

    public float getWeight() {
        return 10.0f;
    }

    public boolean canTransferData(Object dropTarget, DataFlavor[] transferFlavors, int action) {
        if (action == 2 && this.getPackageName(dropTarget) != null) {
            int i = 0;
            while (i < transferFlavors.length) {
                if (transferFlavors[i].equals(JavaSourceNodeDragHelper.JAVA_SOURCE_NODE_FLAVOR)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean transferData(Object dropTarget, Transferable[] transferablesForSelection, int action) {
        String packageName;
        boolean ret = false;
        if (action == 2 && (packageName = this.getPackageName(dropTarget)) != null) {
            Context context = null;
            Project sourceProject = null;
            TNode targetPackageNode = (TNode)dropTarget;
            Project targetProject = (Project)targetPackageNode.getAncestor(Project.class);
            try {
                if (transferablesForSelection.length > 0) {
                    DefaultMutableTreeNode node;
                    Transferable transferable = transferablesForSelection[0];
                    if (transferable.isDataFlavorSupported(TransferableContext.contextFlavor)) {
                        TransferableContext tc = (TransferableContext)transferable.getTransferData(TransferableContext.contextFlavor);
                        context = tc.getContext();
                    }
                    if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)) instanceof TNode) {
                        sourceProject = (Project)((TNode)node).getAncestor(Project.class);
                    }
                }
                JavaSourceNode firstNode = null;
                if (context != null && context.getWorkspace() != null && context.getProject() != null && ModelUtil.areEqual((Object)targetProject, sourceProject)) {
                    RefactoringManager refactoringManager;
                    MoveClassesCriteria criteria = new MoveClassesCriteria(false, false, null, null);
                    URL targetDirectory = this.getTargetDirectory(dropTarget);
                    if (targetDirectory != null) {
                        criteria.setPreferredPackageUrl(packageName, targetDirectory);
                    }
                    JavaManager javaManager = this.getJavaManager(context);
                    int i = 0;
                    while (i < transferablesForSelection.length) {
                        Transferable transferable = transferablesForSelection[i];
                        if (transferable.isDataFlavorSupported(JavaSourceNodeDragHelper.JAVA_SOURCE_NODE_FLAVOR)) {
                            JavaSourceNode srcNode;
                            firstNode = srcNode = (JavaSourceNode)transferable.getTransferData(JavaSourceNodeDragHelper.JAVA_SOURCE_NODE_FLAVOR);
                            URL url = srcNode.getURL();
                            SourceFile sourceFile = javaManager.getSourceFile(url);
                            JavaClass primaryClass = sourceFile.getPrimaryClass();
                            if (primaryClass != null) {
                                String className = primaryClass.getName();
                                String oldPackageName = primaryClass.getPackageName();
                                criteria.addClassMove(javaManager, oldPackageName, className, packageName, className);
                            }
                        }
                        ++i;
                    }
                    if (criteria.getOldClsNames().length > 0 && (refactoringManager = RefactoringManager.getRefactoringManager()).moveClasses(context, criteria, false)) {
                        TreeExplorer explorer = targetPackageNode.getOwner();
                        TNode javaNode = explorer.findTNode((Element)firstNode, targetPackageNode);
                        if (javaNode != null) {
                            explorer.setSelected(javaNode);
                        } else {
                            explorer.setSelected(targetPackageNode);
                        }
                        ret = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected boolean isValidDropTargetType(Element element) {
        return element instanceof RelativeDirectoryContextFolder;
    }

    private String getPackageName(Object dropTarget) {
        String relPath;
        String newPackageName;
        TNode tnode;
        Element element;
        if (dropTarget instanceof TNode && this.isValidDropTargetType(element = (tnode = (TNode)dropTarget).getData()) && NamingUtil.isPackageIdentifier((String)(newPackageName = (relPath = ((RelativeDirectoryContextFolder)element).getRelativePath()).replaceAll("/", ".")))) {
            return newPackageName;
        }
        return null;
    }

    private URL getTargetDirectory(Object dropTarget) {
        RelativeDirectoryContextFolder relativeDirectoryContextFolder;
        URLPath rootDirectories;
        URL[] entries;
        TNode tnode;
        Element element;
        URL ret = null;
        if (dropTarget instanceof TNode && this.isValidDropTargetType(element = (tnode = (TNode)dropTarget).getData()) && (entries = (rootDirectories = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRootDirectories()).getEntries()).length == 1) {
            String relPath = relativeDirectoryContextFolder.getRelativePath();
            URL entry = entries[0];
            ret = URLFactory.newDirURL((URL)entry, (String)relPath);
        }
        return ret;
    }

    private JavaManager getJavaManager(Context context) {
        if (this.javaManager == null) {
            this.javaManager = JavaManager.getJavaManager((Project)context.getProject());
        }
        return this.javaManager;
    }
}

