/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.handlers;

import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JPaths;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.search.Scope;

public class JavaURLHelper {
    public static HashSet getJavaURLsContaining(SearchOperation searchOperation, Project project, String keyword, boolean includeLibraries, boolean searchInNonJavaFiles, ProgressIndicator progressIndicator) {
        String[] keywords = new String[]{keyword};
        return JavaURLHelper.getJavaURLsContaining(searchOperation, project, keywords, includeLibraries, searchInNonJavaFiles, Scope.createDummyScope(), progressIndicator);
    }

    public static HashSet getJavaURLsContaining(SearchOperation searchOperation, Project project, String[] keywords, boolean includeLibraries, boolean searchInNonJavaFiles, Scope scope, ProgressIndicator progressIndicator) {
        HashSet<URL> ret = new HashSet<URL>();
        ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        ContentSet contentSet = searchInNonJavaFiles ? ProjectContent.getInstance((PropertyStorage)project).getAllContents() : PathsConfiguration.getInstance((Project)project).getJavaContentSet();
        HashSet keywordHits = searchOperation.getKeywordHits(contentSet, keywords, progressIndicator);
        Iterator iterator = keywordHits.iterator();
        while (iterator.hasNext() && !searchOperation.isUserCancelled()) {
            String relativePath;
            URL url = (URL)iterator.next();
            if (!Util.isJavaSource(url) || !allContents.canHaveMember(url) || !scope.isValidRelativePath(project, relativePath = allContents.toRelativePath(url))) continue;
            ret.add(url);
        }
        if (includeLibraries) {
            JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
            JavaURLHelper.search((JPaths)jProjectLibraries.getJDK(), searchOperation, keywords, progressIndicator, ret);
            JLibrary[] libraryList = jProjectLibraries.getLibraries();
            int i = 0;
            while (i < libraryList.length && !searchOperation.isUserCancelled()) {
                JLibrary jLibrary = libraryList[i];
                JavaURLHelper.search((JPaths)jLibrary, searchOperation, keywords, progressIndicator, ret);
                ++i;
            }
        }
        return ret;
    }

    private static void search(JPaths paths, SearchOperation searchOperation, String[] keywords, ProgressIndicator progressIndicator, HashSet ret) {
        URLPath libraryPath = paths.getSourcePath();
        HashSet libraryHit = searchOperation.getKeywordHits(libraryPath, keywords, progressIndicator);
        Iterator iterator = libraryHit.iterator();
        while (iterator.hasNext() && !searchOperation.isUserCancelled()) {
            URL url = (URL)iterator.next();
            if (!Util.isJavaSource(url)) continue;
            ret.add(url);
        }
    }

    public static URL[] getDefiningClassURLs(SearchOperation searchOperation, String fqClassName) {
        List dependencyList;
        HashSet definingURLs = new HashSet();
        Context context = searchOperation.getContext();
        Project project = context.getProject();
        JavaURLHelper.addDefiningURLs(project, fqClassName, definingURLs);
        if (definingURLs.isEmpty() && (dependencyList = DependencyConfiguration.getInstance((Project)project).getDependencyList()) != null) {
            boolean found = false;
            int i = 0;
            while (!found && i < dependencyList.size()) {
                Dependable dependable = (Dependable)dependencyList.get(i);
                Element dependableSource = dependable.getSource();
                if (dependableSource instanceof Project) {
                    Project dependentProject = (Project)dependableSource;
                    found = JavaURLHelper.addDefiningURLs(dependentProject, fqClassName, definingURLs);
                }
                ++i;
            }
        }
        URL[] ret = definingURLs.toArray(new URL[definingURLs.size()]);
        return ret;
    }

    private static boolean addDefiningURLs(Project dependentProject, String fqClassName, HashSet definingURLs) {
        boolean ret = false;
        JavaManager javaManager = JavaManager.getJavaManager((Project)dependentProject);
        SourceClass sourceClass = javaManager.getSourceClass(fqClassName);
        if (sourceClass != null) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL url = sourceFile.getURL();
            definingURLs.add(url);
            ret = true;
        }
        return ret;
    }
}

