/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.handlers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.util.MultiMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMemberCriteria;
import oracle.jdeveloper.refactoring.criteria.SafeDeleteClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchConstructorCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.SearchMethodCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.TextChangeBasedRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.search.Scope;

public class TextURLHandler
extends TextChangeBasedRefactoringHandler {
    private static final String KEYWORD_USAGES_KEY = "KEYWORD_USAGES";

    public HashSet chooseURLs(SearchOperation searchOperation, Project project, ProgressIndicator progressIndicator) {
        HashSet ret = null;
        String[] keywords = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case 1: {
                SearchClassCriteria criteria = (SearchClassCriteria)searchCriteria;
                if (!criteria.isSearchInNonJavaFiles()) break;
                String className = criteria.getClassName();
                keywords = new String[]{className};
                break;
            }
            case 3: {
                SearchFieldCriteria criteria = (SearchFieldCriteria)searchCriteria;
                if (!criteria.isSearchInNonJavaFiles()) break;
                String memberName = criteria.getFieldName();
                keywords = new String[]{memberName};
                break;
            }
            case 2: {
                SearchMethodCriteria criteria = (SearchMethodCriteria)searchCriteria;
                if (!criteria.isSearchInNonJavaFiles()) break;
                String memberName = criteria.getMethodName();
                keywords = new String[]{memberName};
                break;
            }
            case -2147483546: 
            case -2147483545: {
                RenameMemberCriteria criteria = (RenameMemberCriteria)searchCriteria;
                if (!criteria.isSearchNonJavaFiles()) break;
                String memberName = criteria.getMemberNameBefore();
                keywords = new String[]{memberName};
                break;
            }
            case -2147483535: {
                MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
                if (!moveClassesCriteria.isSearchInNonJavaFiles()) break;
                keywords = moveClassesCriteria.getFqOldClassesNames();
                break;
            }
            case -2147483538: {
                SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)searchCriteria;
                keywords = safeDeleteClassesCriteria.getFqClassNames();
                break;
            }
        }
        if (keywords != null) {
            SearchOperationImpl searchContext = (SearchOperationImpl)searchOperation;
            ret = this.chooseURLs(searchContext, keywords, project, progressIndicator);
        }
        return ret;
    }

    public UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, ProgressIndicator progressIndicator) {
        UsageModel usageModel = null;
        String[] searchString = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case 1: {
                SearchClassCriteria criteria = (SearchClassCriteria)searchCriteria;
                String fqClassName = criteria.getFqClassName();
                searchString = new String[]{fqClassName};
                break;
            }
            case 3: {
                SearchFieldCriteria criteria = (SearchFieldCriteria)searchCriteria;
                String memberName = criteria.getFqClassName() + "." + criteria.getFieldName();
                searchString = new String[]{memberName};
                break;
            }
            case 2: {
                SearchMethodCriteria criteria = (SearchMethodCriteria)searchCriteria;
                String memberName = criteria.getFqClassName() + "." + criteria.getMethodName();
                searchString = new String[]{memberName};
                break;
            }
            case -2147483546: 
            case -2147483545: {
                RenameMemberCriteria criteria = (RenameMemberCriteria)searchCriteria;
                String memberName = criteria.getFqClassName() + "." + criteria.getMemberNameBefore();
                searchString = new String[]{memberName};
                break;
            }
            case -2147483535: {
                MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
                searchString = moveClassesCriteria.getFqOldClassesNames();
                break;
            }
            case -2147483538: {
                SafeDeleteClassesCriteria safeDeleteClassesCriteria = (SafeDeleteClassesCriteria)searchCriteria;
                searchString = safeDeleteClassesCriteria.getFqClassNames();
                break;
            }
        }
        if (searchString != null) {
            MultiMap multiMap = new MultiMap();
            usageModel = this.findUsages(searchOperation, project, urls, searchString, multiMap);
            searchOperation.setProperty(KEYWORD_USAGES_KEY, multiMap);
        }
        return usageModel;
    }

    private String getNewName(SearchOperation searchOperation, String oldName) {
        String ret = null;
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        int searchType = searchCriteria.getSearchType();
        switch (searchType) {
            case -2147483546: 
            case -2147483545: {
                RenameMemberCriteria criteria = (RenameMemberCriteria)searchCriteria;
                ret = criteria.getFqClassName() + "." + criteria.getMemberNameAfter();
                break;
            }
            case -2147483535: {
                MoveClassesCriteria moveClassesCriteria = (MoveClassesCriteria)searchCriteria;
                String[] fqOldClassesNames = moveClassesCriteria.getFqOldClassesNames();
                int i = 0;
                while (ret == null && i < fqOldClassesNames.length) {
                    String fqOldClassesName = fqOldClassesNames[i];
                    if (oldName.equals(fqOldClassesName)) {
                        String[] fqNewClassesNames = moveClassesCriteria.getFqNewClassesNames();
                        ret = fqNewClassesNames[i];
                    }
                    ++i;
                }
                break;
            }
        }
        return ret;
    }

    private HashSet chooseURLs(SearchOperationImpl searchContext, String[] keywords, Project project, ProgressIndicator progressIndicator) {
        ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        String[] lastWords = new String[keywords.length];
        int i = 0;
        while (i < keywords.length) {
            String lastWord;
            String keyword = keywords[i];
            int lastDot = keyword.lastIndexOf(46);
            lastWords[i] = lastWord = keyword.substring(lastDot + 1);
            ++i;
        }
        HashSet keywordHits = searchContext.getKeywordHits(allContents, lastWords, progressIndicator);
        HashSet<URL> ret = new HashSet<URL>(keywordHits.size());
        for (URL url : keywordHits) {
            if (!allContents.canHaveMember(url)) continue;
            ret.add(url);
        }
        return ret;
    }

    private UsageModel findUsages(SearchOperation searchOperation, Project project, URL[] urls, String[] searchStrings, MultiMap multiMap) {
        ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        Scope scope = TextURLHandler.getScope(searchOperation);
        UsageModel usageModel = new UsageModel();
        int i = 0;
        while (i < urls.length) {
            Node node;
            URL url = urls[i];
            if (scope.isValidPath(project, allContents, url) && (node = NodeFactory.find((URL)url)) instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                String text = textBuffer.getString(0, textBuffer.getLength());
                int keywordPos = 0;
                while (keywordPos < searchStrings.length) {
                    String keyword = searchStrings[keywordPos];
                    int pos = 0;
                    while (pos >= 0) {
                        if ((pos = text.indexOf(keyword, pos)) < 0) continue;
                        int keywordLength = keyword.length();
                        int nextCharPos = pos + keywordLength;
                        if (nextCharPos >= text.length() || !Character.isJavaIdentifierPart(text.charAt(nextCharPos))) {
                            UsageEntry usageEntry = UsageEntry.createEntry(project, url, pos, keywordLength, 0);
                            usageModel.addUsageEntry(usageEntry);
                            multiMap.add((Object)keyword, (Object)usageEntry);
                        }
                        pos += keyword.length();
                    }
                    ++keywordPos;
                }
            }
            ++i;
        }
        return usageModel;
    }

    private static Scope getScope(SearchOperation searchOperation) {
        SearchCriteria searchCriteria = searchOperation.getCriteria();
        switch (searchCriteria.getSearchType()) {
            case 1: {
                return ((SearchClassCriteria)searchCriteria).getScope();
            }
            case 4: {
                return ((SearchConstructorCriteria)searchCriteria).getScope();
            }
            case 3: {
                return ((SearchFieldCriteria)searchCriteria).getScope();
            }
            case 2: {
                return ((SearchMethodCriteria)searchCriteria).getScope();
            }
        }
        return Scope.createDummyScope();
    }

    public static ArrayList genericRename(UsageModel usageModel, String oldName, String newName) {
        ArrayList<TextChange> refChanges = new ArrayList<TextChange>();
        ArrayList usageEntries = usageModel.getUsageEntries();
        int entryCount = usageEntries.size();
        int i = 0;
        while (i < entryCount) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
            if (usageEntry.isIncluded()) {
                URL url = usageEntry.getURL();
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)url);
                    int offset = usageEntry.getOffset();
                    TextChange textChange = new TextChange(textNode, offset, oldName, newName);
                    refChanges.add(textChange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return refChanges;
    }

    public static ArrayList genericRename(UsageModel usageModel, String newName) {
        ArrayList usageEntries = usageModel.getUsageEntries();
        ArrayList refChanges = TextURLHandler.genericRename(usageEntries, newName);
        return refChanges;
    }

    private static ArrayList genericRename(List usageEntries, String newName) {
        ArrayList<TextChange> refChanges = new ArrayList<TextChange>();
        int entryCount = usageEntries.size();
        int i = 0;
        while (i < entryCount) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
            if (usageEntry.isIncluded()) {
                URL url = usageEntry.getURL();
                try {
                    TextNode textNode = (TextNode)NodeFactory.findOrCreate((URL)url);
                    int offset = usageEntry.getOffset();
                    int length = usageEntry.getLength();
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    String oldName = textBuffer.getString(offset, length);
                    TextChange textChange = new TextChange(textNode, offset, oldName, newName);
                    refChanges.add(textChange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return refChanges;
    }

    public RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        ArrayList allChanges = new ArrayList();
        MultiMap multiMap = (MultiMap)searchOperation.getProperty(KEYWORD_USAGES_KEY);
        Set oldWords = multiMap.keySet();
        for (String oldWord : oldWords) {
            List usageEntries = multiMap.get((Object)oldWord);
            String newName = this.getNewName(searchOperation, oldWord);
            ArrayList changes = TextURLHandler.genericRename(usageEntries, newName);
            allChanges.addAll(changes);
        }
        Collections.sort(allChanges);
        return allChanges.toArray(new RefactoringChange[allChanges.size()]);
    }
}

