/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.find.FindNavigator;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.find.NavigableHighlighter;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.HighlightPreferences;
import oracle.jdevimpl.refactoring.highlight.JavaHighlighter;
import oracle.jdevimpl.refactoring.highlight.LanguageHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HighlightController
implements EditorPluginsFactory,
Controller,
NavigableHighlighter {
    private static HighlightController INSTANCE;
    private static final int CANCEL_HIGHLIGHT_CMD_ID;
    static final int HIGHLIGHT_CMD_ID;
    private static final int _highlightModeCmdId;
    private final HighlightStyle _highlightStyle;
    private ArrayList<HighlightPlugin> _installedPlugins;
    static final String MARK_CATEGORY = "!codehighlight";
    private ArrayList<LanguageHighlighter> _languageHighlighters;
    private boolean _stickyMode;

    private void $init$() {
        this._installedPlugins = new ArrayList();
        this._languageHighlighters = new ArrayList();
    }

    private HighlightController() {
        this.$init$();
        this._highlightStyle = CodeEditor.createHighlightStyle((String)this.getClass().getName(), (String)RefactoringArb.getString(214), (int)75, (Color)Color.BLACK, (Color)Color.YELLOW);
        FileOverviewMargin.setMarkColor((String)MARK_CATEGORY, (HighlightStyle)this._highlightStyle);
        this.createActions();
        this.registerHighlighter(new JavaHighlighter());
        FindNavigator.getFindNavigator().registerNavigableHighlighter((NavigableHighlighter)this);
    }

    public void registerHighlighter(LanguageHighlighter languageHighlighter) {
        this._languageHighlighters.add(languageHighlighter);
    }

    public void unregisterHighlighter(LanguageHighlighter languageHighlighter) {
        this._languageHighlighters.remove(languageHighlighter);
    }

    public List<LanguageHighlighter> getLanguageHighlighters() {
        return Collections.unmodifiableList(this._languageHighlighters);
    }

    public static void createInstance() {
        INSTANCE = new HighlightController();
        CodeEditor.registerFactory((EditorPluginsFactory)INSTANCE);
    }

    private void createActions() {
        String resString = RefactoringArb.getString(201);
        String label = StringUtils.stripMnemonic((String)resString);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)resString);
        IdeAction actionHighlight = IdeAction.get((int)HIGHLIGHT_CMD_ID, null, (String)label, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)mnemonic, (ArrayResourceBundle)RefactoringArb.getInstance(), (int)370, null, (boolean)true);
        actionHighlight.addController((Controller)this);
        String resString2 = RefactoringArb.getString(53);
        String label2 = StringUtils.stripMnemonic((String)resString2);
        int mnemonic2 = StringUtils.getMnemonicKeyCode((String)resString2);
        IdeAction cancelHighlightAction = IdeAction.get((int)CANCEL_HIGHLIGHT_CMD_ID, null, (String)label2, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)mnemonic2, (ArrayResourceBundle)RefactoringArb.getInstance(), (int)324, null, (boolean)false);
        cancelHighlightAction.addController((Controller)this);
        String resString3 = RefactoringArb.getString(269);
        String label3 = StringUtils.stripMnemonic((String)resString3);
        int mnemonic3 = StringUtils.getMnemonicKeyCode((String)resString3);
        IdeAction actionToggleHighlightMode = IdeAction.get((int)_highlightModeCmdId, null, (String)label3, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)mnemonic3, null, null, (boolean)true);
        actionToggleHighlightMode.addController((Controller)this);
        actionToggleHighlightMode.putValue("Check", (Object)true);
        HighlightPreferences preferences = HighlightPreferences.getInstance();
        this._stickyMode = preferences.isEnabled();
        actionToggleHighlightMode.setState(this._stickyMode);
        Menubar menubar = Ide.getMenubar();
        if (menubar != null) {
            float menuWeight = JDeveloperMenuConstants.WEIGHT_SEARCH_REPLACE;
            JMenu menu = MenuManager.getJMenu((String)"Search");
            JMenuItem menuItem = menubar.createMenuItem((ToggleAction)actionHighlight, menuWeight += 0.001f);
            menubar.add((Component)menuItem, menu, 1.0f);
            JMenuItem menuItem2 = menubar.createMenuItem((ToggleAction)cancelHighlightAction, menuWeight += 0.001f);
            menubar.add((Component)menuItem2, menu, 1.0f);
            JMenuItem menuItem3 = menubar.createMenuItem((ToggleAction)actionToggleHighlightMode, menuWeight += 0.001f);
            menubar.add((Component)menuItem3, menu, 1.0f);
        }
    }

    public static HighlightController getInstance() {
        return INSTANCE;
    }

    public List createPlugins(Context ideContext) {
        ArrayList<HighlightPlugin> plugins = new ArrayList<HighlightPlugin>(1);
        plugins.add(new HighlightPlugin());
        return plugins;
    }

    public HighlightStyle getHighlightStyle() {
        return this._highlightStyle;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == HIGHLIGHT_CMD_ID) {
            this.whenHighlight(context, true);
            return true;
        }
        if (commandId == _highlightModeCmdId) {
            this.whenStickyMode(context);
            return true;
        }
        if (commandId == CANCEL_HIGHLIGHT_CMD_ID) {
            FindNavigator findNavigator = FindNavigator.getFindNavigator();
            BasicEditorPane editorPane = HighlightController.getBasicEditorPane(context);
            findNavigator.clearHighlights(editorPane);
            findNavigator.setSearchHighlightMode(false);
            return true;
        }
        return false;
    }

    private void whenStickyMode(Context context) {
        this._stickyMode ^= true;
        HighlightPreferences preferences = HighlightPreferences.getInstance();
        preferences.setEnabled(this._stickyMode);
        for (HighlightPlugin HighlightPlugin2 : this._installedPlugins) {
            HighlightPlugin2.setStickyMode(this._stickyMode);
        }
        if (this._stickyMode) {
            this.whenHighlightAnyMode(context, true);
        }
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == HIGHLIGHT_CMD_ID) {
            boolean isEnabled = this.whenHighlight(context, false);
            action.setEnabled(isEnabled);
        } else if (commandId == CANCEL_HIGHLIGHT_CMD_ID) {
            BasicEditorPane editorPane = HighlightController.getBasicEditorPane(context);
            boolean isEnabled = false;
            if (editorPane != null) {
                try {
                    isEnabled = FindNavigator.getFindNavigator().hasHighlights(editorPane);
                }
                catch (NullPointerException npe) {
                    isEnabled = false;
                }
            }
            action.setEnabled(isEnabled && !this._stickyMode);
        } else if (commandId == _highlightModeCmdId) {
            action.setEnabled(this.whenHighlightAnyMode(context, false));
            action.setState(this._stickyMode);
        } else {
            return false;
        }
        return true;
    }

    private static BasicEditorPane getBasicEditorPane(Context context) {
        View view;
        BasicEditorPane ret = null;
        if (context != null && (view = context.getView()) instanceof FindableEditor) {
            FindableEditor findableEditor = (FindableEditor)view;
            ret = findableEditor.getFocusedEditorPane();
        }
        return ret;
    }

    private boolean whenHighlight(Context context, boolean doit) {
        boolean ret = false;
        if (!this._stickyMode) {
            ret = this.whenHighlightAnyMode(context, doit);
        }
        return ret;
    }

    private boolean whenHighlightAnyMode(Context context, boolean doit) {
        HighlightPlugin highlightPlugin;
        FindableEditor findableEditor;
        BasicEditorPane focusedEditorPane;
        View view;
        boolean ret = false;
        if (context.getProject() != null && (view = context.getView()) instanceof FindableEditor && (focusedEditorPane = (findableEditor = (FindableEditor)view).getFocusedEditorPane()) != null && (highlightPlugin = HighlightPlugin.getHighlightPlugin(focusedEditorPane)) != null) {
            if (doit) {
                highlightPlugin.whenHighlight(context);
                FindNavigator.getFindNavigator().setSearchHighlightMode(true);
            }
            ret = true;
        }
        return ret;
    }

    public void add(HighlightPlugin highlightPlugin) {
        if (this._stickyMode) {
            highlightPlugin.setStickyMode(true);
        }
        this._installedPlugins.add(highlightPlugin);
    }

    public void remove(HighlightPlugin highlightPlugin) {
        this._installedPlugins.remove(highlightPlugin);
    }

    public boolean hasHighlights(BasicEditorPane basicEditorPane) {
        boolean ret = false;
        HighlightPlugin highlightPlugin = HighlightPlugin.getHighlightPlugin(basicEditorPane);
        if (highlightPlugin != null && highlightPlugin.hasHighlights()) {
            ret = true;
        }
        return ret;
    }

    public void clearHighlights(BasicEditorPane basicEditorPane) {
        HighlightPlugin highlightPlugin = HighlightPlugin.getHighlightPlugin(basicEditorPane);
        if (highlightPlugin != null) {
            highlightPlugin.clearHighlights();
        }
    }

    public boolean getHighlightAfter(BasicEditorPane basicEditorPane, int position, int[] range) {
        boolean ret = false;
        HighlightPlugin highlightPlugin = HighlightPlugin.getHighlightPlugin(basicEditorPane);
        if (highlightPlugin != null && highlightPlugin.getHighlightAfter(position, range)) {
            ret = true;
        }
        return ret;
    }

    public boolean getHighlightBefore(BasicEditorPane basicEditorPane, int position, int[] range) {
        boolean ret = false;
        HighlightPlugin highlightPlugin = HighlightPlugin.getHighlightPlugin(basicEditorPane);
        if (highlightPlugin != null && highlightPlugin.getHighlightBefore(position, range)) {
            ret = true;
        }
        return ret;
    }

    static {
        CANCEL_HIGHLIGHT_CMD_ID = Ide.findOrCreateCmdID((String)"CancelHighlightingCommand");
        HIGHLIGHT_CMD_ID = Ide.findOrCreateCmdID((String)"Highlight.HIGHLIGHT_CMD_ID");
        _highlightModeCmdId = Ide.findOrCreateCmdID((String)"Highlight.HIGHLIGHT_MODE_CMD_ID");
    }
}

