/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightController;
import oracle.jdevimpl.refactoring.highlight.HighlightMark;
import oracle.jdevimpl.refactoring.highlight.LanguageHighlighter;
import oracle.jdevimpl.refactoring.highlight.ParameterHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.AnnotationHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.ConstructorHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.MethodHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.PackageHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.ResolvedTypeHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.ReturnHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.SuperAspectHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.ThrowsHighlighter;
import oracle.jdevimpl.refactoring.highlight.highlighters.VariableHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HighlightPlugin
implements EditorPlugin,
Comparator {
    private static final String KEY = "CODEHIGHLIGHT";
    private BasicEditorPane _editorPane;
    private HighlightLayer _highlightLayer;
    boolean _stickyMode;
    private ArrayList<LanguageHighlighter> _languageHighlighters;
    private ArrayList<HighlightedText> _highlights;
    private final Listeners _listeners;

    private void $init$() {
        this._highlights = new ArrayList();
        this._listeners = new Listeners(null);
    }

    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        Context context = codeEditor.getContext();
        Node node = context.getNode();
        this._languageHighlighters = new ArrayList();
        HighlightController highlightControler = HighlightController.getInstance();
        List<LanguageHighlighter> languageHighlighters = highlightControler.getLanguageHighlighters();
        for (LanguageHighlighter languageHighlighter : languageHighlighters) {
            if (!languageHighlighter.canHighlight(node)) continue;
            languageHighlighter.attach(context);
            this._languageHighlighters.add(languageHighlighter);
        }
        if (!this._languageHighlighters.isEmpty()) {
            this._editorPane = basicEditorPane;
            basicEditorPane.putProperty(KEY, (Object)this);
            highlightControler.add(this);
        }
        node.addNodeListener((NodeListener)this._listeners);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        Listeners.mav$cancelPendingActions(this._listeners);
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        Node node = codeEditor.getContext().getNode();
        node.removeNodeListener((NodeListener)this._listeners);
        HighlightController highlightControler = HighlightController.getInstance();
        highlightControler.remove(this);
        for (LanguageHighlighter languageHighlighter : this._languageHighlighters) {
            languageHighlighter.detach();
        }
        if (this._editorPane != null) {
            basicEditorPane.putProperty(KEY, null);
            this._editorPane.destroyHighlightLayer(this._highlightLayer);
        }
        this._highlights.clear();
    }

    static HighlightPlugin getHighlightPlugin(BasicEditorPane basicEditorPane) {
        return (HighlightPlugin)basicEditorPane.getProperty(KEY);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    public void highlight(SourceElement sourceElement, String tooltip) {
        this.highlight(sourceElement.getStartOffset(), sourceElement.getEndOffset(), tooltip);
    }

    public void highlight(int from, int to, String tooltip) {
        int insertPos = Collections.binarySearch(this._highlights, new Point(from, to), this);
        if (insertPos < 0) {
            HighlightStyle highlightStyle = HighlightController.getInstance().getHighlightStyle();
            HighlightLayer highlightLayer = this.getHighlightLayer();
            HighlightedText highlightedText = highlightLayer.addHighlight(highlightStyle, from, to);
            this._highlights.add(-insertPos - 1, highlightedText);
            HighlightMark highlightMark = new HighlightMark(from, to, tooltip);
            Context context = (Context)this._editorPane.getProperty("editor-ide-context");
            CodeEditor codeEditor = (CodeEditor)context.getView();
            FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
            int line = codeEditor.getLineFromOffset(from);
            fileOverviewMargin.addMark("!codehighlight", line, (FileOverviewMark)highlightMark);
        }
    }

    void clearHighlights() {
        if (this._highlightLayer != null) {
            this._highlightLayer.removeAllHighlights();
            Context context = (Context)this._editorPane.getProperty("editor-ide-context");
            CodeEditor codeEditor = (CodeEditor)context.getView();
            FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
            fileOverviewMargin.clearMarks("!codehighlight");
            this._highlights.clear();
            this._editorPane.destroyHighlightLayer(this._highlightLayer);
            this._highlightLayer = null;
        }
    }

    boolean isInHighlight(int position) {
        ArrayList<HighlightedText> highlights = this._highlights;
        int i = Collections.binarySearch(highlights, position, this);
        return i >= 0;
    }

    void highlightMethod(SourceFile sourceFile, JavaMethod javaMethod) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        MethodHighlighter visitor = new MethodHighlighter(this, javaMethod);
        visitor.visit((SourceElement)sourceFile);
    }

    void highlightConstructor(SourceFile sourceFile, JavaMethod javaMethod) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        ConstructorHighlighter visitor = new ConstructorHighlighter(this, javaMethod);
        visitor.visit((SourceElement)sourceFile);
    }

    void highlightVariable(SourceElement scope, JavaHasName searchedElement) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        VariableHighlighter visitor = new VariableHighlighter(this, searchedElement);
        visitor.visit(scope);
    }

    public void highlightParameter(SourceMethod sourceMethod, SourceVariable sourceVariable) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        ParameterHighlighter visitor = new ParameterHighlighter(this, sourceMethod, sourceVariable);
        visitor.visit((SourceElement)sourceMethod.getOwningSourceFile());
    }

    public void highlightThrows(SourceElement scope, JavaType javaType) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        ThrowsHighlighter visitor = new ThrowsHighlighter(this, javaType);
        visitor.visit(scope);
    }

    public void highlightThrows(SourceElement scope, JavaType[] javaType) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        ThrowsHighlighter visitor = new ThrowsHighlighter(this, javaType);
        visitor.visit(scope);
    }

    public void highlightReturns(SourceMethod sourceMethod) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        ReturnHighlighter visitor = new ReturnHighlighter(this, sourceMethod);
        visitor.visit((SourceElement)sourceMethod);
    }

    public void highlightResolvedTypes(SourceFile sourceFile, JavaType[] javaTypes) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        ResolvedTypeHighlighter visitor = new ResolvedTypeHighlighter(this, javaTypes);
        visitor.visit((SourceElement)sourceFile);
    }

    public void highlightPackage(SourceFile sourceFile, JavaPackage javaPackage) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        PackageHighlighter visitor = new PackageHighlighter(this, javaPackage);
        visitor.visit((SourceElement)sourceFile);
    }

    public void highlightSuperAspect(SourceClass sourceClass, JavaType javaType) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        SuperAspectHighlighter visitor = new SuperAspectHighlighter(this, (JavaType)sourceClass, javaType);
        visitor.visit((SourceElement)sourceClass);
    }

    public void highlightClassDeclarations(SourceFile sourceFile) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        TextBuffer textBuffer = sourceFile.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        List sourceElements = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{3});
        for (Object sourceElement1 : sourceElements) {
            SourceClass sourceClass = (SourceClass)sourceElement1;
            SourceName nameElement = sourceClass.getNameElement();
            if (nameElement == null) continue;
            int elementPos = nameElement.getStartOffset();
            int line = lineMap.getLineFromOffset(elementPos);
            int from = lineMap.getLineStartOffset(line);
            int to = lineMap.getLineEndOffset(line);
            String message = MessageFormat.format(RefactoringArb.getString(62), nameElement.getText());
            this.highlight(from, to, message);
        }
    }

    public void highlightAnnotation(SourceFile sourceFile, JavaType javaType) {
        if (this._stickyMode) {
            this.clearHighlights();
        }
        AnnotationHighlighter highlighter = new AnnotationHighlighter(this, javaType);
        highlighter.visit((SourceElement)sourceFile);
    }

    public int compare(Object o1, Object o2) {
        int startValue2;
        int startValue1 = HighlightPlugin.getStartValue(o1);
        int startDiff = startValue1 - (startValue2 = HighlightPlugin.getStartValue(o2));
        if (startDiff != 0) {
            return startDiff;
        }
        int endValue1 = HighlightPlugin.getEndValue(o1);
        int endValue2 = HighlightPlugin.getEndValue(o2);
        int endDiff = endValue1 + endValue2;
        return endDiff;
    }

    private static int getStartValue(Object obj) {
        int offset;
        if (obj instanceof HighlightedText) {
            HighlightedText highlightedText1 = (HighlightedText)obj;
            offset = highlightedText1.getStartOffset();
        } else if (obj instanceof Integer) {
            offset = (Integer)obj;
        } else if (obj instanceof Point) {
            Point point = (Point)obj;
            offset = point.x;
        } else {
            offset = 0;
        }
        return offset;
    }

    private static int getEndValue(Object obj) {
        int offset;
        if (obj instanceof HighlightedText) {
            HighlightedText highlightedText1 = (HighlightedText)obj;
            offset = highlightedText1.getEndOffset();
        } else if (obj instanceof Integer) {
            offset = (Integer)obj;
        } else if (obj instanceof Point) {
            Point point = (Point)obj;
            offset = point.y;
        } else {
            offset = 0;
        }
        return offset;
    }

    public void whenHighlight(Context context) {
        this.whenHighlight(context, false);
    }

    public void whenHighlight(Context context, boolean useCaret) {
        int to;
        int from;
        if (useCaret) {
            to = from = this._editorPane.getCaretPosition();
        } else {
            from = this._editorPane.getSelectionStart();
            to = this._editorPane.getSelectionEnd();
        }
        for (LanguageHighlighter languageHighlighter : this._languageHighlighters) {
            languageHighlighter.highlight(context, this, from, to);
        }
    }

    public boolean hasHighlights() {
        return this._highlights.isEmpty() ^ true;
    }

    public boolean getHighlightAfter(int position, int[] range) {
        ArrayList<HighlightedText> highlights = this._highlights;
        int i = Collections.binarySearch(highlights, position, this);
        if (i < 0) {
            i = -i - 1;
        }
        while (i < this._highlights.size()) {
            HighlightedText highlightedText = this._highlights.get(i);
            int startOffset = highlightedText.getStartOffset();
            if (startOffset > position) {
                range[0] = startOffset;
                range[1] = highlightedText.getEndOffset();
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getHighlightBefore(int position, int[] range) {
        ArrayList<HighlightedText> highlights = this._highlights;
        int i = Collections.binarySearch(highlights, position, this);
        if (i < 0) {
            i = -i - 1;
        }
        while (--i >= 0) {
            HighlightedText highlightedText = this._highlights.get(i);
            int startOffset = highlightedText.getStartOffset();
            if (startOffset >= position) continue;
            range[0] = startOffset;
            range[1] = highlightedText.getEndOffset();
            return true;
        }
        return false;
    }

    public void setStickyMode(boolean stickyMode) {
        this._stickyMode = stickyMode;
        if (stickyMode) {
            this._editorPane.addCaretListener((CaretListener)this._listeners);
        } else {
            this._editorPane.removeCaretListener((CaretListener)this._listeners);
        }
    }

    public boolean isEditing(CodeEditor codeEditor) {
        BasicEditorPane focusedEditorPane;
        boolean ret = false;
        if (codeEditor != null && this._editorPane == (focusedEditorPane = codeEditor.getFocusedEditorPane())) {
            ret = true;
        }
        return ret;
    }

    public HighlightPlugin() {
        this.$init$();
    }

    static BasicEditorPane ra$_editorPane(HighlightPlugin highlightPlugin) {
        return highlightPlugin._editorPane;
    }

    private class Listeners
    extends NodeListener
    implements CaretListener,
    ActionListener {
        private Timer _timer;
        public static final int DELAY = 500;

        public void caretUpdate(CaretEvent e) {
            Timer timer = this.getTimer();
            timer.stop();
            timer.start();
        }

        private Timer getTimer() {
            if (this._timer == null) {
                this._timer = new Timer(500, this);
                this._timer.setRepeats(false);
            }
            return this._timer;
        }

        private void cancelPendingActions() {
            if (this._timer != null) {
                this._timer.stop();
            }
        }

        public void actionPerformed(ActionEvent e) {
            int caretPos;
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)HighlightPlugin.ra$_editorPane(HighlightPlugin.this));
            if (codeEditor != null && codeEditor.getFocusedEditorPane() != null && !HighlightPlugin.this.isInHighlight(caretPos = codeEditor.getCaretPosition())) {
                Context context = codeEditor.getContext();
                HighlightPlugin.this.whenHighlight(context, true);
            }
        }

        public void nodeReverted(NodeEvent e) {
            HighlightPlugin.this.clearHighlights();
        }

        private Listeners() {
        }

        static void mav$cancelPendingActions(Listeners listeners) {
            listeners.cancelPendingActions();
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

