/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.LanguageHighlighter;
import oracle.jdevimpl.refactoring.highlight.SourceVisitor;

final class JavaHighlighter
extends LanguageHighlighter {
    public boolean canHighlight(Node node) {
        return node instanceof JavaSourceNode;
    }

    public void highlight(Context context, HighlightPlugin highlightPlugin, int selectedFrom, int selectedTo) {
        JavaSourceNode javaSourceNode = (JavaSourceNode)context.getNode();
        if (selectedFrom == selectedTo) {
            this.whenHighlight(context, highlightPlugin, javaSourceNode, selectedFrom);
        } else {
            TextBuffer textBuffer = javaSourceNode.acquireTextBuffer();
            String text = textBuffer.getString(0, textBuffer.getLength());
            String search = text.substring(selectedFrom, selectedTo);
            this.highlightText(highlightPlugin, text, search);
        }
    }

    private void highlightText(HighlightPlugin highlightPlugin, String text, String search) {
        int searchLength = search.length();
        int pos = 0;
        while ((pos = text.indexOf(search, pos)) != -1) {
            String message = MessageFormat.format(RefactoringArb.getString(121), search);
            highlightPlugin.highlight(pos, pos + searchLength, message);
            ++pos;
        }
    }

    private void whenHighlight(Context context, HighlightPlugin highlightPlugin, JavaSourceNode javaSourceNode, int caretPos) {
        URL url;
        JavaManager javaManager;
        SourceFile sourceFile;
        Project project = context.getProject();
        if (project != null && (sourceFile = (javaManager = JavaManager.getJavaManager((Project)project)).getSourceFile(url = javaSourceNode.getURL())) != null) {
            SourceVisitor visitor = new SourceVisitor(highlightPlugin, sourceFile, caretPos);
            visitor.visit((SourceElement)sourceFile);
        }
    }

    JavaHighlighter() {
    }
}

