/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.VariableHighlighter;

final class ParameterHighlighter
extends VariableHighlighter {
    private SourceMethod _sourceMethod;
    private int _paramPos;
    private final boolean _isConstructor;

    public ParameterHighlighter(HighlightPlugin highlightPlugin, SourceMethod sourceMethod, SourceVariable sourceVariable) {
        super(highlightPlugin, (JavaHasName)sourceVariable);
        this._sourceMethod = sourceMethod;
        this._paramPos = sourceMethod.getSourceParameters().indexOf(sourceVariable);
        this._isConstructor = this._sourceMethod.isConstructor();
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        String calledMethodName;
        String thisMethodName;
        if (!this._isConstructor && (thisMethodName = this._sourceMethod.getName()).equals(calledMethodName = sourceMethodCallExpression.getName())) {
            this.check((SourceInvokeExpression)sourceMethodCallExpression);
        }
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
        if (this._isConstructor) {
            this.check((SourceInvokeExpression)sourceClassCreatorExpression);
        }
    }

    private void check(SourceInvokeExpression sourceInvokeExpression) {
        SourceExpression argumentAt;
        JavaMethod resolvedCalledMethod = sourceInvokeExpression.getResolvedMethod();
        if (this._sourceMethod.equals((Object)resolvedCalledMethod) && (argumentAt = sourceInvokeExpression.getArgumentAt(this._paramPos)) != null) {
            this.highlight((SourceElement)argumentAt, RefactoringArb.getString(250));
        }
    }
}

