/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.util.Visitor;

class SourceVisitor
extends Visitor {
    private final SourceFile _sourceFile;
    private final int _caretPos;
    private HighlightPlugin _highlightPlugin;

    public SourceVisitor(HighlightPlugin highlightPlugin, SourceFile sourceFile, int caretPos) {
        this._highlightPlugin = highlightPlugin;
        this._sourceFile = sourceFile;
        this._caretPos = caretPos;
    }

    private void scopeResolved(SourceElement sourceElement) {
        int to;
        int from;
        if (sourceElement != null) {
            from = sourceElement.getStartOffset();
            to = sourceElement.getEndOffset();
        } else {
            to = -1;
            from = -1;
        }
        this.scopeResolved(from, to);
    }

    private void scopeResolved(int from, int to) {
        super.cancel();
    }

    public void visit(SourceElement sourceElement) {
        if (Patch.contains(sourceElement, this._caretPos)) {
            super.visit(sourceElement);
        }
    }

    private SourceElement getScope(SourceVariable sourceLocalVariable) {
        SourceElement scope;
        switch (sourceLocalVariable.getSymbolKind()) {
            case 17: {
                SourceLocalVariable local = (SourceLocalVariable)sourceLocalVariable;
                scope = local.getOwningBlock();
                break;
            }
            case 13: {
                scope = Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceLocalVariable);
                break;
            }
            default: {
                scope = null;
                break;
            }
        }
        return scope;
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        SourceName nameElement = sourceMethodCallExpression.getNameElement();
        if (Patch.contains((SourceElement)nameElement, this._caretPos)) {
            JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
            if (resolvedMethod != null) {
                this._highlightPlugin.highlightMethod(this._sourceFile, resolvedMethod);
            }
            this.scopeResolved((SourceElement)nameElement);
        }
    }

    protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
        SourceName nameElement = sourceMethod.getNameElement();
        if (nameElement != null && Patch.contains((SourceElement)nameElement, this._caretPos)) {
            this._highlightPlugin.highlightMethod(this._sourceFile, (JavaMethod)sourceMethod);
            this.scopeResolved((SourceElement)nameElement);
        } else {
            SourceTypeReference sourceReturnType = sourceMethod.getSourceReturnType();
            if (sourceReturnType != null && Patch.contains((SourceElement)sourceReturnType, this._caretPos)) {
                this._highlightPlugin.highlightReturns(sourceMethod);
                this.scopeResolved((SourceElement)sourceReturnType);
            }
        }
    }

    protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
        SourceName nameElement = sourceMethod.getNameElement();
        if (nameElement != null && Patch.contains((SourceElement)nameElement, this._caretPos)) {
            this._highlightPlugin.highlightConstructor(this._sourceFile, (JavaMethod)sourceMethod);
            this.scopeResolved((SourceElement)nameElement);
        }
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
        JavaMethod resolvedMethod;
        SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
        if (sourceType != null && Patch.contains((SourceElement)sourceType, this._caretPos) && (resolvedMethod = sourceClassCreatorExpression.getResolvedMethod()) != null) {
            this._highlightPlugin.highlightConstructor(this._sourceFile, resolvedMethod);
            this.scopeResolved((SourceElement)sourceType);
        }
    }

    protected void whenEnterClass(SourceClass sourceClass) {
        block1: {
            int startOffset;
            int token;
            int endOffset;
            SourceName nameElement;
            block2: {
                nameElement = sourceClass.getNameElement();
                if (nameElement == null) break block1;
                if (!Patch.contains((SourceElement)nameElement, this._caretPos)) break block2;
                JavaType[] javaTypes = new JavaType[]{sourceClass};
                this._highlightPlugin.highlightResolvedTypes(this._sourceFile, javaTypes);
                this.scopeResolved((SourceElement)nameElement);
                break block1;
            }
            if (this._caretPos >= nameElement.getStartOffset()) break block1;
            JavaLexer javaLexer = new JavaLexer();
            javaLexer.setTextBuffer((ReadTextBuffer)sourceClass.getOwningSourceFile().getTextBuffer());
            javaLexer.setPosition(sourceClass.getStartOffset());
            do {
                token = javaLexer.lex();
                startOffset = javaLexer.getStartOffset();
                endOffset = javaLexer.getEndOffset();
                if (this._caretPos < startOffset) break block1;
            } while (this._caretPos > endOffset || token != 103);
            this._highlightPlugin.highlightClassDeclarations(this._sourceFile);
            this.scopeResolved(startOffset, endOffset);
        }
    }

    protected void whenEnterThrowsClause(SourceThrowsClause sourceThrowsClause) {
        boolean caretIsOnType = false;
        List sourceExceptions = sourceThrowsClause.getSourceExceptions();
        int i = 0;
        while (!caretIsOnType && i < sourceExceptions.size()) {
            SourceTypeReference sourceType = (SourceTypeReference)sourceExceptions.get(i);
            if (Patch.contains((SourceElement)sourceType, this._caretPos)) {
                caretIsOnType = true;
            }
            ++i;
        }
        if (!caretIsOnType) {
            ArrayList<JavaType> resolvedTypes = new ArrayList<JavaType>();
            for (SourceTypeReference sourceTypeReference : sourceExceptions) {
                JavaType resolvedType = sourceTypeReference.getResolvedType();
                resolvedTypes.add(resolvedType);
            }
            SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceThrowsClause);
            JavaType[] javaTypes = resolvedTypes.toArray(new JavaType[resolvedTypes.size()]);
            this._highlightPlugin.highlightThrows((SourceElement)sourceMethod, javaTypes);
            this._highlightPlugin.highlight((SourceElement)sourceThrowsClause, RefactoringArb.getString(277));
            this.scopeResolved(null);
        }
    }

    protected void whenEnterCatchStatement(SourceCatchClause sourceCatchClause) {
        SourceVariable catchVariable = sourceCatchClause.getCatchVariable();
        try {
            SourceStatement catchBlock;
            SourceName variableNameElement = catchVariable.getNameElement();
            if (!Patch.contains((SourceElement)variableNameElement, this._caretPos) && !Patch.contains((SourceElement)(catchBlock = sourceCatchClause.getPrimaryClause()), this._caretPos)) {
                SourceTypeReference sourceType = catchVariable.getSourceType();
                JavaType resolvedType = sourceType.getResolvedType();
                SourceTryStatement owningTry = sourceCatchClause.getOwningTry();
                SourceStatement primaryClause = owningTry.getPrimaryClause();
                this._highlightPlugin.highlightThrows((SourceElement)primaryClause, resolvedType);
                SourceElement sourceFormalParameters = catchVariable.getParent();
                String string = MessageFormat.format(RefactoringArb.getString(227), resolvedType.getQualifiedName());
                this._highlightPlugin.highlight(sourceCatchClause.getStartOffset(), sourceFormalParameters.getEndOffset(), string);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
        if (resolvedObject != null) {
            switch (resolvedObject.getElementKind()) {
                case 5: {
                    JavaField javaField = (JavaField)resolvedObject;
                    this._highlightPlugin.highlightVariable((SourceElement)this._sourceFile, (JavaHasName)javaField);
                    this.scopeResolved((SourceElement)sourceSimpleNameExpression);
                    break;
                }
                case 7: {
                    SourceElement scope;
                    JavaLocalVariable javaLocalVariable = (JavaLocalVariable)resolvedObject;
                    SourceVariable sourceLocalVariable = (SourceVariable)javaLocalVariable.getSourceElement();
                    if (sourceLocalVariable != null && (scope = this.getScope(sourceLocalVariable)) != null) {
                        this._highlightPlugin.highlightVariable(scope, (JavaHasName)sourceLocalVariable);
                    }
                    this.scopeResolved((SourceElement)sourceSimpleNameExpression);
                    break;
                }
                case 3: {
                    JavaClass javaClass = (JavaClass)resolvedObject;
                    this._highlightPlugin.highlightResolvedTypes(this._sourceFile, new JavaType[]{javaClass});
                    this.scopeResolved((SourceElement)sourceSimpleNameExpression);
                    break;
                }
            }
        }
    }

    protected void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
        SourceName nameElement = sourceLocalVariable.getNameElement();
        if (Patch.contains((SourceElement)nameElement, this._caretPos)) {
            SourceElement scope = this.getScope((SourceVariable)sourceLocalVariable);
            if (scope != null) {
                this._highlightPlugin.highlightVariable(scope, (JavaHasName)sourceLocalVariable);
            }
            this.scopeResolved((SourceElement)nameElement);
        }
    }

    protected void whenEnterFormalParameter(SourceVariable sourceVariable) {
        SourceName nameElement = sourceVariable.getNameElement();
        if (Patch.contains((SourceElement)nameElement, this._caretPos)) {
            SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
            this._highlightPlugin.highlightParameter(sourceMethod, sourceVariable);
            this.scopeResolved((SourceElement)nameElement);
        }
    }

    protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
        SourceName nameElement = sourceFieldVariable.getNameElement();
        if (Patch.contains((SourceElement)nameElement, this._caretPos)) {
            SourceFile sourceFile = sourceFieldVariable.getOwningSourceFile();
            this._highlightPlugin.highlightVariable((SourceElement)sourceFile, (JavaHasName)sourceFieldVariable);
            this.scopeResolved((SourceElement)nameElement);
        }
    }

    protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
        JavaHasType resolvedObject = sourceDotExpression.getResolvedObject();
        if (resolvedObject != null && Patch.contains((SourceElement)sourceDotExpression.getNameElement(), this._caretPos) && resolvedObject.getElementKind() == 5) {
            JavaField javaField = (JavaField)resolvedObject;
            this._highlightPlugin.highlightVariable((SourceElement)this._sourceFile, (JavaHasName)javaField);
            this.scopeResolved((SourceElement)sourceDotExpression);
        }
    }

    protected void whenEnterReturnStatement(SourceReturnStatement sourceReturnStatement) {
        SourceMethod sourceMethod;
        SourceExpression sourceExpression = sourceReturnStatement.getExpression();
        if (!(sourceExpression != null && Patch.contains((SourceElement)sourceExpression, this._caretPos) || (sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceReturnStatement)) == null)) {
            this._highlightPlugin.highlightReturns(sourceMethod);
            this.scopeResolved((SourceElement)sourceExpression);
        }
    }

    protected void whenEnterTypeRef(SourceTypeReference sourceType) {
        SourceElement parent = sourceType.getParent();
        switch (parent.getSymbolKind()) {
            case 15: 
            case 22: {
                this.highlightSuperAspect(sourceType);
                this.scopeResolved((SourceElement)sourceType);
                break;
            }
            case 24: {
                SourceMethod sourceMethod;
                JavaType resolvedType = sourceType.getResolvedType();
                if (resolvedType == null || (sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceType)) == null) break;
                this._highlightPlugin.highlightThrows((SourceElement)sourceMethod, resolvedType);
                String message = MessageFormat.format(RefactoringArb.getString(195), resolvedType.getQualifiedName());
                this._highlightPlugin.highlight((SourceElement)sourceType, message);
                this.scopeResolved((SourceElement)sourceType);
                break;
            }
            default: {
                JavaType resolvedType = sourceType.getResolvedType();
                if (resolvedType == null) break;
                this._highlightPlugin.highlightResolvedTypes(this._sourceFile, new JavaType[]{resolvedType});
                this.scopeResolved((SourceElement)sourceType);
            }
        }
    }

    protected void whenEnterImportDeclaration(SourceImport sourceImport) {
        if (!sourceImport.isStatic()) {
            String name = sourceImport.getName();
            if (name.endsWith(".*")) {
                String packageName = name.substring(0, name.length() - 2);
                JavaProvider provider = this._sourceFile.getProvider();
                JavaPackage javaPackage = provider.getPackage(packageName);
                this._highlightPlugin.highlightPackage(this._sourceFile, javaPackage);
            } else {
                SourceFile owningFile = sourceImport.getOwningSourceFile();
                JavaProvider provider = owningFile.getProvider();
                JavaClass javaClass = provider.getClass(name);
                if (javaClass != null) {
                    this._highlightPlugin.highlightResolvedTypes(this._sourceFile, new JavaType[]{javaClass});
                }
            }
        }
        this.scopeResolved((SourceElement)sourceImport);
    }

    protected void whenEnterAnnotation(SourceAnnotation sourceAnnotation) {
        JavaType resolvedType;
        SourceName nameElement = sourceAnnotation.getNameElement();
        if (Patch.contains((SourceElement)nameElement, this._caretPos) && (resolvedType = sourceAnnotation.getResolvedType()) != null) {
            this._highlightPlugin.highlightAnnotation(this._sourceFile, resolvedType);
        }
    }

    private void highlightSuperAspect(SourceTypeReference sourceType) {
        JavaType resolvedType = sourceType.getResolvedType();
        if (resolvedType != null) {
            SourceClass sourceClass = (SourceClass)Util.getAncestorOfClass(SourceClass.class, (SourceElement)sourceType);
            String string = MessageFormat.format(RefactoringArb.getString(64), resolvedType.getName(), sourceClass.getName());
            this._highlightPlugin.highlight((SourceElement)sourceType, string);
            this._highlightPlugin.highlightSuperAspect(sourceClass, resolvedType);
        }
    }
}

