/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.DefaultHighlighter;

public final class AnnotationHighlighter
extends DefaultHighlighter {
    private JavaType _javaType;
    private String _name;
    private String _qualifiedName;

    public AnnotationHighlighter(HighlightPlugin highlightPlugin, JavaType javaType) {
        super(highlightPlugin);
        this._javaType = javaType;
        this._name = this._javaType.getName();
        this._qualifiedName = this._javaType.getQualifiedName();
    }

    protected void whenEnterAnnotation(SourceAnnotation sourceAnnotation) {
        JavaType resolvedType;
        String name = sourceAnnotation.getName();
        if (this._name.endsWith(name) && this._javaType.equals((Object)(resolvedType = sourceAnnotation.getResolvedType()))) {
            SourceName nameElement = sourceAnnotation.getNameElement();
            String message = MessageFormat.format(RefactoringArb.getString(156), this._qualifiedName);
            this.highlight((SourceElement)nameElement, message);
        }
    }
}

