/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.DefaultHighlighter;

public final class ConstructorHighlighter
extends DefaultHighlighter {
    private JavaMethod _searchedMethod;
    private String _fullMethodName;

    public ConstructorHighlighter(HighlightPlugin highlightPlugin, JavaMethod searchedMethod) {
        super(highlightPlugin);
        this._searchedMethod = searchedMethod;
        this._fullMethodName = Util.getFullMethodName(this._searchedMethod, false, false, false);
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
        JavaMethod resolvedMethod = sourceClassCreatorExpression.getResolvedMethod();
        if (this._searchedMethod.equals((Object)resolvedMethod)) {
            SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
            String string = MessageFormat.format(RefactoringArb.getString(54), this._fullMethodName);
            this.highlight((SourceElement)sourceType, string);
        }
    }

    protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
        if (this._searchedMethod.equals((Object)sourceMethod)) {
            SourceName nameElement = sourceMethod.getNameElement();
            String string = MessageFormat.format(RefactoringArb.getString(62), this._fullMethodName);
            this.highlight((SourceElement)nameElement, string);
        }
    }
}

