/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.util.Visitor;

class DefaultHighlighter
extends Visitor {
    private HighlightPlugin _HighlightPlugin;

    protected DefaultHighlighter(HighlightPlugin HighlightPlugin2) {
        this._HighlightPlugin = HighlightPlugin2;
    }

    protected void highlight(SourceElement sourceElement, String tooltip) {
        this._HighlightPlugin.highlight(sourceElement, tooltip);
    }

    protected void checkImportDeclaration(SourceImport sourceImport, JavaType[] javaTypes) {
        JavaType higlight = null;
        String name = sourceImport.getName();
        if (name.endsWith("*")) {
            String importedPkg = name.substring(0, name.length() - 2);
            int i = 0;
            while (higlight == null && i < javaTypes.length) {
                JavaType javaType = javaTypes[i];
                String packageName = javaType.getPackageName();
                if (packageName.equals(importedPkg)) {
                    higlight = javaType;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (higlight == null && i < javaTypes.length) {
                JavaType javaType = javaTypes[i];
                if (javaType.getQualifiedName().equals(name)) {
                    higlight = javaType;
                }
                ++i;
            }
        }
        if (higlight != null) {
            String string = MessageFormat.format(RefactoringArb.getString(58), higlight.getQualifiedName());
            this.highlight((SourceElement)sourceImport.getNameElement(), string);
        }
    }
}

