/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.DefaultHighlighter;

public final class MethodHighlighter
extends DefaultHighlighter {
    private String _searchedMethodName;
    private JavaMethod _searchedMethod;
    private String _fullMethodName;

    public MethodHighlighter(HighlightPlugin highlightPlugin, JavaMethod searchedMethod) {
        super(highlightPlugin);
        this._searchedMethod = searchedMethod;
        this._searchedMethodName = searchedMethod.getName();
        this._fullMethodName = Util.getFullMethodName(searchedMethod, true, false, false);
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        JavaMethod resolvedMethod;
        String methodName = sourceMethodCallExpression.getName();
        if (this._searchedMethodName.equals(methodName) && (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()) != null && this._searchedMethod.equals((Object)resolvedMethod)) {
            SourceName nameElement = sourceMethodCallExpression.getNameElement();
            String string = MessageFormat.format(RefactoringArb.getString(54), this._fullMethodName);
            this.highlight((SourceElement)nameElement, string);
        }
    }

    protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
        String methodName = sourceMethod.getName();
        if (this._searchedMethodName.equals(methodName) && this._searchedMethod.equals((Object)sourceMethod)) {
            SourceName nameElement = sourceMethod.getNameElement();
            String tooltip = MessageFormat.format(RefactoringArb.getString(62), this._fullMethodName);
            this.highlight((SourceElement)nameElement, tooltip);
        }
    }
}

