/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.TypeHighlighter;

public final class PackageHighlighter
extends TypeHighlighter {
    private String _packageName;
    private String _packageNameDot;

    public PackageHighlighter(HighlightPlugin highlighPlugin, JavaPackage javaPackage) {
        super(highlighPlugin);
        this._packageName = javaPackage.getName();
        this._packageNameDot = this._packageName + '.';
    }

    protected boolean matches(SourceTypeReference sourceType) {
        JavaType resolvedType = sourceType.getResolvedType();
        if (resolvedType != null) {
            String thatName = resolvedType.getPackageName();
            if (this._packageName.equals(thatName)) {
                return true;
            }
            if (thatName.startsWith(this._packageNameDot)) {
                return true;
            }
        }
        return false;
    }

    protected void whenEnterImportDeclaration(SourceImport sourceImport) {
        String name;
        if (!sourceImport.isStatic() && (name = sourceImport.getName()).startsWith(this._packageNameDot)) {
            SourceName nameElement = sourceImport.getNameElement();
            String tooltip = MessageFormat.format(RefactoringArb.getString(156), this._packageName);
            this.highlight((SourceElement)nameElement, tooltip);
        }
    }
}

