/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.TypeHighlighter;

public final class ResolvedTypeHighlighter
extends TypeHighlighter {
    private JavaType[] _javaTypes;
    private String[] _shortNames;

    public ResolvedTypeHighlighter(HighlightPlugin highlightPlugin, JavaType javaType) {
        this(highlightPlugin, new JavaType[]{javaType});
    }

    public ResolvedTypeHighlighter(HighlightPlugin highlightPlugin, JavaType[] javaTypes) {
        super(highlightPlugin);
        this._javaTypes = javaTypes;
        this._shortNames = new String[javaTypes.length];
        int i = 0;
        while (i < javaTypes.length) {
            JavaType javaType = javaTypes[i];
            this._shortNames[i] = javaType.getName();
            ++i;
        }
    }

    protected boolean matches(SourceTypeReference sourceType) {
        String name = sourceType.getName();
        String[] stringArray = this._shortNames;
        int n = 0;
        while (n < stringArray.length) {
            JavaType resolvedType;
            String shortName = stringArray[n];
            if (name.endsWith(shortName) && this.matches(resolvedType = sourceType.getResolvedType())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean matches(JavaType resolvedType) {
        JavaType[] javaTypeArray = this._javaTypes;
        int n = 0;
        while (n < javaTypeArray.length) {
            JavaType javaType = javaTypeArray[n];
            if (javaType.equals((Object)resolvedType)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void whenEnterConstructorDeclaration(SourceMethod sourceMethod) {
        JavaClass owningClass = sourceMethod.getOwningClass();
        if (this.matches((JavaType)owningClass)) {
            SourceName nameElement = sourceMethod.getNameElement();
            String tooltip = MessageFormat.format(RefactoringArb.getString(197), owningClass.getQualifiedName());
            this.highlight((SourceElement)nameElement, tooltip);
        }
    }

    protected void whenEnterClass(SourceClass sourceClass) {
        if (this.matches((JavaType)sourceClass)) {
            SourceName nameElement = sourceClass.getNameElement();
            String tooltip = MessageFormat.format(RefactoringArb.getString(62), sourceClass.getQualifiedName());
            this.highlight((SourceElement)nameElement, tooltip);
        }
    }

    protected void whenEnterImportDeclaration(SourceImport sourceImport) {
        this.checkImportDeclaration(sourceImport, this._javaTypes);
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
        if (resolvedObject != null) {
            switch (resolvedObject.getElementKind()) {
                case 3: {
                    JavaClass javaClass = (JavaClass)resolvedObject;
                    if (!this.matches((JavaType)javaClass)) break;
                    String tooltip = MessageFormat.format(RefactoringArb.getString(156), javaClass.getQualifiedName());
                    this.highlight((SourceElement)sourceSimpleNameExpression, tooltip);
                    break;
                }
            }
        }
    }
}

