/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.DefaultHighlighter;
import oracle.jdevimpl.refactoring.jotpatch.Patch;

public final class SuperAspectHighlighter
extends DefaultHighlighter {
    private JavaType _javaType;
    private JavaType _superType;
    private HashSet<String> _superTypeMemberNames;

    public SuperAspectHighlighter(HighlightPlugin highlightPlugin, JavaType javaType, JavaType superType) {
        super(highlightPlugin);
        this._javaType = javaType;
        this._superType = superType;
        this._superTypeMemberNames = new HashSet();
        Collection methods = superType.getMethods();
        for (JavaMethod javaMethod : methods) {
            String methodName = javaMethod.getName();
            this._superTypeMemberNames.add(methodName);
        }
        Collection fields = superType.getFields();
        for (JavaField javaField : fields) {
            String name = javaField.getName();
            this._superTypeMemberNames.add(name);
        }
    }

    protected void whenEnterMethodDeclaration(SourceMethod sourceMethod) {
        JavaType[] parameterTypes;
        JavaMethod declaredMethod;
        String methodName = sourceMethod.getName();
        if (this._superTypeMemberNames.contains(methodName) && (declaredMethod = this._superType.getMethod(methodName, parameterTypes = Patch.getParameterTypes((JavaMethod)sourceMethod))) != null) {
            SourceName nameElement = sourceMethod.getNameElement();
            String fullMethodName = Util.getFullMethodName(declaredMethod, false, false, false);
            String tooltip = MessageFormat.format(RefactoringArb.getString(94), this._superType.getQualifiedName(), fullMethodName);
            this.highlight((SourceElement)nameElement, tooltip);
        }
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        JavaMethod resolvedMethod;
        String methodName = sourceMethodCallExpression.getName();
        if (this._superTypeMemberNames.contains(methodName) && (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()) != null) {
            JavaType[] parameterTypes = resolvedMethod.getParameterTypes();
            JavaMethod superMethod = this._superType.getMethod(resolvedMethod.getName(), parameterTypes);
            if (superMethod != null) {
                JavaClass owningClass = superMethod.getOwningClass();
                String owningClassName = owningClass.getQualifiedName();
                if (!"java.lang.Object".equals(owningClassName)) {
                    SourceName methodNameElement = sourceMethodCallExpression.getNameElement();
                    this.highlightUsedAs((SourceElement)methodNameElement);
                }
            } else {
                int i = 0;
                while (i < parameterTypes.length) {
                    String fqArgTypeName;
                    JavaType argType;
                    SourceExpression argumentAt;
                    String parameterTypeName;
                    JavaType parameterType = parameterTypes[i];
                    if (parameterType != null && !"java.lang.Object".equals(parameterTypeName = parameterType.getQualifiedName()) && parameterType.isAssignableFrom(this._superType) && (argumentAt = sourceMethodCallExpression.getArgumentAt(i)) != null && (argType = argumentAt.getResolvedType()) != null && !"null".equals(fqArgTypeName = argType.getQualifiedName()) && this._javaType.isAssignableFrom(argType)) {
                        this.highlightUsedAs((SourceElement)argumentAt);
                    }
                    ++i;
                }
            }
        }
    }

    protected void whenEnterAssignmentExpression(SourceAssignmentExpression sourceAssignmentExpression) {
        SourceExpression assignTo = sourceAssignmentExpression.getFirstOperand();
        JavaType assignToType = assignTo.getResolvedType();
        SourceExpression assignedFrom = sourceAssignmentExpression.getSecondOperand();
        this.checkAssign(assignToType, assignedFrom);
    }

    protected void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
        JavaType assignToType = sourceLocalVariable.getResolvedType();
        SourceExpression assignedFrom = sourceLocalVariable.getInitializer();
        this.checkAssign(assignToType, assignedFrom);
    }

    protected void whenEnterReturnStatement(SourceReturnStatement sourceReturnStatement) {
        SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceReturnStatement);
        JavaType returnType = sourceMethod.getReturnType();
        SourceExpression returnedExpression = sourceReturnStatement.getExpression();
        this.checkAssign(returnType, returnedExpression);
    }

    protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
        JavaField javaField;
        JavaClass owningClass;
        JavaHasType resolvedObject;
        String dotName = sourceDotExpression.getName();
        if (this._superTypeMemberNames.contains(dotName) && (resolvedObject = sourceDotExpression.getResolvedObject()) instanceof JavaField && (owningClass = (javaField = (JavaField)resolvedObject).getOwningClass()) != null && owningClass.isAssignableFrom(this._superType)) {
            this.highlightUsedAs((SourceElement)sourceDotExpression);
        }
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaField javaField;
        JavaClass owningClass;
        JavaHasType resolvedObject;
        String dotName = sourceSimpleNameExpression.getName();
        if (this._superTypeMemberNames.contains(dotName) && (resolvedObject = sourceSimpleNameExpression.getResolvedObject()) instanceof JavaField && (owningClass = (javaField = (JavaField)resolvedObject).getOwningClass()) != null && owningClass.isAssignableFrom(this._superType)) {
            this.highlightUsedAs((SourceElement)sourceSimpleNameExpression);
        }
    }

    private void checkAssign(JavaType assignToType, SourceExpression assignedFrom) {
        JavaType assignedFromType;
        if (assignToType != null && assignedFrom != null && assignToType.isAssignableFrom(this._superType) && !assignToType.isAssignableFrom(this._javaType) && (assignedFromType = assignedFrom.getResolvedType()) != null && this._javaType.isAssignableFrom(assignedFromType)) {
            this.highlightUsedAs((SourceElement)assignedFrom);
            this.skipChildren();
        }
    }

    private void highlightUsedAs(SourceElement sourceElement) {
        String tooltip = MessageFormat.format(RefactoringArb.getString(229), this._javaType.getName(), this._superType.getName());
        this.highlight(sourceElement, tooltip);
    }
}

