/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.DefaultHighlighter;

public final class ThrowsHighlighter
extends DefaultHighlighter {
    private JavaType[] _javaTypes;

    public ThrowsHighlighter(HighlightPlugin highlightPlugin, JavaType javaType) {
        this(highlightPlugin, new JavaType[]{javaType});
    }

    public ThrowsHighlighter(HighlightPlugin highlightPlugin, JavaType[] javaTypes) {
        super(highlightPlugin);
        this._javaTypes = javaTypes;
    }

    private boolean isSearchedType(JavaType javaType) {
        if (javaType != null) {
            JavaType[] javaTypeArray = this._javaTypes;
            int n = 0;
            while (n < javaTypeArray.length) {
                JavaType javaType_i = javaTypeArray[n];
                if (javaType_i.isAssignableFrom(javaType)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected void whenEnterMethodCallExpression(SourceMethodCallExpression sourceMethodCallExpression) {
        SourceName nameElement = sourceMethodCallExpression.getNameElement();
        JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
        this.checkMethod(nameElement, resolvedMethod);
    }

    protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
        SourceTypeReference sourceType = sourceClassCreatorExpression.getSourceType();
        SourceName nameElement = sourceType.getNameElement();
        JavaMethod resolvedMethod = sourceClassCreatorExpression.getResolvedMethod();
        this.checkMethod(nameElement, resolvedMethod);
    }

    private void checkMethod(SourceName nameElement, JavaMethod resolvedMethod) {
        if (resolvedMethod != null) {
            Collection exceptions = resolvedMethod.getExceptions();
            for (JavaType thrownType : exceptions) {
                if (!this.isSearchedType(thrownType)) continue;
                this.highlight((SourceElement)nameElement, "throws " + thrownType.getQualifiedName());
            }
        }
    }

    protected void whenEnterTryStatement(SourceTryStatement sourceTryStatement) {
        List catchClauses = sourceTryStatement.getCatchClauses();
        boolean isCaught = false;
        Iterator iterator = catchClauses.iterator();
        while (!isCaught && iterator.hasNext()) {
            JavaType resolvedType;
            SourceTypeReference sourceType;
            SourceCatchClause sourceCatchClause = (SourceCatchClause)iterator.next();
            SourceVariable catchVariable = sourceCatchClause.getCatchVariable();
            if (catchVariable == null || (sourceType = catchVariable.getSourceType()) == null || !this.isSearchedType(resolvedType = sourceType.getResolvedType())) continue;
            isCaught = true;
        }
        if (isCaught) {
            for (SourceCatchClause sourceCatchClause : catchClauses) {
                this.visitChildren((SourceElement)sourceCatchClause);
            }
            SourceFinallyClause finallyClause = sourceTryStatement.getFinallyClause();
            if (finallyClause != null) {
                this.visitChildren((SourceElement)finallyClause);
            }
            this.skipChildren();
        }
    }

    protected void whenEnterThrowStatement(SourceThrowStatement sourceThrowStatement) {
        JavaType resolvedType;
        SourceExpression thrownExpression = sourceThrowStatement.getExpression();
        if (thrownExpression != null && (resolvedType = thrownExpression.getResolvedType()) != null && this.isSearchedType(resolvedType)) {
            this.highlight((SourceElement)sourceThrowStatement, "throws " + resolvedType.getQualifiedName());
        }
    }
}

