/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.highlight.highlighters;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.highlight.HighlightPlugin;
import oracle.jdevimpl.refactoring.highlight.highlighters.DefaultHighlighter;

public class VariableHighlighter
extends DefaultHighlighter {
    private final String _searchedName;
    private final JavaHasName _searchedElement;
    private String _tooltip;

    public VariableHighlighter(HighlightPlugin highlightPlugin, JavaHasName searchedElement) {
        super(highlightPlugin);
        this._searchedName = searchedElement.getName();
        this._searchedElement = searchedElement;
        this._tooltip = MessageFormat.format(RefactoringArb.getString(156), this._searchedName);
    }

    private void whenVariableFound(SourceVariable sourceVariable) {
        String name = sourceVariable.getName();
        if (this._searchedName.equals(name) && this._searchedElement.equals(sourceVariable)) {
            SourceName nameElement = sourceVariable.getNameElement();
            this.highlight((SourceElement)nameElement, this._tooltip);
        }
    }

    protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
        JavaHasType resolvedObject;
        String name = sourceSimpleNameExpression.getName();
        if (this._searchedName.equals(name) && this._searchedElement.equals(resolvedObject = sourceSimpleNameExpression.getResolvedObject())) {
            SourceName nameElement = sourceSimpleNameExpression.getNameElement();
            this.highlight((SourceElement)nameElement, this._tooltip);
        }
    }

    protected void whenEnterLocalVariable(SourceLocalVariable sourceLocalVariable) {
        this.whenVariableFound((SourceVariable)sourceLocalVariable);
    }

    protected void whenEnterFormalParameter(SourceVariable sourceVariable) {
        this.whenVariableFound(sourceVariable);
    }

    protected void whenEnterFieldVariable(SourceFieldVariable sourceFieldVariable) {
        this.whenVariableFound((SourceVariable)sourceFieldVariable);
    }

    protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
        JavaField javaField;
        JavaHasType resolvedObject;
        String dotName;
        SourceName nameElement = sourceDotExpression.getNameElement();
        if (nameElement != null && this._searchedName.equals(dotName = nameElement.getName()) && (resolvedObject = sourceDotExpression.getResolvedObject()) instanceof JavaField && this._searchedElement.equals(javaField = (JavaField)resolvedObject)) {
            this.highlight((SourceElement)nameElement, this._tooltip);
        }
    }
}

