/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.image;

import java.net.URL;
import javax.swing.JDialog;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.ImageNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.refactoring.criteria.MoveFilesCriteria;
import oracle.jdeveloper.refactoring.dialogs.SafeDeleteFailedDialog;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.oprs.safedelete.IdeSafeDeleteCommand;
import oracle.jdevimpl.refactoring.preview.UsagesLogPage;

public class ImageRefactoringController
implements Controller,
IdeSafeDeleteCommand {
    public static int[] getRefactoringActions() {
        return new int[]{RefactoringManager.RENAME_CMD_ID, RefactoringManager.SAFE_DELETE_CMD_ID};
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Node node = context.getNode();
        if (node instanceof ImageNode) {
            int commandID = action.getCommandId();
            if (commandID == RefactoringManager.RENAME_CMD_ID) {
                this.fireIdeRenameFileCommand();
                return true;
            }
            if (commandID == RefactoringManager.SAFE_DELETE_CMD_ID) {
                this.fireSafeDeleteFileCommand(context, node);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int commandID;
        Node node = context.getNode();
        if (node instanceof ImageNode && ((commandID = action.getCommandId()) == RefactoringManager.RENAME_CMD_ID || commandID == RefactoringManager.SAFE_DELETE_CMD_ID)) {
            return Util.canRefactor(node.getURL());
        }
        return false;
    }

    public boolean canSafeDelete(Context context, URL url) {
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (InstantiationException e) {
            Assert.printStackTrace((Throwable)e);
        }
        return node != null && node instanceof ImageNode;
    }

    public boolean safeDeleteFile(Context context, URL url) {
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (IllegalAccessException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (InstantiationException e) {
            Assert.printStackTrace((Throwable)e);
        }
        if (node != null && node instanceof ImageNode) {
            this.fireSafeDeleteFileCommand(context, node);
            return true;
        }
        return false;
    }

    private void fireIdeRenameFileCommand() {
        IdeAction action = IdeAction.find((int)14);
        try {
            action.performAction();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void removeFileFromDisk(URL url) {
        if (URLFileSystem.canDelete((URL)url)) {
            URLFileSystem.delete((URL)url);
        } else {
            URLFileSystem.setReadOnly((URL)url, (boolean)false);
        }
    }

    private void fireSafeDeleteFileCommand(Context context, Node node) {
        MoveFilesCriteria criteria = new MoveFilesCriteria(node.getLongLabel(), "Usages of " + node.getShortLabel());
        URL url = node.getURL();
        criteria.moveUrl(url, null);
        SearchOperationImpl operation = new SearchOperationImpl(context, criteria);
        if (operation.doSearch()) {
            SafeDeleteFailedDialog dialog = new SafeDeleteFailedDialog(node.getLongLabel(), "f1_jrf_ddelete_html");
            if (WizardLauncher.runDialog((JDialog)((Object)dialog))) {
                if (dialog.isIgnorePressed()) {
                    this.removeFileFromDisk(url);
                } else {
                    UsagesLogPage.showUsages(operation, false);
                }
            }
        } else {
            this.removeFileFromDisk(url);
        }
    }
}

