/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.jotpatch;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.BitField;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.SearchClassCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;
import oracle.jdevimpl.refactoring.util.Visitor;

public class Patch {
    public static JavaType[] javaHasTypes2JavaTypes(Collection javaHasTypes) {
        JavaType[] ret = new JavaType[javaHasTypes.size()];
        Iterator iterator = javaHasTypes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            JavaHasType javaHasType = (JavaHasType)iterator.next();
            ret[i] = javaHasType.getResolvedType();
            ++i;
        }
        return ret;
    }

    public static JavaType[] typeNames2JavaTypes(JavaProvider javaProvider, String[] typeNames) {
        JavaType[] paramTypes = new JavaType[typeNames.length];
        int i = 0;
        while (i < typeNames.length) {
            String paramTypeName = typeNames[i];
            paramTypes[i] = javaProvider.getClass(paramTypeName);
            ++i;
        }
        return paramTypes;
    }

    public static JavaType[] getParameterTypes(JavaMethod method) {
        Collection parameters = method.getParameters();
        return Patch.javaHasTypes2JavaTypes(parameters);
    }

    public static JavaMethod getJavaMethod(JavaType javaType, String name, JavaType[] javaTypes) {
        JavaMethod declaredJavaMethod = Patch.getDeclaredJavaMethod(javaType, name, javaTypes);
        if (declaredJavaMethod != null) {
            return declaredJavaMethod;
        }
        Set hierarchy = javaType.getHierarchy();
        for (JavaType type : hierarchy) {
            JavaMethod declaredJavaMethod2 = Patch.getDeclaredJavaMethod(type, name, javaTypes);
            if (declaredJavaMethod2 == null) continue;
            return declaredJavaMethod2;
        }
        return null;
    }

    public static JavaMethod getDeclaredJavaMethod(JavaType javaType, String name, JavaType[] javaTypes) {
        Collection javaMethods = javaType.getDeclaredMethods();
        for (JavaMethod javaMethod : javaMethods) {
            String thisName = javaMethod.getName();
            if (!name.equals(thisName) || !CommonUtilities.matchMethod((JavaMethod)javaMethod, (JavaType[])javaTypes)) continue;
            return javaMethod;
        }
        return null;
    }

    public static boolean contains(SourceElement sourceElement, int position) {
        boolean ret = false;
        if (sourceElement != null && sourceElement.getStartOffset() <= position && position <= sourceElement.getEndOffset()) {
            ret = true;
        }
        return ret;
    }

    public static boolean contains(SourceElement parentSourceElement, SourceElement childSourceElement) {
        SourceFile childFile;
        SourceFile parentFile;
        boolean ret = false;
        if (childSourceElement != null && (parentFile = parentSourceElement.getOwningSourceFile()) != null && parentFile.equals(childFile = childSourceElement.getOwningSourceFile()) && Patch.contains(parentSourceElement, childSourceElement.getStartOffset())) {
            ret = true;
        }
        return ret;
    }

    public static SourceClass getSourceClass(SourceFile sourceFile, String className) {
        return (SourceClass)Patch.getNamedObject(sourceFile.getSourceClasses(), className);
    }

    public static SourceHasName getNamedObject(Collection hasNameCollection, String searchedName) {
        for (SourceHasName sourceHasName : hasNameCollection) {
            String name = sourceHasName.getName();
            if (!searchedName.equals(name)) continue;
            return sourceHasName;
        }
        return null;
    }

    public static String getMinimumReferenceName(SourceFile sourceFile, String type) {
        JavaProvider provider = sourceFile.getProvider();
        JavaClass javaType = provider.getClass(type);
        if (javaType != null && !javaType.isPrimitive()) {
            String typePackageName = javaType.getPackageName();
            if (!typePackageName.equals(sourceFile.getPackageName())) {
                List imports = sourceFile.getSourceImports();
                for (SourceImport sourceImport : imports) {
                    String importedPackage;
                    String name;
                    if (sourceImport.isStatic() || !((name = sourceImport.getName()).endsWith(".*") ? typePackageName.equals(importedPackage = name.substring(0, name.length() - 2)) : type.equals(name))) continue;
                    return javaType.getName();
                }
            } else {
                return javaType.getName();
            }
        }
        return type;
    }

    public static String getText(SourceElement sourceElement) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        URL url = sourceFile.getURL();
        TextNode textNode = (TextNode)NodeFactory.find((URL)url);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        int startOffset = sourceElement.getStartOffset();
        String string = textBuffer.getString(startOffset, sourceElement.getEndOffset() - startOffset);
        return string;
    }

    public static boolean isAssignment(int operatorCode) {
        switch (operatorCode) {
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 52: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public static String getShortName(JavaType javaType) {
        String paramType;
        if (!javaType.isArray()) {
            paramType = !javaType.isPrimitive() ? javaType.getName() : javaType.getQualifiedName();
        } else {
            JavaType componentTypeInfo = javaType.getComponentType();
            paramType = Patch.getShortName(componentTypeInfo) + "[]";
        }
        return paramType;
    }

    public static String getTypeName(SourceTypeReference sourceType) {
        String name = sourceType.getName();
        int arrayDimension = sourceType.getArrayDimension();
        int i = 0;
        while (i < arrayDimension) {
            name = name + "[]";
            ++i;
        }
        return name;
    }

    public static SourceClass getMainClass(SourceFile sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        List classes = sourceFile.getSourceClasses();
        URL sourceURL = sourceFile.getURL();
        String baseName = URLFileSystem.getName((URL)sourceURL);
        for (SourceClass sourceClass : classes) {
            String name = sourceClass.getName();
            if (!baseName.equals(name)) continue;
            return sourceClass;
        }
        return null;
    }

    public static SourceClass[] getSubClasses(Context context, SourceClass sourceClass) {
        ArrayList implementingClasses = new ArrayList();
        SearchClassCriteria searchClassCriteria = new SearchClassCriteria(ClassDescription.createClassDescription((JavaClass)sourceClass), false, false);
        searchClassCriteria.setInclude(false, false, false, false, false, true);
        Project project = context.getProject();
        SearchOperationImpl searchOperation = new SearchOperationImpl(context, searchClassCriteria);
        SearchResults searchResults = searchOperation.search();
        UsageModel usageModel = searchResults.getUsageModel();
        ArrayList usageEntries = usageModel.getUsageEntries();
        HashSet<URL> urls = new HashSet<URL>();
        int i = 0;
        while (i < usageEntries.size()) {
            UsageEntry usageEntry = (UsageEntry)usageEntries.get(i);
            TextNode textNode = usageEntry.getTextNode();
            URL url = textNode.getURL();
            urls.add(url);
            ++i;
        }
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        for (URL url : urls) {
            SourceFile sourceFile = javaManager.getSourceFile(url);
            1 visitor = new 1(sourceClass, implementingClasses);
            ((Visitor)visitor).visit((SourceElement)sourceFile);
        }
        return implementingClasses.toArray(new SourceClass[implementingClasses.size()]);
    }

    public static SourceElement getOwningBlockStatement(SourceVariable sourceVariable) {
        SourceBlock ret = null;
        switch (sourceVariable.getSymbolKind()) {
            case 13: {
                SourceMethod sourceMethod = (SourceMethod)Util.getAncestorOfClass(SourceMethod.class, (SourceElement)sourceVariable);
                ret = sourceMethod.getBlock();
                break;
            }
            case 17: {
                SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceVariable;
                ret = sourceLocalVariable.getOwningBlock();
                break;
            }
        }
        return ret;
    }

    public static boolean isPrivate(SourceHasModifiers sourceHasModifiers) {
        return BitField.isSet((int)sourceHasModifiers.getModifiers(), (int)2);
    }

    public static int getArgumentPos(SourceInvokeExpression sourceInvokeExpression, SourceElement sourceElement) {
        int argumentCount = sourceInvokeExpression.getArgumentCount();
        int i = 0;
        while (i < argumentCount) {
            SourceExpression argumentAt = sourceInvokeExpression.getArgumentAt(i);
            if (Patch.contains((SourceElement)argumentAt, sourceElement)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static SourceSuperclassClause getSuperclassClause(SourceClass sourceClass) {
        SourceSuperclassClause ret = sourceClass.getSuperclassClause();
        if (ret.getStartOffset() == -1 || ret.getEndOffset() == -1) {
            return null;
        }
        return ret;
    }

    public static SourceInterfacesClause getInterfacesClause(SourceClass sourceClass) {
        SourceInterfacesClause ret = sourceClass.getInterfacesClause();
        if (ret.getStartOffset() == -1 || ret.getEndOffset() == -1) {
            return null;
        }
        return ret;
    }

    public static void add(SourceElement parent, SourceElement child) {
        parent.getChildren().add(child);
    }

    public static SourceElement getElementAt(SourceElement sourceElement, int position) {
        if (Patch.contains(sourceElement, position)) {
            List children = sourceElement.getChildren();
            int i = 0;
            while (i < children.size()) {
                SourceElement childElement = (SourceElement)children.get(i);
                SourceElement ret = Patch.getElementAt(childElement, position);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
            return sourceElement;
        }
        return null;
    }

    static final class 1
    extends Visitor {
        private SourceClass _sourceClass;
        private final /* synthetic */ SourceClass v$sourceClass;
        private final /* synthetic */ ArrayList v$implementingClasses;

        public void visit(SourceElement sourceElement) {
            int nodeID = sourceElement.getSymbolKind();
            if (nodeID == 3) {
                SourceClass lastSourceClass = this._sourceClass;
                this._sourceClass = (SourceClass)sourceElement;
                this.visitChildren(sourceElement);
                this._sourceClass = lastSourceClass;
            } else {
                super.visit(sourceElement);
            }
        }

        protected void whenEnterTypeRef(SourceTypeReference sourceType) {
            SourceElement parent = sourceType.getParent();
            int parentSymbolKind = parent.getSymbolKind();
            if (parentSymbolKind == 22 || parentSymbolKind == 15) {
                this.whenEnterSupeType(sourceType);
            }
        }

        private void whenEnterSupeType(SourceTypeReference sourceType) {
            JavaType resolvedType = sourceType.getResolvedType();
            if (resolvedType != null && this.v$sourceClass.equals((Object)resolvedType)) {
                this.v$implementingClasses.add(this._sourceClass);
            }
        }

        public 1(SourceClass sourceClass, ArrayList arrayList) {
            this.v$implementingClasses = arrayList;
            this.v$sourceClass = sourceClass;
        }
    }
}

