/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.model;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.keyword.KeywordCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.DeterminateProgressIndicator;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.model.SearchResultsPerHandler;
import oracle.jdeveloper.refactoring.model.URLHandler;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.handlers.TextURLHandler;
import oracle.jdevimpl.refactoring.model.BasicOperation;
import oracle.jdevimpl.refactoring.model.SearchProgress;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchOperationImpl
extends BasicOperation
implements UsageSource {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = true;
    private long _totalGetIncludedProjects;
    private long _includedProjectsCount;
    private Map<URLHandler, Long> _getIncludedProjects;
    private long _totalGetIndexManager;
    private long _totalOpenProjects;
    private Map<URLHandler, Long> _chooseURL;
    private long _totalFindUsages;
    private Map<URLHandler, Long> _findUsages;
    private Project[] _projects;
    private ArrayList<String> _messages;
    private SearchResults _searchResults;
    private URL _hintFile;
    private String _hintPackage;
    private Project currentProject;
    private String _shortTitle;
    private String _longTitle;
    private boolean _userCancelled;

    private void $init$() {
        this._searchResults = new SearchResults();
    }

    public SearchOperationImpl(Context context, SearchCriteria criteria) {
        super(context, criteria);
        this.$init$();
    }

    private void addTiming(Map<URLHandler, Long> map, URLHandler urlHandler, long time) {
        Long l = map.get(urlHandler);
        if (l == null) {
            map.put(urlHandler, time);
        } else {
            map.put(urlHandler, l + time);
        }
    }

    private void publishTiming(long total) {
        System.out.println("============================================================");
        System.out.println("Refactoring timing results");
        System.out.println("  1. Project scoping  : " + this._totalGetIncludedProjects + "ms");
        System.out.println("  2. Open Projects    : " + this._totalOpenProjects + "ms");
        System.out.println("  3. Find Usages      : " + this._totalFindUsages + "ms");
        System.out.println("  Total with overhead : " + total + "ms");
        System.out.println("  Load keyword indexes: " + this._totalGetIndexManager + "ms");
        System.out.println("  Involved projects   : " + this._includedProjectsCount);
        System.out.println("Detailed timing results");
        Set<URLHandler> urlHandlers = this._getIncludedProjects.keySet();
        for (URLHandler urlHandler : urlHandlers) {
            Long findUsages;
            Long chooseURL;
            Long includedProjects = this._getIncludedProjects.get(urlHandler);
            if ((includedProjects == null ? 0L : includedProjects) + ((chooseURL = this._chooseURL.get(urlHandler)) == null ? 0L : chooseURL) + ((findUsages = this._findUsages.get(urlHandler)) == null ? 0L : findUsages) <= 0L) continue;
            System.out.println("  " + urlHandler.getClass().getName());
            System.out.println("    1. Project scoping : " + (includedProjects == null ? "-" : includedProjects + "ms"));
            System.out.println("    2. Choose URL      : " + (chooseURL == null ? "-" : chooseURL + "ms"));
            System.out.println("    3. Find Usages     : " + (findUsages == null ? "-" : findUsages + "ms"));
        }
    }

    public void addMessage(String message) {
        if (this._messages == null) {
            this._messages = new ArrayList(2);
        }
        this._messages.add(message);
    }

    @Override
    public boolean canSearch() {
        boolean ret = false;
        SearchCriteria criteria = this.getCriteria();
        if (criteria != null && criteria.isValid()) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean doSearch() {
        return this.search().isEmtpy() ^ true;
    }

    public SearchResults search() {
        long t0 = System.currentTimeMillis();
        SearchProgress searchProgress = new SearchProgress(this);
        searchProgress.start();
        long t1 = System.currentTimeMillis();
        this.publishTiming(t1 - t0);
        return this.getSearchResults();
    }

    public void doSearch(ProgressIndicator searchProgress) {
        RefManagerImpl refManager = RefManagerImpl.getImplInstance();
        RefactoringEvent event = new RefactoringEvent(1, this);
        refManager.fireRefEvent(event);
        long t0 = System.currentTimeMillis();
        this._totalFindUsages = 0L;
        this._totalGetIncludedProjects = 0L;
        this._getIncludedProjects = new HashMap<URLHandler, Long>();
        this._chooseURL = new HashMap<URLHandler, Long>();
        this._findUsages = new HashMap<URLHandler, Long>();
        Project[] projects = this.findAffectedProjects(searchProgress);
        this._includedProjectsCount = projects.length;
        long t1 = System.currentTimeMillis();
        this._totalGetIncludedProjects = t1 - t0;
        if (this._messages == null) {
            this.setProjects(projects);
            this.searchResults(searchProgress);
        }
        this.showMessages();
    }

    public SearchResults getSearchResults() {
        return this._searchResults;
    }

    @Override
    public UsageModel getUsageModel() {
        return this._searchResults.getUsageModel();
    }

    private void showMessages() {
        if (this._messages != null && !this._messages.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            while (i < this._messages.size()) {
                String text = this._messages.get(i);
                stringBuffer.append(text);
                stringBuffer.append("\n");
                ++i;
            }
            JTextArea textArea = new JTextArea(stringBuffer.toString(), 20, 80);
            textArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), RefactoringArb.getString(221), 1);
            dialog.setContent((Component)scrollPane);
            dialog.runDialog();
        }
    }

    private Project[] findAffectedProjects(ProgressIndicator progressIndicator) {
        RefManagerImpl refManager = RefManagerImpl.getImplInstance();
        ArrayList<Project> allProjects = new ArrayList<Project>();
        Iterator urlHandlersIterator = refManager.getRegisteredUrlHandlers();
        while (urlHandlersIterator.hasNext()) {
            URLHandler urlHandler = (URLHandler)urlHandlersIterator.next();
            long t0 = System.currentTimeMillis();
            Project[] includedProjects = urlHandler.getIncludedProjects(this, progressIndicator);
            long t1 = System.currentTimeMillis();
            this.addTiming(this._getIncludedProjects, urlHandler, t1 - t0);
            if (includedProjects == null) continue;
            int i = 0;
            while (i < includedProjects.length) {
                Project project = includedProjects[i];
                if (!allProjects.contains(project)) {
                    allProjects.add(project);
                }
                ++i;
            }
        }
        return allProjects.toArray(new Project[allProjects.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchResults(ProgressIndicator searchProgress) {
        this._searchResults.clear();
        RefManagerImpl refManager = RefManagerImpl.getImplInstance();
        Project[] projects = this.getProjects();
        HashSet handledUrls = new HashSet();
        long t0 = System.currentTimeMillis();
        IndexManager indexManager = IndexManager.getIndexManager();
        int i = 0;
        while (i < projects.length && !this.isUserCancelled()) {
            Project project_i = this.currentProject = projects[i];
            ArrayList<SearchResultsPerHandler> projectResults = new ArrayList<SearchResultsPerHandler>();
            HashSet projectUrls = new HashSet();
            String projectName = project_i.getShortLabel();
            String message = MessageFormat.format(RefactoringArb.getString(115), projectName);
            searchProgress.setProgressText(message);
            searchProgress.setProgressStepText("  ");
            int a = i * 100 / projects.length;
            int b = (i + 1) * 100 / projects.length;
            if (searchProgress instanceof DeterminateProgressIndicator) {
                DeterminateProgressIndicator dpi = (DeterminateProgressIndicator)searchProgress;
                dpi.setProgress(a);
            }
            long im0 = System.currentTimeMillis();
            Index index = indexManager.getIndex(project_i);
            long im1 = System.currentTimeMillis();
            this._totalGetIndexManager += im1 - im0;
            try {
                try {
                    index.lock();
                    try {
                        Iterator urlHandlersIterator = refManager.getRegisteredUrlHandlers();
                        while (urlHandlersIterator.hasNext() && !this.isUserCancelled()) {
                            URLHandler urlHandler = (URLHandler)urlHandlersIterator.next();
                            try {
                                long uh0 = System.currentTimeMillis();
                                HashSet urls = urlHandler.chooseURLs(this, project_i, searchProgress);
                                long uh1 = System.currentTimeMillis();
                                this.addTiming(this._chooseURL, urlHandler, uh1 - uh0);
                                if (urls == null) continue;
                                if (!(urlHandler instanceof TextURLHandler)) {
                                    for (URL url : urls) {
                                        if (!handledUrls.contains(url)) continue;
                                        SearchResultsPerHandler[] results = this._searchResults.getResults();
                                        int j = 0;
                                        while (j < results.length) {
                                            SearchResultsPerHandler result = results[j];
                                            URL[] urls_j = result.getUrls();
                                            int k = 0;
                                            while (k < urls_j.length) {
                                                URL url_k = urls_j[k];
                                                if (url.equals(url_k)) {
                                                    String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                                                    String handler_1 = result.getHandler().getClass().getName();
                                                    String handler_2 = urlHandler.getClass().getName();
                                                    Assert.println((String)("URLHandler conflict for " + platformPathName));
                                                    Assert.println((String)("  will be handled by     " + handler_1));
                                                    Assert.println((String)("  will not be handled by " + handler_2));
                                                }
                                                ++k;
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                urls.removeAll(handledUrls);
                                if (urls.isEmpty()) continue;
                                SearchResultsPerHandler handlerResults = new SearchResultsPerHandler(urlHandler, project_i, urls.toArray(new URL[urls.size()]));
                                projectResults.add(handlerResults);
                                handledUrls.addAll(urls);
                                projectUrls.addAll(urls);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    finally {
                        index.unlock();
                    }
                }
                catch (InterruptedException ie) {
                    Assert.printStackTrace((Throwable)ie);
                }
                catch (LockFailedException lfe) {
                    FeedbackManager.reportException((Throwable)lfe);
                    Assert.printStackTrace((Throwable)lfe);
                }
            }
            finally {
                index.release();
            }
            int[] handledUrlsCount = new int[]{projectUrls.size(), 0};
            if (!projectResults.isEmpty()) {
                searchProgress.setProgressText(UsageArb.getString(3));
            }
            for (SearchResultsPerHandler result : projectResults) {
                if (this.isUserCancelled()) break;
                URLHandler urlHandler = result.getHandler();
                URL[] urls = result.getUrls();
                handledUrlsCount[0] = handledUrlsCount[0] - handledUrlsCount[1];
                handledUrlsCount[1] = urls.length;
                1 tmpSearchProgress = new 1(this, handledUrlsCount, searchProgress, projectUrls, a, b);
                long uh2 = System.currentTimeMillis();
                UsageModel usageModel = urlHandler.findUsages(this, project_i, urls, tmpSearchProgress);
                long uh3 = System.currentTimeMillis();
                this._findUsages.put(urlHandler, uh3 - uh2);
                this.addTiming(this._findUsages, urlHandler, uh3 - uh2);
                if (usageModel == null) {
                    usageModel = new UsageModel();
                } else {
                    usageModel.sort();
                }
                result.setUsageModel(usageModel);
                if (this.isUserCancelled()) continue;
                this._searchResults.add(result);
            }
            if (searchProgress instanceof DeterminateProgressIndicator) {
                DeterminateProgressIndicator dpi = (DeterminateProgressIndicator)searchProgress;
                dpi.setProgress(b);
            }
            ++i;
        }
        long t1 = System.currentTimeMillis();
        this._totalFindUsages = t1 - t0;
        if (!this.isUserCancelled()) {
            RefactoringEvent event = new RefactoringEvent(2, this, this._searchResults);
            refManager.fireRefEvent(event);
            event = new RefactoringEvent(3, this, this._searchResults);
            refManager.fireRefEvent(event);
        }
    }

    @Override
    public final boolean doRefactoring() {
        boolean ret = false;
        if (!this.isUserCancelled() && this.prepareFiles(this._searchResults)) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            String shortTitle = this.getShortTitle();
            commandProcessor.beginTrans(shortTitle);
            try {
                try {
                    this.applyResults();
                    commandProcessor.endTrans();
                    ret = true;
                }
                catch (AbortedOperationException e) {
                    commandProcessor.abortTrans();
                }
                catch (Exception e) {
                    commandProcessor.abortTrans();
                    e.printStackTrace();
                }
            }
            finally {
                this.clear();
            }
        }
        return ret;
    }

    protected void applyResults() throws Exception {
        SearchResultsPerHandler[] allResults = this._searchResults.getResults();
        int i = 0;
        while (i < allResults.length) {
            Project project;
            UsageModel usageModel;
            SearchResultsPerHandler handlerResults = allResults[i];
            URLRefactoringHandler handler = (URLRefactoringHandler)handlerResults.getHandler();
            if (!handler.doChanges(this, usageModel = handlerResults.getUsageModel(), project = handlerResults.getProject())) {
                throw new AbortedOperationException();
            }
            ++i;
        }
    }

    private boolean prepareFiles(SearchResults searchResults) {
        HashSet<URL> affectedUrls = new HashSet<URL>();
        SearchResultsPerHandler[] allResults = searchResults.getResults();
        int i = 0;
        while (i < allResults.length) {
            SearchResultsPerHandler handlerResults = allResults[i];
            URLRefactoringHandler handler = (URLRefactoringHandler)handlerResults.getHandler();
            UsageModel usageModel = handlerResults.getUsageModel();
            Project project = handlerResults.getProject();
            Node[] affectedNodes = handler.getAffectedNodes(this, usageModel, project);
            int j = 0;
            while (j < affectedNodes.length) {
                Node affectedNode = affectedNodes[j];
                URL url = affectedNode.getURL();
                affectedUrls.add(url);
                ++j;
            }
            ++i;
        }
        URL[] urls = affectedUrls.toArray(new URL[affectedUrls.size()]);
        boolean ret = MakeWritableHelper.makeWritable(urls);
        return ret;
    }

    @Override
    public HashSet getKeywordHits(URLPath urlPath, String[] keywords, ProgressIndicator progressIndicator) {
        HashSet<URL> ret = new HashSet<URL>();
        URL[] entries = urlPath.getEntries();
        IndexManager im = IndexManager.getIndexManager();
        int j = 0;
        while (j < entries.length) {
            URL entry = entries[j];
            URL searchEntry = null;
            if (this._hintFile != null) {
                if (URLFileSystem.isBaseURLFor((URL)entry, (URL)this._hintFile)) {
                    searchEntry = null;
                    ret.add(this._hintFile);
                }
            } else if (this._hintPackage != null) {
                URL packageUrl = URLFactory.newDirURL((URL)entry, (String)this._hintPackage.replace('.', '/'));
                if (URLFileSystem.exists((URL)packageUrl)) {
                    searchEntry = packageUrl;
                }
            } else {
                searchEntry = entry;
            }
            if (searchEntry != null) {
                Index index = im.getIndex(this.currentProject, searchEntry);
                try {
                    URL[] hits = this.get(index, keywords, progressIndicator);
                    int k = 0;
                    while (k < hits.length) {
                        URL hit = hits[k];
                        if (this._hintPackage == null) {
                            ret.add(hit);
                        } else {
                            URL directory = URLFileSystem.getParent((URL)hit);
                            if (searchEntry.equals(directory)) {
                                ret.add(hit);
                            }
                        }
                        ++k;
                    }
                }
                finally {
                    index.release();
                }
            }
            ++j;
        }
        return ret;
    }

    @Override
    public HashSet getKeywordHits(ContentSet contentSet, String[] keywords, ProgressIndicator progressIndicator) {
        HashSet<URL> ret = new HashSet<URL>();
        if (this._hintFile != null) {
            if (contentSet.canHaveMember(this._hintFile)) {
                ret.add(this._hintFile);
            }
        } else {
            IndexManager im = IndexManager.getIndexManager();
            Index index = im.getIndex(this.currentProject, contentSet);
            try {
                URL[] results = this.get(index, SearchOperationImpl.validate(keywords), progressIndicator);
                if (this._hintPackage != null) {
                    String packagePath = this._hintPackage.replace('.', '/');
                    URL[] uRLArray = results;
                    int n = 0;
                    while (n < uRLArray.length) {
                        URL result = uRLArray[n];
                        String path = contentSet.toRelativePath(result);
                        if (path != null && path.startsWith(packagePath)) {
                            ret.add(result);
                        }
                        ++n;
                    }
                } else {
                    ret.addAll(Arrays.asList(results));
                }
            }
            finally {
                index.release();
            }
        }
        return ret;
    }

    private static String[] validate(String[] keywords) {
        ArrayList<String> valid = new ArrayList<String>(keywords.length);
        int i = 0;
        while (i < keywords.length) {
            if (SearchOperationImpl.isValidKeyword(keywords[i])) {
                valid.add(keywords[i]);
            }
            ++i;
        }
        return valid.toArray(new String[valid.size()]);
    }

    private static boolean isValidKeyword(String keyword) {
        int length = keyword.length();
        if (length > 0) {
            int i = 0;
            while (i < length) {
                char c = keyword.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    return false;
                }
                if ("$.+ \t\n\r".indexOf(c) != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private URL[] get(Index index, String[] keywords, ProgressIndicator progressIndicator) {
        QueryCriteria criteria = KeywordCriteria.get((String[])keywords);
        try {
            BackgroundTask query = index.query(criteria);
            2 listener = new 2(this, query);
            progressIndicator.addActionListener(listener);
            URL[] results = null;
            try {
                try {
                    while (!progressIndicator.isUserCancelled()) {
                        if (progressIndicator != null) {
                            String progressText = query.getProgressText();
                            progressIndicator.setProgressStepText(progressText);
                        }
                        try {
                            results = (URL[])query.get(200L, TimeUnit.MILLISECONDS);
                            break;
                        }
                        catch (CancellationException ce) {
                            break;
                        }
                        catch (TimeoutException te) {
                            // empty catch block
                        }
                    }
                }
                catch (ExecutionException ee) {
                    Throwable t = ee.getCause();
                    if (t == null) {
                        t = ee;
                    }
                    FeedbackManager.reportException((Throwable)t);
                    Assert.printStackTrace((Throwable)ee);
                }
                catch (InterruptedException ie) {}
            }
            finally {
                progressIndicator.removeActionListener(listener);
            }
            if (!progressIndicator.isUserCancelled()) {
                URL[] uRLArray = results;
                return uRLArray;
            }
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
        return new URL[0];
    }

    private Project[] getProjects() {
        return this._projects;
    }

    private void setProjects(Project[] projects) {
        this._projects = projects;
    }

    public boolean runRefactoring(boolean preview) {
        boolean ret = false;
        if (this.doSearch()) {
            ret = preview ? PreviewLogPage.showUsages(this) : this.doRefactoring();
        }
        return ret;
    }

    public boolean runSafeRefactoring() {
        SearchCriteria searchCriteria = this.getCriteria();
        if (!(searchCriteria instanceof AbstractSearchCriteria)) {
            return this.runRefactoring(false);
        }
        if (!this.doSearch()) {
            return false;
        }
        AbstractSearchCriteria criteria = (AbstractSearchCriteria)searchCriteria;
        SearchResults results = this.getSearchResults();
        boolean canRefactor = criteria.verifySearchResults(results);
        if (canRefactor) {
            return this.doRefactoring();
        }
        return PreviewLogPage.showUsages(this);
    }

    @Override
    public String getShortTitle() {
        if (this._shortTitle == null) {
            this._shortTitle = this.getCriteria().getShortTitle();
        }
        return this._shortTitle;
    }

    @Override
    public String getLongTitle() {
        if (this._longTitle == null) {
            this._longTitle = this.getCriteria().getLongTitle();
        }
        return this._longTitle;
    }

    @Override
    public void clear() {
        super.clear();
        this._projects = null;
        this._hintPackage = null;
        this._messages = null;
        if (!this._searchResults.isEmtpy()) {
            UsageModel usageModel = this._searchResults.getUsageModel();
            this._searchResults.clear();
            usageModel.release();
        }
    }

    public void setSearchHintFile(URL fileUrl) {
        this._hintFile = fileUrl;
    }

    @Override
    public URL getSearchHintFile() {
        return this._hintFile;
    }

    public void setSearchHintPackage(String packageName) {
        this._hintPackage = packageName;
    }

    public void setUserCancelled(boolean cancelled) {
        this._userCancelled = cancelled;
    }

    @Override
    public boolean isUserCancelled() {
        return this._userCancelled;
    }

    final class 1
    implements ProgressIndicator {
        private final /* synthetic */ int[] v$handledUrlsCount;
        private final /* synthetic */ ProgressIndicator v$searchProgress;
        private final /* synthetic */ HashSet v$projectUrls;
        private final /* synthetic */ int v$a;
        private final /* synthetic */ int v$b;
        final /* synthetic */ SearchOperationImpl this$0;

        public void setProgressStepText(String text) {
            int remaining = this.v$handledUrlsCount[0];
            if (this.v$handledUrlsCount[1] > 0) {
                this.v$handledUrlsCount[0] = this.v$handledUrlsCount[0] - 1;
                this.v$handledUrlsCount[1] = this.v$handledUrlsCount[1] - 1;
            }
            String step = UsageArb.format(7, remaining);
            this.v$searchProgress.setProgressStepText(step);
            if (this.v$searchProgress instanceof DeterminateProgressIndicator) {
                DeterminateProgressIndicator dpi = (DeterminateProgressIndicator)this.v$searchProgress;
                int t = this.v$projectUrls.size();
                int x = t - remaining;
                int progress = this.v$a + x * (this.v$b - this.v$a) / t;
                dpi.setProgress(progress);
            }
        }

        public void setProgressText(String text) {
            this.v$searchProgress.setProgressText(text);
        }

        public void addActionListener(ActionListener listener) {
            this.v$searchProgress.addActionListener(listener);
        }

        public void removeActionListener(ActionListener listener) {
            this.v$searchProgress.removeActionListener(listener);
        }

        public boolean isUserCancelled() {
            return this.v$searchProgress.isUserCancelled();
        }

        public 1(SearchOperationImpl searchOperationImpl, int[] nArray, ProgressIndicator progressIndicator, HashSet hashSet, int n, int n2) {
            this.v$b = n2;
            this.v$a = n;
            this.v$projectUrls = hashSet;
            this.v$searchProgress = progressIndicator;
            this.v$handledUrlsCount = nArray;
            this.this$0 = searchOperationImpl;
        }
    }

    final class 2
    implements ActionListener {
        private final /* synthetic */ BackgroundTask v$query;
        final /* synthetic */ SearchOperationImpl this$0;

        public void actionPerformed(ActionEvent e) {
            this.v$query.cancel(true);
        }

        public 2(SearchOperationImpl searchOperationImpl, BackgroundTask backgroundTask) {
            this.v$query = backgroundTask;
            this.this$0 = searchOperationImpl;
        }
    }
}

