/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.model;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.feedback.FeedbackManager;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;

public class SearchProgress
implements Runnable,
ProgressIndicator {
    ProgressBar _progressBar;
    private SearchOperationImpl _searchOperation;
    private String _progressStep;
    private String _progressText;
    private ArrayList _listeners;
    private boolean _isUserCancelled;

    private void $init$() {
        this._listeners = new ArrayList(1);
    }

    public SearchProgress(SearchOperationImpl searchOperation) {
        this.$init$();
        this._searchOperation = searchOperation;
    }

    public void start() {
        SearchCriteria criteria = this._searchOperation.getCriteria();
        IdeMainWindow mainWindow = Ide.getMainWindow();
        this._searchOperation.setUserCancelled(false);
        if (mainWindow != null) {
            this._progressText = criteria.getShortTitle();
            this._progressBar = new ProgressBar((Component)mainWindow, this._progressText, (Runnable)this, true);
            this._progressBar.start(RefactoringArb.getString(85), " ");
            this._isUserCancelled = false;
            if (this._progressBar.hasUserCancelled()) {
                this._isUserCancelled = true;
                this._searchOperation.setUserCancelled(true);
                int i = 0;
                while (i < this._listeners.size()) {
                    ActionListener actionListener = (ActionListener)this._listeners.get(i);
                    actionListener.actionPerformed(new ActionEvent(this, 1001, "canceled"));
                    ++i;
                }
            }
        } else {
            this.run();
        }
        this._searchOperation = null;
    }

    public void run() {
        try {
            try {
                this._searchOperation.doSearch(this);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        finally {
            if (this._progressBar != null) {
                this._progressBar.setDoneStatus();
            }
        }
    }

    public ProgressBar getProgressBar() {
        return this._progressBar;
    }

    public void setProgressText(String text) {
        this._progressText = text;
        this.updateProgress();
    }

    public boolean isUserCancelled() {
        return this._isUserCancelled;
    }

    public void addActionListener(ActionListener listener) {
        this._listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this._listeners.remove(listener);
    }

    public void setProgressStepText(String text) {
        this._progressStep = text;
        this.updateProgress();
    }

    private void updateProgress() {
        if (this._progressBar != null) {
            this._progressBar.updateProgress(this._progressText, this._progressStep);
        }
    }
}

