/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.convertanotoinner;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.MultiMap;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.jotpatch.Patch;
import oracle.jdevimpl.refactoring.oprs.convertanotoinner.ConvertDialog;
import oracle.jdevimpl.refactoring.util.Visitor;

public class ConvertAnonymousToInnerController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean ret = this.handle(context, false);
        action.setEnabled(ret);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean doit) {
        boolean ret = false;
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            Project project = context.getProject();
            if (project != null) {
                SourceFile sourceFile;
                JavaSourceNode javaSourceNode;
                URL url;
                int caretPosition = codeEditor.getCaretPosition();
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                Node node = context.getNode();
                if (node instanceof JavaSourceNode && Util.canRefactor(url = (javaSourceNode = (JavaSourceNode)node).getURL()) && (sourceFile = javaManager.getSourceFile(url)) != null) {
                    1 visitor = new 1(this, caretPosition);
                    ((Visitor)visitor).visit((SourceElement)sourceFile);
                    SourceClass anonymousClass = (SourceClass)visitor.getUserData();
                    if (anonymousClass != null) {
                        ret = true;
                        if (doit) {
                            this.convertClass(context, anonymousClass);
                        }
                    }
                }
            }
        }
        return ret;
    }

    private void convertClass(Context context, SourceClass anonymousClass) {
        MultiMap usedVariables = new MultiMap();
        boolean canBeStatic = true;
        List list = SourceElementAsList.asList((SourceElement)anonymousClass, (int[])new int[]{57});
        int i = 0;
        while (i < list.size()) {
            SourceElement resolvedSourceElement;
            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)list.get(i);
            JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
            if (resolvedObject != null && (resolvedSourceElement = resolvedObject.getSourceElement()) != null) {
                switch (resolvedSourceElement.getSymbolKind()) {
                    case 13: 
                    case 17: {
                        SourceVariable sourceVariable = (SourceVariable)resolvedSourceElement;
                        if (Patch.contains((SourceElement)anonymousClass, (SourceElement)sourceVariable)) break;
                        List usages = usedVariables.getOrCreate((Object)sourceVariable);
                        usages.add(sourceSimpleNameExpression);
                        break;
                    }
                    case 10: {
                        canBeStatic = false;
                        break;
                    }
                }
            }
            ++i;
        }
        Set variableSet = usedVariables.keySet();
        SourceVariable[] sourceVariables = variableSet.toArray(new SourceVariable[variableSet.size()]);
        ConvertDialog convertDialog = new ConvertDialog(context, anonymousClass, sourceVariables, canBeStatic);
        if (convertDialog.runDialog()) {
            String className = convertDialog.getClassName();
            String[] variableNames = convertDialog.getVariableNames();
            boolean makeStatic = convertDialog.isMakeStaticSelected();
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                SourceVariable[] superCtorParams;
                refactoringCommandSupport.beginTransaction((SourceElement)anonymousClass);
                JavaClass owningClass = anonymousClass.getOwningClass();
                SourceClass owningSourceClass = (SourceClass)owningClass.getSourceElement();
                SourceFile owningSourceFile = owningSourceClass.getOwningSourceFile();
                SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)anonymousClass.getParent();
                SourceTypeReference oldSourceType = sourceClassCreatorExpression.getSourceType();
                JavaType resolvedSuperType = oldSourceType.getResolvedType();
                JavaMethod resolvedSuperCtor = sourceClassCreatorExpression.getResolvedMethod();
                SourceFactory factory = owningSourceFile.getFactory();
                String[] fieldNames = new String[variableNames.length];
                String[] fieldAccessExpressions = new String[variableNames.length];
                HashMap<String, String> varNameToFieldAccessMap = new HashMap<String, String>();
                int i2 = 0;
                while (i2 < variableNames.length) {
                    String variableName = variableNames[i2];
                    if (variableName != null) {
                        fieldAccessExpressions[i2] = "this._" + variableName;
                        fieldNames[i2] = '_' + variableName;
                    } else {
                        fieldAccessExpressions[i2] = sourceVariables[i2].getName();
                    }
                    varNameToFieldAccessMap.put(variableName, fieldAccessExpressions[i2]);
                    ++i2;
                }
                int i3 = 0;
                while (i3 < sourceVariables.length) {
                    SourceVariable sourceVariable = sourceVariables[i3];
                    List usages = usedVariables.get((Object)sourceVariable);
                    int j = 0;
                    while (j < usages.size()) {
                        SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)usages.get(j);
                        SourceExpression replacementExpression = factory.createExpression((String)varNameToFieldAccessMap.get(sourceVariable.getName()));
                        sourceSimpleNameExpression.replaceSelf((SourceElement)replacementExpression);
                        ++j;
                    }
                    ++i3;
                }
                SourceTypeReference newSourceType = factory.createType(className);
                oldSourceType.replaceSelf((SourceElement)newSourceType);
                SourceListExpression argumentList = sourceClassCreatorExpression.getArgumentList();
                int i4 = 0;
                while (i4 < sourceVariables.length) {
                    SourceVariable sourceVariable = sourceVariables[i4];
                    SourceSimpleNameExpression arg = factory.createSimpleNameExpression(sourceVariable.getName());
                    arg.addSelf((SourceElement)argumentList);
                    ++i4;
                }
                SourceClassBody innerClassBody = anonymousClass.getSourceBody();
                innerClassBody.removeSelf();
                SourceSuperclassClause sourceSuperclassClause = null;
                SourceInterfacesClause sourceInterfacesClause = null;
                if (resolvedSuperType != null) {
                    if (resolvedSuperType.isInterface()) {
                        sourceInterfacesClause = factory.createInterfacesClause(new SourceTypeReference[]{oldSourceType});
                    } else {
                        sourceSuperclassClause = factory.createSuperclassClause(oldSourceType);
                    }
                }
                if (resolvedSuperCtor != null) {
                    SourceMethod superCtorSourceMethod = (SourceMethod)resolvedSuperCtor.getSourceElement();
                    if (superCtorSourceMethod != null) {
                        SourceFormalParameterList formalParameterList = superCtorSourceMethod.getFormalParameterList();
                        List sourceParameters = formalParameterList.getSourceParameters();
                        superCtorParams = new SourceVariable[sourceParameters.size()];
                        int i5 = 0;
                        while (i5 < sourceParameters.size()) {
                            SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i5);
                            SourceTypeReference sourceType = (SourceTypeReference)sourceVariable.getSourceType().cloneSelf(owningSourceFile);
                            superCtorParams[i5] = this.createSuperCtorParam(factory, sourceType, sourceVariable.getName(), variableNames, superCtorParams);
                            ++i5;
                        }
                    } else {
                        JavaType[] parameterTypes = resolvedSuperCtor.getParameterTypes();
                        superCtorParams = new SourceVariable[parameterTypes.length];
                        int i6 = 0;
                        while (i6 < parameterTypes.length) {
                            JavaType parameterType = parameterTypes[i6];
                            JavaClass closestClass = parameterType.getTypeErasure();
                            String name = closestClass.getName();
                            String typeQualifiedName = parameterType.getQualifiedName();
                            SourceTypeReference sourceType = factory.createType(typeQualifiedName);
                            superCtorParams[i6] = this.createSuperCtorParam(factory, sourceType, name, variableNames, superCtorParams);
                            ++i6;
                        }
                    }
                } else {
                    superCtorParams = null;
                }
                SourceFormalParameterList formalParameterList = factory.createFormalParameterList();
                SourceBlock ctorBlock = factory.createBlock();
                if (superCtorParams != null) {
                    SourceExpression[] sourceExpressions = new SourceExpression[superCtorParams.length];
                    int i7 = 0;
                    while (i7 < superCtorParams.length) {
                        SourceVariable superCtorParam = superCtorParams[i7];
                        String name = superCtorParam.getName();
                        sourceExpressions[i7] = factory.createSimpleNameExpression(name);
                        superCtorParam.addSelf((SourceElement)formalParameterList);
                        ++i7;
                    }
                    SourceMethodCallExpression superCtorCall = factory.createMethodCall(null, "super", factory.createArgumentList(sourceExpressions));
                    SourceExpressionStatement expressionStatement = factory.createExpressionStatement((SourceExpression)superCtorCall);
                    expressionStatement.addSelf((SourceElement)ctorBlock);
                }
                int i8 = 0;
                while (i8 < sourceVariables.length) {
                    String variableName = variableNames[i8];
                    if (variableName != null) {
                        SourceVariable sourceVariable = sourceVariables[i8];
                        SourceTypeReference sourceType = sourceVariable.getSourceType();
                        String fieldAccessExpression = fieldAccessExpressions[i8];
                        String fieldName = fieldNames[i8];
                        boolean isFinal = sourceVariable.isFinal();
                        SourceTypeReference typeClone = (SourceTypeReference)sourceType.cloneSelf(owningSourceFile);
                        SourceLocalVariable parameter = factory.createLocalVariable(isFinal ? 16 : 0, typeClone, variableName);
                        parameter.addSelf((SourceElement)formalParameterList);
                        SourceTypeReference typeClone2 = (SourceTypeReference)sourceType.cloneSelf(owningSourceFile);
                        SourceFieldVariable fieldVariable = factory.createFieldVariable(2, typeClone2, fieldName);
                        SourceFieldDeclaration fieldDeclaration = factory.createFieldDeclaration(fieldVariable);
                        fieldDeclaration.addSelf((SourceElement)innerClassBody);
                        SourceExpression lhs = factory.createExpression(fieldAccessExpression);
                        SourceSimpleNameExpression rhs = factory.createSimpleNameExpression(variableName);
                        SourceAssignmentExpression sourceAssignmentExpression = factory.createAssignment(6, lhs, (SourceExpression)rhs);
                        SourceExpressionStatement expressionStatement = factory.createExpressionStatement((SourceExpression)sourceAssignmentExpression);
                        expressionStatement.addSelf((SourceElement)ctorBlock);
                    }
                    ++i8;
                }
                SourceMethod constructor = factory.createConstructor(formalParameterList, null, ctorBlock);
                constructor.addSelf((SourceElement)innerClassBody);
                SourceClassBody owningSourceClassBody = owningSourceClass.getSourceBody();
                SourceClass innerClass = factory.createClass(0, className, null, sourceSuperclassClause, sourceInterfacesClause, innerClassBody);
                innerClass.addSelf((SourceElement)owningSourceClassBody);
                innerClass.setModifiers(2 | (makeStatic ? 8 : 0));
                refactoringCommandSupport.commit(context, RefactoringArb.getString(153));
            }
            catch (Exception e) {
                e.printStackTrace();
                refactoringCommandSupport.abort();
            }
        }
    }

    private SourceLocalVariable createSuperCtorParam(SourceFactory factory, SourceTypeReference sourceType, String baseName, String[] variableNames, SourceVariable[] superCtorParams) {
        String paramName = null;
        boolean isValid = false;
        int j = 0;
        while (!isValid) {
            paramName = baseName;
            if (j > 0) {
                paramName = paramName + j;
            }
            isValid = true;
            int k = 0;
            while (isValid && k < variableNames.length) {
                String variableName = variableNames[k];
                if (paramName.equals(variableName)) {
                    isValid = false;
                }
                ++k;
            }
            int k2 = 0;
            while (k2 < superCtorParams.length) {
                SourceVariable superCtorParam = superCtorParams[k2];
                if (superCtorParam != null && paramName.equals(superCtorParam.getName())) {
                    isValid = false;
                }
                ++k2;
            }
            ++j;
        }
        return factory.createLocalVariable(sourceType, paramName);
    }

    final class 1
    extends Visitor {
        private final /* synthetic */ int v$caretPosition;
        final /* synthetic */ ConvertAnonymousToInnerController this$0;

        public void visit(SourceElement sourceElement) {
            if (Patch.contains(sourceElement, this.v$caretPosition)) {
                super.visit(sourceElement);
            }
        }

        protected void whenEnterClassCreatorExpression(SourceNewClassExpression sourceClassCreatorExpression) {
            SourceClass anonymousClass = sourceClassCreatorExpression.getAnonymousClass();
            if (anonymousClass != null && !Patch.contains((SourceElement)anonymousClass, this.v$caretPosition)) {
                this.setUserData(anonymousClass);
            }
        }

        public 1(ConvertAnonymousToInnerController convertAnonymousToInnerController, int n) {
            this.v$caretPosition = n;
            this.this$0 = convertAnonymousToInnerController;
        }
    }
}

