/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.convertanotoinner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.resource.RefactoringArb;

public class ConvertDialog
extends BaseDialog {
    private static final String PREFERENCE_KEY = "CVT_ANO2INNER_PREF";
    private JTextField _classNameField;
    private JTable _parameters;
    private SourceVariable[] _sourceVariables;
    private JCheckBox _makeStatic;
    private DefaultTableModel _tableModel;
    private SourceClass _anonymousClass;

    public ConvertDialog(Context context, SourceClass anonymousClass, SourceVariable[] sourceVariables, boolean canBeStatic) {
        super(PREFERENCE_KEY, context);
        this._sourceVariables = sourceVariables;
        this._anonymousClass = anonymousClass;
        this.init(canBeStatic);
    }

    private void init(boolean canBeStatic) {
        JLabel classNameLabel = new JLabel();
        this._classNameField = new JTextField();
        ResourceUtils.resLabel((JLabel)classNameLabel, (Component)this._classNameField, (String)RefactoringArb.getString(318));
        this._classNameField.setText("My" + this._anonymousClass.getSuperclass().getName());
        this.updateOnChanges(this._classNameField);
        JLabel paramLabel = new JLabel();
        this._tableModel = new DefaultTableModel(0, 2);
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        this._parameters = new JTable(this._tableModel, tableColumnModel);
        TableColumn includeCol = new TableColumn(0, 10, this._parameters.getDefaultRenderer(Boolean.class), this._parameters.getDefaultEditor(Boolean.class));
        includeCol.setHeaderValue(" ");
        tableColumnModel.addColumn(includeCol);
        TableColumn variableCol = new TableColumn(1, 500, this._parameters.getDefaultRenderer(String.class), this._parameters.getDefaultEditor(String.class));
        variableCol.setHeaderValue(RefactoringArb.getString(189));
        tableColumnModel.addColumn(variableCol);
        int i = 0;
        while (i < this._sourceVariables.length) {
            SourceVariable sourceVariable = this._sourceVariables[i];
            String variableName = sourceVariable.getName();
            Object[] row = new Object[]{Boolean.TRUE, variableName};
            this._tableModel.addRow(row);
            ++i;
        }
        ResourceUtils.resLabel((JLabel)paramLabel, (Component)this._parameters, (String)RefactoringArb.getString(251));
        this._makeStatic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._makeStatic, (String)RefactoringArb.getString(266));
        this._makeStatic.setSelected(canBeStatic);
        this._makeStatic.setEnabled(canBeStatic);
        JLabel message = new JLabel();
        message.setPreferredSize(this._classNameField.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)classNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._classNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        if (this._sourceVariables.length > 0) {
            JScrollPane scrollPane = new JScrollPane(this._parameters);
            scrollPane.setPreferredSize(new Dimension(100, 100));
            scrollPane.getViewport().setBackground(this._parameters.getBackground());
            this.add((Component)paramLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)scrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        }
        this.add((Component)this._makeStatic, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 16, 2, insets, 0, 0));
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._classNameField;
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_danontoinner_html";
    }

    protected String getTitle() {
        return RefactoringArb.getString(153);
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String className = this.getClassName();
            if (className.length() == 0) {
                isValid = false;
            } else if (!NamingUtil.isJavaIdentifier((String)className)) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (NamingUtil.isJavaReservedWord((String)className)) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (Character.isLowerCase(className.charAt(0))) {
                message = RefactoringArb.getString(37);
            } else if (this.owningClassContains(className)) {
                message = MessageFormat.format(RefactoringArb.getString(369), className);
                isValid = false;
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    public boolean runDialog() {
        boolean ret = super.runDialog();
        TableCellEditor cellEditor = this._parameters.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return ret;
    }

    private boolean owningClassContains(String className) {
        JavaClass owningClass = this._anonymousClass.getOwningClass();
        Collection declaredClasses = owningClass.getDeclaredClasses();
        for (JavaClass javaClass : declaredClasses) {
            if (!className.equals(javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this._classNameField.getText();
    }

    public String[] getVariableNames() {
        int rowCount = this._tableModel.getRowCount();
        String[] ret = new String[rowCount];
        int row = 0;
        while (row < ret.length) {
            Boolean included = (Boolean)this._tableModel.getValueAt(row, 0);
            if (included.booleanValue()) {
                Object variableName = this._tableModel.getValueAt(row, 1);
                ret[row] = (String)variableName;
            }
            ++row;
        }
        return ret;
    }

    public boolean isMakeStaticSelected() {
        return this._makeStatic.isSelected();
    }
}

