/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.createenum;

import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.createenum.CreateEnumDlg;
import oracle.jdevimpl.refactoring.oprs.createenum.CreateEnumOperation;
import oracle.jdevimpl.refactoring.preview.PreviewLogPage;

public class CreateEnumController
implements Controller {
    static final String OPERATION_TITLE = "Create Enumeration";

    public boolean update(IdeAction action, Context context) {
        boolean canHandle = false;
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 4: {
                    String fqTypeName;
                    JavaType resolvedType;
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    if (!javaField.isStatic() || !javaField.isFinal() || (resolvedType = javaField.getResolvedType()) == null || !"int".equals(fqTypeName = resolvedType.getQualifiedName()) && !"java.lang.String".equals(fqTypeName)) break;
                    canHandle = true;
                    break;
                }
            }
        }
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        ElementAt elementAt = ElementAt.findElementAt(context);
        if (elementAt != null) {
            switch (elementAt.getElementType()) {
                case 4: {
                    JavaField[] javaFields;
                    String fqEnumName;
                    CreateEnumOperation createEnumOperation;
                    JavaField javaField = (JavaField)elementAt.getJavaElement();
                    CreateEnumDlg dialog = new CreateEnumDlg(context, javaField);
                    if (!dialog.runDialog() || !(createEnumOperation = new CreateEnumOperation(context, fqEnumName = dialog.getFqEnumName(), javaFields = dialog.getSelectedFields())).doSearch()) break;
                    if (dialog.hasPreview()) {
                        PreviewLogPage.showUsages(createEnumOperation);
                        break;
                    }
                    createEnumOperation.doRefactoring();
                    break;
                }
            }
        }
        return true;
    }
}

