/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.createenum;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.util.NameValidation;

public class CreateEnumDlg
extends BaseDialog
implements ActionListener {
    public static final String PREFERENCE_KEY = "CREATE_ENUM_DEFAULTS";
    private static final int PREF_PREVIEW = 1;
    private JTextField _pkgField;
    private JTextField _clsField;
    private JButton _browsePkg;
    private CustomJTree _customJTree;
    private JMutableTreeNode _root;
    private JavaField _javaField;
    private JCheckBox _preview;

    public CreateEnumDlg(Context context, JavaField javaField) {
        super(PREFERENCE_KEY, context);
        this._javaField = javaField;
        this.init();
    }

    protected String getTitle() {
        return "Create Enumeration";
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String packageName = this._pkgField.getText();
            String className = this._clsField.getText();
            NameValidation nameValidation = NameValidation.validateClassName(this.getContext().getProject(), packageName, className, true);
            String message = nameValidation.getMessage();
            boolean isValid = nameValidation.isValid();
            if (isValid && this.getSelectedFields().length == 0) {
                message = null;
                isValid = false;
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    protected void updateSettings(CopyableInteger settings) {
        settings.setBit(1, this._preview.isSelected());
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._clsField;
    }

    protected String getHelpTopicID() {
        return "f1_xxx";
    }

    private void init() {
        JLabel pkgLabel = new JLabel();
        this._pkgField = new JTextField();
        ResourceUtils.resLabel((JLabel)pkgLabel, (Component)this._pkgField, (String)RefactoringArb.getString(76));
        this.updateOnChanges(this._pkgField);
        ClassPickerFactory.attach(this._pkgField, this.getContext(), 0);
        this._browsePkg = new JButton("...");
        this._browsePkg.addActionListener(this);
        JLabel clsLabel = new JLabel();
        this._clsField = new JTextField();
        ResourceUtils.resLabel((JLabel)clsLabel, (Component)this._clsField, (String)RefactoringArb.getString(185));
        this.updateOnChanges(this._clsField);
        this._root = this.createRoot();
        this._customJTree = new CustomJTree(this._root);
        this._customJTree.setRootVisible(false);
        this._customJTree.setShowsRootHandles(false);
        this._customJTree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.updateOnTreeCellChecked(this._customJTree);
        JScrollPane scrollPane = new JScrollPane((Component)this._customJTree);
        this._preview = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._preview, (String)RefactoringArb.getString(41));
        JLabel message = new JLabel();
        message.setPreferredSize(new Dimension(400, this._pkgField.getPreferredSize().height));
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)pkgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._pkgField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._browsePkg, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)clsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._clsField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        this.add((Component)this._preview, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        JavaClass owningClass = this._javaField.getOwningClass();
        String packageName = owningClass.getPackageName();
        this._pkgField.setText(packageName);
        this._preview.setSelected(this.getSettings().isBitSet(1));
    }

    private JMutableTreeNode createRoot() {
        JMutableTreeNode root = new JMutableTreeNode("root");
        JavaClass owningClass = this._javaField.getOwningClass();
        JavaType sourceFieldType = this._javaField.getResolvedType();
        Collection declaredFields = owningClass.getDeclaredFields();
        Icon icon = OracleIcons.getIcon((String)"field.png");
        for (JavaField javaField : declaredFields) {
            JavaType resolvedType;
            if (!javaField.isStatic() || !javaField.isFinal() || !sourceFieldType.equals((Object)(resolvedType = javaField.getResolvedType()))) continue;
            String fieldName = javaField.getName();
            String typeName = resolvedType.getName();
            String text = fieldName + ":" + typeName;
            JTreeCellData treeCellData = new JTreeCellData(icon, text, true);
            treeCellData.setUserObject((Object)javaField);
            treeCellData.setCheckBoxState(this._javaField.equals(javaField));
            JMutableTreeNode mutableTreeNode = new JMutableTreeNode(treeCellData);
            root.add((MutableTreeNode)mutableTreeNode);
        }
        return root;
    }

    public void actionPerformed(ActionEvent e) {
        this.whenBrowsePackage();
    }

    private void whenBrowsePackage() {
        String[] newType = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.getContext().getProject(), 2, false, null, this._pkgField.getText());
        if (newType != null && newType.length == 1) {
            this._pkgField.setText(newType[0]);
        }
    }

    public String getFqEnumName() {
        String pkgText = this._pkgField.getText();
        String clsText = this._clsField.getText();
        return Util.getFqClassName(pkgText, clsText);
    }

    public JavaField[] getSelectedFields() {
        ArrayList<JavaField> javaFields = new ArrayList<JavaField>();
        int childCount = this._root.getChildCount();
        int i = 0;
        while (i < childCount) {
            JMutableTreeNode child = (JMutableTreeNode)this._root.getChildAt(i);
            JTreeCellData treeCellData = child.getModel();
            TriStateBoolean checkBoxState = treeCellData.getCheckBoxState();
            if (checkBoxState.isTrue()) {
                JavaField javaField = (JavaField)treeCellData.getUserObject();
                javaFields.add(javaField);
            }
            ++i;
        }
        return javaFields.toArray(new JavaField[javaFields.size()]);
    }

    public boolean hasPreview() {
        return this._preview.isSelected();
    }
}

