/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.createenum;

import java.util.ArrayList;
import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.jdeveloper.refactoring.model.UsageEntry;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdevimpl.refactoring.preview.UsageSource;
import oracle.jdevimpl.refactoring.util.FindMemberUsages;

public class CreateEnumOperation
implements UsageSource {
    private Context _context;
    private String _fqEnumName;
    private JavaField[] _javaFields;
    private UsageModel _usageModel;
    private static final int USAGE_TYPE_DEF = 0;
    private static final int USAGE_TYPE_REF = 1;

    public CreateEnumOperation(Context context, String fqEnumName, JavaField[] javaFields) {
        this._context = context;
        this._fqEnumName = fqEnumName;
        this._javaFields = javaFields;
    }

    public Context getContext() {
        return this._context;
    }

    public String getShortTitle() {
        return "Create Enumeration";
    }

    public String getLongTitle() {
        return "Create Enumeration";
    }

    public boolean canSearch() {
        return true;
    }

    public boolean doSearch() {
        this._usageModel = new UsageModel();
        Project definingProject = this.getContext().getProject();
        int i = 0;
        while (i < this._javaFields.length) {
            JavaField javaField = this._javaFields[i];
            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)javaField.getSourceElement();
            UsageEntry usageEntry = new UsageEntry(definingProject, (SourceElement)sourceFieldVariable, 0, 2);
            usageEntry.setUserObject(sourceFieldVariable);
            this._usageModel.addUsageEntry(usageEntry);
            ++i;
        }
        HashSet dependentProjects = Util.getDependentProjects(this._context.getWorkspace(), this._context.getProject());
        for (Project project : dependentProjects) {
            this.searchFieldsUsages(project, this._usageModel);
        }
        ArrayList usageEntries = this._usageModel.getUsageEntries();
        int i2 = 0;
        while (i2 < usageEntries.size()) {
            UsageEntry usageEntry = (UsageEntry)usageEntries.get(i2);
            SourceElement sourceElement = (SourceElement)usageEntry.getUserObject();
            SourceFile owningSourceFile = sourceElement.getOwningSourceFile();
            System.out.println("Usage in " + owningSourceFile.hashCode());
            ++i2;
        }
        return true;
    }

    private void searchFieldsUsages(Project project, UsageModel usageModel) {
        FindMemberUsages findMemberUsages = new FindMemberUsages((JavaMember[])this._javaFields);
        ArrayList fieldAccesses = new ArrayList();
        FindMemberUsages.FillListsUsageListener usageListener = new FindMemberUsages.FillListsUsageListener(null, null, fieldAccesses);
        findMemberUsages.findMemberUsages(project, usageListener);
        int i = 0;
        while (i < fieldAccesses.size()) {
            SourceExpression sourceExpression = (SourceExpression)fieldAccesses.get(i);
            UsageEntry usageEntry = new UsageEntry(project, (SourceElement)sourceExpression, 1, 2);
            usageEntry.setUserObject(sourceExpression);
            usageModel.addUsageEntry(usageEntry);
            ++i;
        }
    }

    public UsageModel getUsageModel() {
        return this._usageModel;
    }

    public boolean doRefactoring() {
        UsageModel usageModel = this.getUsageModel();
        ArrayList usageEntries = usageModel.getUsageEntries();
        RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
        try {
            int i = 0;
            while (i < usageEntries.size()) {
                UsageEntry usageEntry = (UsageEntry)usageEntries.get(i);
                if (usageEntry.isIncluded()) {
                    SourceElement sourceElement = (SourceElement)usageEntry.getUserObject();
                    SourceFile owningSourceFile = sourceElement.getOwningSourceFile();
                    refactoringCommandSupport.beginTransaction((SourceElement)owningSourceFile);
                    SourceFactory factory = owningSourceFile.getFactory();
                    block1 : switch (usageEntry.getUsageType()) {
                        case 0: {
                            SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                            sourceFieldVariable.removeSelf();
                            break;
                        }
                        case 1: {
                            SourceExpression fieldAccess = (SourceExpression)sourceElement;
                            switch (fieldAccess.getSymbolKind()) {
                                case 57: {
                                    SourceExpression enumAccess = factory.createExpression(this._fqEnumName + "." + fieldAccess.getText());
                                    fieldAccess.replaceSelf((SourceElement)enumAccess);
                                    break block1;
                                }
                                case 49: {
                                    SourceDotExpression dotExpression = (SourceDotExpression)fieldAccess;
                                    String name = dotExpression.getName();
                                    SourceExpression enumAccess = factory.createExpression(this._fqEnumName + "." + name);
                                    dotExpression.replaceSelf((SourceElement)enumAccess);
                                    break block1;
                                }
                            }
                            break;
                        }
                    }
                }
                ++i;
            }
            refactoringCommandSupport.commit(this.getContext(), "Create Enumeration");
        }
        catch (Exception e) {
            e.printStackTrace();
            refactoringCommandSupport.abort();
        }
        return true;
    }
}

