/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.duplicate;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.refactoring.util.RefactoringCommandSupport;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.audit.java.JavaHelper;
import oracle.jdevimpl.refactoring.ElementAt;
import oracle.jdevimpl.refactoring.oprs.duplicate.DuplicateClassDialog;

public class DuplicateClassController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        boolean canHandle = false;
        canHandle = this.handle(context, false);
        action.setEnabled(canHandle);
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        this.handle(context, true);
        return true;
    }

    private boolean handle(Context context, boolean doit) {
        SourceClass sourceClass;
        boolean canHandle = false;
        if (context != null && context.getWorkspace() != null && context.getProject() != null && (sourceClass = ElementAt.getSourceClassAt(context, false, false)) != null) {
            canHandle = DuplicateClassController.handle(context, sourceClass, doit);
        }
        return canHandle;
    }

    public static boolean handle(Context context, SourceClass sourceClass, boolean doit) {
        boolean canHandle;
        block1: {
            SourceFile sourceFile;
            SourceClass mainClass;
            canHandle = false;
            if (sourceClass == null || sourceClass.isMemberClass() || (mainClass = (sourceFile = sourceClass.getOwningSourceFile()).getSourcePrimaryClass()) != sourceClass) break block1;
            canHandle = true;
            if (doit) {
                DuplicateClassController.whenDuplicateClass(context, sourceClass);
            }
        }
        return canHandle;
    }

    public static boolean whenDuplicateClass(Context context, SourceClass srcSourceClass) {
        boolean ret = false;
        DuplicateClassDialog duplicateClassDialog = new DuplicateClassDialog(context, srcSourceClass);
        if (duplicateClassDialog.runDialog()) {
            String newFqClassName = duplicateClassDialog.getNewName();
            RefactoringCommandSupport refactoringCommandSupport = new RefactoringCommandSupport();
            try {
                String srcClassName = srcSourceClass.getName();
                String oldFqClassName = srcSourceClass.getQualifiedName();
                String newPackageName = Util.getPackageName(newFqClassName);
                String newClassName = Util.getClassName(newFqClassName);
                SourceFile targetSourceFile = refactoringCommandSupport.createSourceFile(context, newPackageName, newClassName);
                SourcePreferences prefs = srcSourceClass.getOwningSourceFile().getPreferences();
                boolean prevValue = prefs.getBoolean(66);
                prefs.setBoolean(66, false);
                SourceClass targetSourceClass = (SourceClass)srcSourceClass.cloneSelf(targetSourceFile);
                prefs.setBoolean(66, prevValue);
                targetSourceFile.setPackageName(newPackageName);
                targetSourceClass.addSelf((SourceElement)targetSourceFile);
                List imports = srcSourceClass.getOwningSourceFile().getSourceImports();
                for (SourceImport sourceImport : imports) {
                    JavaHelper.addImport(targetSourceFile, sourceImport.getName());
                }
                ArrayList<SourceName> namesToChange = new ArrayList<SourceName>();
                List sourceNames = SourceElementAsList.asList((SourceElement)targetSourceClass, (int)20);
                int i = 0;
                while (i < sourceNames.size()) {
                    SourceName sourceName = (SourceName)sourceNames.get(i);
                    String name = sourceName.getName();
                    if (srcClassName.equals(name) || oldFqClassName.equals(name)) {
                        SourceElement parent = sourceName.getParent();
                        switch (parent.getSymbolKind()) {
                            case 3: 
                            case 27: 
                            case 49: 
                            case 57: {
                                JavaHasType javaHasType = (JavaHasType)parent;
                                JavaType resolvedType = javaHasType.getResolvedType();
                                while (resolvedType.getComponentType() != null) {
                                    resolvedType = resolvedType.getComponentType();
                                }
                                if (!targetSourceClass.equals((Object)resolvedType)) break;
                                namesToChange.add(sourceName);
                                break;
                            }
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < namesToChange.size()) {
                    SourceElement sourceElement = (SourceElement)namesToChange.get(i2);
                    switch (sourceElement.getSymbolKind()) {
                        case 20: {
                            SourceName sourceName = (SourceName)sourceElement;
                            sourceName.setValue(newClassName);
                            break;
                        }
                        case 49: {
                            SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                            SourceFactory factory = targetSourceFile.getFactory();
                            SourceExpression newExpression = factory.createExpressionFromText(newFqClassName);
                            sourceDotExpression.replaceSelf((SourceElement)newExpression);
                            break;
                        }
                    }
                    ++i2;
                }
                refactoringCommandSupport.setOpenCreatedFiles(true);
                ret = refactoringCommandSupport.commit(context, RefactoringArb.getString(119));
            }
            catch (Exception e) {
                e.printStackTrace();
                refactoringCommandSupport.abort();
            }
        }
        return ret;
    }
}

