/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.oprs.duplicate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.refactoring.dialogs.BaseDialog;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class DuplicateClassDialog
extends BaseDialog {
    public static final String PREFERENCE_KEY = "DUPLICATE_CLASS_DEFAULTS";
    private JTextField _textField;
    private String _oldName;
    private SourceClass _sourceClass;

    public DuplicateClassDialog(Context context, SourceClass sourceClass) {
        super(PREFERENCE_KEY, context);
        Assert.check((!sourceClass.isMemberClass() ? 1 : 0) != 0);
        this._sourceClass = sourceClass;
        this.init();
        this._oldName = this._sourceClass.getQualifiedName();
        this.setOldName(this._oldName);
    }

    public boolean runDialog() {
        SourceFile owningFile;
        URL url;
        URL parent;
        URL newUrl;
        String platformPathName;
        boolean ret = super.runDialog();
        if (ret && (platformPathName = URLFileSystem.getPlatformPathName((URL)(newUrl = URLFactory.newURL((URL)(parent = URLFileSystem.getParent((URL)(url = (owningFile = this._sourceClass.getOwningSourceFile()).getURL()))), (String)(this.getNewName() + ".java"))))).length() > 255) {
            Util.showRefactoringErrorMessage(278);
            ret = false;
        }
        return ret;
    }

    private void init() {
        JLabel renameToLbl = new JLabel();
        this._textField = new JTextField(30);
        this.updateOnChanges(this._textField);
        int key = this._sourceClass.isInterface() ? 302 : 318;
        ResourceUtils.resLabel((JLabel)renameToLbl, (Component)this._textField, (String)RefactoringArb.getString(key));
        JLabel message = new JLabel();
        message.setPreferredSize(this._textField.getPreferredSize());
        this.setMessageLabel(message);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)renameToLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._textField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)message, new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 16, 2, insets, 0, 0));
    }

    public String getNewName() {
        return this._textField.getText();
    }

    private void setOldName(String oldName) {
        this._textField.setText(oldName);
        this._textField.setCaretPosition(0);
        this._textField.setSelectionEnd(oldName.length());
    }

    protected void updateSettings(CopyableInteger settings) {
    }

    protected JComponent getDefaultFocusedComponent() {
        return this._textField;
    }

    protected String getHelpTopicID() {
        return "f1_jrf_dduplicatetype_html";
    }

    protected int getDefaultPreferences() {
        return 0;
    }

    protected String getTitle() {
        String oldClassName = this._sourceClass.getName();
        int key = this._sourceClass.isInterface() ? 342 : 288;
        String title = MessageFormat.format(RefactoringArb.getString(key), oldClassName);
        return title;
    }

    protected void updateOKButton() {
        if (this.isInitialized()) {
            String message = "";
            boolean isValid = true;
            String text = this.getNewName();
            if (text.length() == 0) {
                isValid = false;
            } else if (this._oldName.equals(text)) {
                isValid = false;
            } else if (text.endsWith(".")) {
                isValid = false;
            } else if (!NamingUtil.isPackageIdentifier((String)text)) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (text.lastIndexOf(36) >= 0) {
                message = RefactoringArb.getString(164);
                isValid = false;
            } else if (this.isClassAlreadyPresent(text)) {
                message = MessageFormat.format(RefactoringArb.getString(163), text);
                isValid = false;
            }
            this.setMessage(message, isValid);
            this.setOKButtonEnabled(isValid);
        }
    }

    private boolean isClassAlreadyPresent(String text) {
        SourceFile owningFile = this._sourceClass.getOwningSourceFile();
        JavaProvider provider = owningFile.getProvider();
        SourceClass newClass = provider.getSourceClass(text);
        return newClass != null;
    }
}

